/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public class UUIDConverter {
    public static final UUID MIN_UUID = new UUID(0L, 0L);
    private static JsonReader.ReadObject<UUID> Reader = new JsonReader.ReadObject<UUID>(){

        @Override
        public UUID read(JsonReader jsonReader) throws IOException {
            return UUIDConverter.deserialize(jsonReader);
        }
    };

    public static void serializeNullable(UUID uUID, Writer writer) throws IOException {
        if (uUID == null) {
            writer.write("null");
        } else {
            UUIDConverter.serialize(uUID, writer);
        }
    }

    public static void serialize(UUID uUID, Writer writer) throws IOException {
        writer.write(34);
        writer.write(uUID.toString());
        writer.write(34);
    }

    public static UUID deserialize(JsonReader jsonReader) throws IOException {
        return UUID.fromString(jsonReader.readSimpleString());
    }

    public static ArrayList<UUID> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<UUID> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(Reader, collection);
    }

    public static ArrayList<UUID> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<UUID> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(Reader, collection);
    }
}

