/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConverter {
    private static DocumentBuilder documentBuilder;
    private static JsonReader.ReadObject<Element> Reader;

    public static void serializeNullable(Element element, Writer writer) throws IOException {
        if (element == null) {
            writer.write("null");
        } else {
            XmlConverter.serialize(element, writer);
        }
    }

    public static void serialize(Element element, Writer writer) throws IOException {
        Document document = element.getOwnerDocument();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lSOutput.setCharacterStream(stringWriter);
        lSSerializer.write(document, lSOutput);
        StringConverter.serialize(stringWriter.toString(), writer);
    }

    public static Element deserialize(JsonReader jsonReader) throws IOException {
        try {
            InputSource inputSource = new InputSource(new StringReader(jsonReader.readString()));
            return documentBuilder.parse(inputSource).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    public static ArrayList<Element> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Element> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(Reader, collection);
    }

    public static ArrayList<Element> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Element> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(Reader, collection);
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        Reader = new JsonReader.ReadObject<Element>(){

            @Override
            public Element read(JsonReader jsonReader) throws IOException {
                return XmlConverter.deserialize(jsonReader);
            }
        };
    }
}

