/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NumberConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateConverter {
    public static final DateTime MIN_DATE_TIME = DateTime.parse((String)"0001-01-01T00:00:00Z");
    public static final LocalDate MIN_LOCAL_DATE = new LocalDate(1, 1, 1);
    private static final DateTimeFormatter localDateParser = ISODateTimeFormat.localDateParser();
    private static final DateTimeFormatter dateTimeParser = ISODateTimeFormat.dateTimeParser().withOffsetParsed();
    private static final DateTimeZone utcZone = DateTimeZone.UTC;
    private static JsonReader.ReadObject<DateTime> DateTimeReader = new JsonReader.ReadObject<DateTime>(){

        @Override
        public DateTime read(JsonReader jsonReader) throws IOException {
            return DateConverter.deserializeDateTime(jsonReader);
        }
    };
    private static JsonReader.ReadObject<LocalDate> LocalDateReader = new JsonReader.ReadObject<LocalDate>(){

        @Override
        public LocalDate read(JsonReader jsonReader) throws IOException {
            return DateConverter.deserializeLocalDate(jsonReader);
        }
    };

    public static void serializeNullable(DateTime dateTime, JsonWriter jsonWriter) {
        if (dateTime == null) {
            jsonWriter.writeNull();
        } else {
            DateConverter.serialize(dateTime, jsonWriter);
        }
    }

    public static void serialize(DateTime dateTime, JsonWriter jsonWriter) {
        byte[] byArray = jsonWriter.tmp;
        byArray[0] = 34;
        int n = dateTime.getYear();
        NumberConverter.write4(n, byArray, 1);
        byArray[5] = 45;
        NumberConverter.write2(dateTime.getMonthOfYear(), byArray, 6);
        byArray[8] = 45;
        NumberConverter.write2(dateTime.getDayOfMonth(), byArray, 9);
        byArray[11] = 84;
        NumberConverter.write2(dateTime.getHourOfDay(), byArray, 12);
        byArray[14] = 58;
        NumberConverter.write2(dateTime.getMinuteOfHour(), byArray, 15);
        byArray[17] = 58;
        NumberConverter.write2(dateTime.getSecondOfMinute(), byArray, 18);
        int n2 = dateTime.getMillisOfSecond();
        if (n2 != 0) {
            byArray[20] = 46;
            int n3 = n2 / 100;
            int n4 = n2 - n3 * 100;
            byArray[21] = (byte)(n3 + 48);
            if (n4 != 0) {
                NumberConverter.write2(n4, byArray, 22);
                DateConverter.writeTimezone(byArray, 24, dateTime, jsonWriter);
            } else {
                DateConverter.writeTimezone(byArray, 22, dateTime, jsonWriter);
            }
        } else {
            DateConverter.writeTimezone(byArray, 20, dateTime, jsonWriter);
        }
    }

    private static void writeTimezone(byte[] byArray, int n, DateTime dateTime, JsonWriter jsonWriter) {
        DateTimeZone dateTimeZone = dateTime.getZone();
        if (utcZone.equals((Object)dateTimeZone) || dateTimeZone == null) {
            byArray[n] = 90;
            byArray[n + 1] = 34;
            jsonWriter.writeBuffer(n + 2);
        } else {
            long l = dateTime.getMillis();
            int n2 = dateTimeZone.getOffset(l);
            if (n2 < 0) {
                byArray[n] = 45;
                n2 = -n2;
            } else {
                byArray[n] = 43;
            }
            int n3 = n2 / 3600000;
            int n4 = n2 - n3 * 3600000;
            NumberConverter.write2(n3, byArray, n + 1);
            byArray[n + 3] = 58;
            NumberConverter.write2(n4 / 60000, byArray, n + 4);
            byArray[n + 6] = 34;
            jsonWriter.writeBuffer(n + 7);
        }
    }

    public static DateTime deserializeDateTime(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readSimpleQuote();
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        if (n > 18 && n < 25 && cArray[n - 1] == 'Z' && cArray[4] == '-' && cArray[7] == '-' && (cArray[10] == 'T' || cArray[10] == 't' || cArray[10] == ' ') && cArray[13] == ':' && cArray[16] == ':') {
            int n2 = NumberConverter.read4(cArray, 0);
            int n3 = NumberConverter.read2(cArray, 5);
            int n4 = NumberConverter.read2(cArray, 8);
            int n5 = NumberConverter.read2(cArray, 11);
            int n6 = NumberConverter.read2(cArray, 14);
            int n7 = NumberConverter.read2(cArray, 17);
            if (cArray[19] == '.') {
                int n8;
                switch (n) {
                    case 22: {
                        n8 = 100 * (cArray[20] - 48);
                        break;
                    }
                    case 23: {
                        n8 = 100 * (cArray[20] - 48) + 10 * (cArray[21] - 48);
                        break;
                    }
                    default: {
                        n8 = 100 * (cArray[20] - 48) + 10 * (cArray[21] - 48) + cArray[22] - 48;
                    }
                }
                return new DateTime(n2, n3, n4, n5, n6, n7, n8, utcZone);
            }
            return new DateTime(n2, n3, n4, n5, n6, n7, 0, utcZone);
        }
        return dateTimeParser.parseDateTime(new String(cArray, 0, n));
    }

    public static ArrayList<DateTime> deserializeDateTimeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(DateTimeReader);
    }

    public static void deserializeDateTimeCollection(JsonReader jsonReader, Collection<DateTime> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(DateTimeReader, collection);
    }

    public static ArrayList<DateTime> deserializeDateTimeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(DateTimeReader);
    }

    public static void deserializeDateTimeNullableCollection(JsonReader jsonReader, Collection<DateTime> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(DateTimeReader, collection);
    }

    public static void serializeNullable(LocalDate localDate, JsonWriter jsonWriter) {
        if (localDate == null) {
            jsonWriter.writeNull();
        } else {
            DateConverter.serialize(localDate, jsonWriter);
        }
    }

    public static void serialize(LocalDate localDate, JsonWriter jsonWriter) {
        byte[] byArray = jsonWriter.tmp;
        byArray[0] = 34;
        int n = localDate.getYear();
        NumberConverter.write4(n, byArray, 1);
        byArray[5] = 45;
        NumberConverter.write2(localDate.getMonthOfYear(), byArray, 6);
        byArray[8] = 45;
        NumberConverter.write2(localDate.getDayOfMonth(), byArray, 9);
        byArray[11] = 34;
        jsonWriter.writeBuffer(12);
    }

    public static LocalDate deserializeLocalDate(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readSimpleQuote();
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        if (n == 10 && cArray[4] == '-' && cArray[7] == '-') {
            int n2 = NumberConverter.read4(cArray, 0);
            int n3 = NumberConverter.read2(cArray, 5);
            int n4 = NumberConverter.read2(cArray, 8);
            return new LocalDate(n2, n3, n4);
        }
        return localDateParser.parseLocalDate(new String(cArray, 0, n));
    }

    public static ArrayList<LocalDate> deserializeLocalDateCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(LocalDateReader);
    }

    public static void deserializeLocalDateCollection(JsonReader jsonReader, Collection<LocalDate> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(LocalDateReader, collection);
    }

    public static ArrayList<LocalDate> deserializeLocalDateNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(LocalDateReader);
    }

    public static void deserializeLocalDateNullableCollection(JsonReader jsonReader, Collection<LocalDate> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(LocalDateReader, collection);
    }
}

