/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NumberConverter;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class GeomConverter {
    private static JsonReader.ReadObject<Point2D> LocationReader = new JsonReader.ReadObject<Point2D>(){

        @Override
        public Point2D read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeLocation(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Point> PointReader = new JsonReader.ReadObject<Point>(){

        @Override
        public Point read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializePoint(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Rectangle2D> RectangleReader = new JsonReader.ReadObject<Rectangle2D>(){

        @Override
        public Rectangle2D read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeRectangle(jsonReader);
        }
    };

    public static void serializeLocationNullable(Point2D point2D, JsonWriter jsonWriter) {
        if (point2D == null) {
            jsonWriter.writeNull();
        } else {
            GeomConverter.serializeLocation(point2D, jsonWriter);
        }
    }

    public static void serializeLocation(Point2D point2D, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(point2D.getX(), jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(point2D.getY(), jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Point2D deserializeLocation(JsonReader jsonReader) throws IOException {
        return null;
    }

    public static ArrayList<Point2D> deserializeLocationCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(LocationReader);
    }

    public static void deserializeLocationCollection(JsonReader jsonReader, Collection<Point2D> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(LocationReader, collection);
    }

    public static ArrayList<Point2D> deserializeLocationNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(LocationReader);
    }

    public static void deserializeLocationNullableCollection(JsonReader jsonReader, Collection<Point2D> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(LocationReader, collection);
    }

    public static void serializePointNullable(Point point, JsonWriter jsonWriter) {
        if (point == null) {
            jsonWriter.writeNull();
        } else {
            GeomConverter.serializePoint(point, jsonWriter);
        }
    }

    public static void serializePoint(Point point, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(point.x, jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(point.y, jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Point deserializePoint(JsonReader jsonReader) throws IOException {
        return null;
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(PointReader);
    }

    public static void deserializePointCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(PointReader, collection);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(PointReader);
    }

    public static void deserializePointNullableCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(PointReader, collection);
    }

    public static void serializeRectangleNullable(Rectangle2D rectangle2D, JsonWriter jsonWriter) {
        if (rectangle2D == null) {
            jsonWriter.writeNull();
        } else {
            GeomConverter.serializeRectangle(rectangle2D, jsonWriter);
        }
    }

    public static void serializeRectangle(Rectangle2D rectangle2D, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(rectangle2D.getX(), jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(rectangle2D.getY(), jsonWriter);
        jsonWriter.writeAscii(",\"Width\":");
        NumberConverter.serialize(rectangle2D.getWidth(), jsonWriter);
        jsonWriter.writeAscii(",\"Height\":");
        NumberConverter.serialize(rectangle2D.getHeight(), jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Rectangle2D deserializeRectangle(JsonReader jsonReader) throws IOException {
        return null;
    }

    public static ArrayList<Rectangle2D> deserializeRectangleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(RectangleReader);
    }

    public static void deserializeRectangleCollection(JsonReader jsonReader, Collection<Rectangle2D> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(RectangleReader, collection);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(RectangleReader);
    }

    public static void deserializeRectangleNullableCollection(JsonReader jsonReader, Collection<Rectangle2D> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(RectangleReader, collection);
    }
}

