/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.Base64;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class JsonWriter
extends Writer {
    public final byte[] tmp = new byte[48];
    private byte[] result;
    private int position;
    private static final Charset utf8 = Charset.forName("UTF-8");
    public static final byte OBJECT_START = 123;
    public static final byte OBJECT_END = 125;
    public static final byte ARRAY_START = 91;
    public static final byte ARRAY_END = 93;
    public static final byte COMMA = 44;
    public static final byte SEMI = 58;
    public static final byte QUOTE = 34;
    public static final byte ESCAPE = 92;

    public JsonWriter() {
        this(512);
    }

    public JsonWriter(int n) {
        this(new byte[n]);
    }

    public JsonWriter(byte[] byArray) {
        this.result = byArray;
    }

    public final void writeNull() {
        int n = this.position;
        this.position += 4;
        if (this.position >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        byte[] byArray = this.result;
        byArray[n] = 110;
        byArray[n + 1] = 117;
        byArray[n + 2] = 108;
        byArray[n + 3] = 108;
    }

    public final void writeByte(byte by) {
        if (this.position == this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        this.result[this.position++] = by;
    }

    public final void writeString(String string) {
        int n = string.length();
        if (this.position + (n << 2) + (n << 1) + 2 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + (n << 2) + (n << 1) + 2);
        }
        byte[] byArray = this.result;
        byArray[this.position] = 34;
        int n2 = this.position + 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                byArray[n2++] = 92;
                byArray[n2++] = 34;
                continue;
            }
            if (c == '\\') {
                byArray[n2++] = 92;
                byArray[n2++] = 92;
                continue;
            }
            if (c < ' ') {
                if (c == '\b') {
                    byArray[n2++] = 92;
                    byArray[n2++] = 98;
                    continue;
                }
                if (c == '\t') {
                    byArray[n2++] = 92;
                    byArray[n2++] = 116;
                    continue;
                }
                if (c == '\n') {
                    byArray[n2++] = 92;
                    byArray[n2++] = 110;
                    continue;
                }
                if (c == '\f') {
                    byArray[n2++] = 92;
                    byArray[n2++] = 102;
                    continue;
                }
                if (c == '\r') {
                    byArray[n2++] = 92;
                    byArray[n2++] = 114;
                    continue;
                }
                byArray[n2] = 92;
                byArray[n2 + 1] = 117;
                byArray[n2 + 2] = 48;
                byArray[n2 + 3] = 48;
                switch (c) {
                    case '\u0000': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 48;
                        break;
                    }
                    case '\u0001': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 49;
                        break;
                    }
                    case '\u0002': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 50;
                        break;
                    }
                    case '\u0003': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 51;
                        break;
                    }
                    case '\u0004': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 52;
                        break;
                    }
                    case '\u0005': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 53;
                        break;
                    }
                    case '\u0006': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 54;
                        break;
                    }
                    case '\u0007': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 55;
                        break;
                    }
                    case '\u000b': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 66;
                        break;
                    }
                    case '\u000e': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 69;
                        break;
                    }
                    case '\u000f': {
                        byArray[n2 + 4] = 48;
                        byArray[n2 + 5] = 70;
                        break;
                    }
                    case '\u0010': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 48;
                        break;
                    }
                    case '\u0011': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 49;
                        break;
                    }
                    case '\u0012': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 50;
                        break;
                    }
                    case '\u0013': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 51;
                        break;
                    }
                    case '\u0014': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 52;
                        break;
                    }
                    case '\u0015': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 53;
                        break;
                    }
                    case '\u0016': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 54;
                        break;
                    }
                    case '\u0017': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 55;
                        break;
                    }
                    case '\u0018': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 56;
                        break;
                    }
                    case '\u0019': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 57;
                        break;
                    }
                    case '\u001a': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 65;
                        break;
                    }
                    case '\u001b': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 66;
                        break;
                    }
                    case '\u001c': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 67;
                        break;
                    }
                    case '\u001d': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 68;
                        break;
                    }
                    case '\u001e': {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 69;
                        break;
                    }
                    default: {
                        byArray[n2 + 4] = 49;
                        byArray[n2 + 5] = 70;
                    }
                }
                n2 += 6;
                continue;
            }
            if (c < '\u007f') {
                byArray[n2++] = (byte)c;
                continue;
            }
            int n3 = string.codePointAt(i);
            if (Character.isSupplementaryCodePoint(n3)) {
                ++i;
            }
            if (n3 == 127) {
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 <= 2047) {
                byArray[n2++] = (byte)(0xC0 | n3 >> 6 & 0x1F);
                byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            if (n3 < 55296 || n3 > 57343 && n3 <= 65533) {
                byArray[n2++] = (byte)(0xE0 | n3 >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            if (n3 >= 65536 && n3 <= 0x10FFFF) {
                byArray[n2++] = (byte)(0xF0 | n3 >> 18 & 7);
                byArray[n2++] = (byte)(0x80 | n3 >> 12 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            throw new RuntimeException("Unknown unicode codepoint in string! " + Integer.toHexString(n3));
        }
        byArray[n2] = 34;
        this.position = n2 + 1;
    }

    public final void writeBuffer(int n, int n2) {
        if (this.position + 64 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        int n3 = this.position;
        byte[] byArray = this.result;
        for (int i = n; i < this.tmp.length && i != n2; ++i) {
            byArray[n3++] = this.tmp[i];
        }
        this.position = n3;
    }

    public final void writeBuffer(int n) {
        if (this.position + 64 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        int n2 = this.position;
        byte[] byArray = this.result;
        for (int i = 0; i < this.tmp.length && i != n; ++i) {
            byArray[n2 + i] = this.tmp[i];
        }
        this.position += n;
    }

    public final void writeAscii(String string) {
        int n = string.length();
        if (this.position + n >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + n);
        }
        int n2 = this.position;
        byte[] byArray = this.result;
        for (int i = 0; i < string.length(); ++i) {
            byArray[n2 + i] = (byte)string.charAt(i);
        }
        this.position += n;
    }

    public final void writeAscii(byte[] byArray) {
        int n = byArray.length;
        if (this.position + n >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + n);
        }
        int n2 = this.position;
        byte[] byArray2 = this.result;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[n2 + i] = byArray[i];
        }
        this.position += n;
    }

    public final void writeBinary(byte[] byArray) {
        if (this.position + (byArray.length << 1) + 2 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + (byArray.length << 1) + 2);
        }
        this.result[this.position++] = 34;
        this.position += Base64.encodeToBytes(byArray, this.result, this.position);
        this.result[this.position++] = 34;
    }

    public String toString() {
        return new String(this.result, 0, this.position, utf8);
    }

    public final Bytes toBytes() {
        return new Bytes(this.result, this.position);
    }

    public final byte[] toByteArray() {
        return Arrays.copyOf(this.result, this.position);
    }

    public final void reset() {
        this.position = 0;
    }

    @Override
    public void write(int n) throws IOException {
        this.tmp[0] = (byte)n;
        this.writeString(new String(this.tmp, 0, 1));
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this.writeString(new String(cArray, n, n2));
    }

    @Override
    public void write(String string, int n, int n2) {
        this.writeString(string.substring(n, n + n2));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.position = 0;
    }

    public static class Bytes {
        public final byte[] content;
        public final int length;

        public Bytes(byte[] byArray, int n) {
            this.content = byArray;
            this.length = n;
        }
    }
}

