/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class NetConverter {
    private static JsonReader.ReadObject<URI> UriReader = new JsonReader.ReadObject<URI>(){

        @Override
        public URI read(JsonReader jsonReader) throws IOException {
            return NetConverter.deserializeUri(jsonReader);
        }
    };
    private static JsonReader.ReadObject<InetAddress> AddressReader = new JsonReader.ReadObject<InetAddress>(){

        @Override
        public InetAddress read(JsonReader jsonReader) throws IOException {
            return NetConverter.deserializeIp(jsonReader);
        }
    };

    public static void serializeNullable(URI uRI, JsonWriter jsonWriter) {
        if (uRI == null) {
            jsonWriter.writeNull();
        } else {
            NetConverter.serialize(uRI, jsonWriter);
        }
    }

    public static void serialize(URI uRI, JsonWriter jsonWriter) {
        StringConverter.serializeShort(uRI.toString(), jsonWriter);
    }

    public static URI deserializeUri(JsonReader jsonReader) throws IOException {
        return URI.create(jsonReader.readString());
    }

    public static ArrayList<URI> deserializeUriCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(UriReader);
    }

    public static void deserializeUriCollection(JsonReader jsonReader, Collection<URI> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(UriReader, collection);
    }

    public static ArrayList<URI> deserializeUriNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(UriReader);
    }

    public static void deserializeUriNullableCollection(JsonReader jsonReader, Collection<URI> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(UriReader, collection);
    }

    public static void serializeNullable(InetAddress inetAddress, JsonWriter jsonWriter) {
        if (inetAddress == null) {
            jsonWriter.writeNull();
        } else {
            NetConverter.serialize(inetAddress, jsonWriter);
        }
    }

    public static void serialize(InetAddress inetAddress, JsonWriter jsonWriter) {
        jsonWriter.writeByte((byte)34);
        jsonWriter.writeAscii(inetAddress.toString());
        jsonWriter.writeByte((byte)34);
    }

    public static InetAddress deserializeIp(JsonReader jsonReader) throws IOException {
        return InetAddress.getByName(jsonReader.readSimpleString());
    }

    public static ArrayList<InetAddress> deserializeIpCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(AddressReader);
    }

    public static void deserializeIpCollection(JsonReader jsonReader, Collection<InetAddress> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(AddressReader, collection);
    }

    public static ArrayList<InetAddress> deserializeIpNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(AddressReader);
    }

    public static void deserializeIpNullableCollection(JsonReader jsonReader, Collection<InetAddress> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(AddressReader, collection);
    }
}

