/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class NumberConverter {
    private static final int[] Digits = new int[100];
    private static JsonReader.ReadObject<Double> DoubleReader;
    private static JsonReader.ReadObject<Float> FloatReader;
    private static final byte MINUS = 45;
    private static JsonReader.ReadObject<Integer> IntReader;
    private static JsonReader.ReadObject<Long> LongReader;
    private static JsonReader.ReadObject<BigDecimal> DecimalReader;

    static void write4(int n, byte[] byArray, int n2) {
        if (n > 9999) {
            throw new IllegalArgumentException("Only 4 digits numbers are supported. Provided: " + n);
        }
        int n3 = n / 100;
        int n4 = Digits[n3];
        int n5 = Digits[n - ((n3 << 6) + (n3 << 5) + (n3 << 2))];
        byArray[n2] = (byte)(n4 >> 8);
        byArray[n2 + 1] = (byte)n4;
        byArray[n2 + 2] = (byte)(n5 >> 8);
        byArray[n2 + 3] = (byte)n5;
    }

    static void write2(int n, byte[] byArray, int n2) {
        int n3 = Digits[n];
        byArray[n2] = (byte)(n3 >> 8);
        byArray[n2 + 1] = (byte)n3;
    }

    static int read2(char[] cArray, int n) {
        int n2 = cArray[n] - 48;
        return (n2 << 3) + (n2 << 1) + cArray[n + 1] - 48;
    }

    static int read4(char[] cArray, int n) {
        int n2 = cArray[n + 1] - 48;
        int n3 = cArray[n + 2] - 48;
        return (cArray[n] - 48) * 1000 + (n2 << 6) + (n2 << 5) + (n2 << 2) + (n3 << 3) + (n3 << 1) + cArray[n + 3] - 48;
    }

    public static void serializeNullable(Double d, JsonWriter jsonWriter) {
        if (d == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(d, jsonWriter);
        }
    }

    private static BigDecimal parseNumberGeneric(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 > 0 && Character.isWhitespace(cArray[n3 - 1]); --n3) {
        }
        try {
            return new BigDecimal(cArray, 0, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing number at position: " + (n2 - n), numberFormatException);
        }
    }

    public static void serialize(double d, JsonWriter jsonWriter) {
        if (Double.isNaN(d)) {
            jsonWriter.writeAscii("\"NaN\"");
        } else if (Double.isInfinite(d)) {
            long l = Double.doubleToLongBits(d);
            if ((l & Long.MIN_VALUE) != 0L) {
                jsonWriter.writeAscii("\"-Infinity\"");
            } else {
                jsonWriter.writeAscii("\"Infinity\"");
            }
        } else {
            jsonWriter.writeAscii(Double.toString(d));
        }
    }

    private static char[] readLongNumber(JsonReader jsonReader, char[] cArray) throws IOException {
        char c;
        int n;
        for (n = 0; n < cArray.length; ++n) {
            c = cArray[n];
            if (c >= '0' && c < '9' || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E') continue;
            return cArray;
        }
        char[] cArray2 = Arrays.copyOf(cArray, cArray.length * 2);
        while (true) {
            c = (char)jsonReader.read();
            cArray2[n++] = c;
            if ((c < '0' || c >= '9') && c != '-' && c != '+' && c != '.' && c != 'e' && c != 'E') {
                return Arrays.copyOf(cArray2, n - 1);
            }
            if (n < cArray2.length) continue;
            cArray2 = Arrays.copyOf(cArray2, cArray2.length * 2);
        }
    }

    public static double deserializeDouble(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 34) {
            int n = jsonReader.getCurrentIndex();
            char[] cArray = jsonReader.readSimpleQuote();
            double d = NumberConverter.parseDoubleGeneric(cArray, jsonReader.getCurrentIndex() - n - 1, n + 1);
            jsonReader.read();
            return d;
        }
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart() - 1;
        if (n2 > 18) {
            if (n2 == cArray.length - 1) {
                char[] cArray2 = NumberConverter.readLongNumber(jsonReader, cArray);
                return NumberConverter.parseDoubleGeneric(cArray2, cArray2.length, n);
            }
            return NumberConverter.parseDoubleGeneric(cArray, n2, n);
        }
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeDouble(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveDouble(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveDouble(cArray, n, n2, 0);
    }

    private static double parsePositiveDouble(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < cArray.length) {
            if (n3 == n2) {
                return l;
            }
            n5 = cArray[n3];
            if (n5 == 46) break;
            n4 = cArray[n3] - 48;
            if (n4 < 0 || n4 >= 10) {
                return NumberConverter.parseDoubleGeneric(cArray, n2, n);
            }
            l = (l << 3) + (l << 1) + (long)n4;
            ++n3;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < cArray.length && n3 != n2) {
                int n6 = cArray[n3] - 48;
                if (n6 < 0 || n6 >= 10) {
                    return NumberConverter.parseDoubleGeneric(cArray, n2, n);
                }
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) + (long)n6;
                ++n3;
            }
            return (double)l / (double)n4;
        }
        return l;
    }

    private static double parseNegativeDouble(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < cArray.length) {
            if (n3 == n2) {
                return l;
            }
            n5 = cArray[n3];
            if (n5 == 46) break;
            n4 = cArray[n3] - 48;
            if (n4 < 0 || n4 >= 10) {
                return NumberConverter.parseDoubleGeneric(cArray, n2, n);
            }
            l = (l << 3) + (l << 1) - (long)n4;
            ++n3;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < cArray.length && n3 != n2) {
                int n6 = cArray[n3] - 48;
                if (n6 < 0 || n6 >= 10) {
                    return NumberConverter.parseDoubleGeneric(cArray, n2, n);
                }
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) - (long)n6;
                ++n3;
            }
            return (double)l / (double)n4;
        }
        return l;
    }

    private static double parseDoubleGeneric(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 > 0 && Character.isWhitespace(cArray[n3 - 1]); --n3) {
        }
        try {
            return Double.parseDouble(new String(cArray, 0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing float number at position: " + (n2 - n), numberFormatException);
        }
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(DoubleReader);
    }

    public static void deserializeDoubleCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(DoubleReader, collection);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(DoubleReader);
    }

    public static void deserializeDoubleNullableCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(DoubleReader, collection);
    }

    public static void serializeNullable(Float f, JsonWriter jsonWriter) {
        if (f == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(f.floatValue(), jsonWriter);
        }
    }

    public static void serialize(float f, JsonWriter jsonWriter) {
        if (Float.isNaN(f)) {
            jsonWriter.writeAscii("\"NaN\"");
        } else if (Float.isInfinite(f)) {
            int n = Float.floatToIntBits(f);
            if ((n & Integer.MIN_VALUE) != 0) {
                jsonWriter.writeAscii("\"-Infinity\"");
            } else {
                jsonWriter.writeAscii("\"Infinity\"");
            }
        } else {
            jsonWriter.writeAscii(Float.toString(f));
        }
    }

    public static float deserializeFloat(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 34) {
            int n = jsonReader.getCurrentIndex();
            char[] cArray = jsonReader.readSimpleQuote();
            float f = NumberConverter.parseFloatGeneric(cArray, jsonReader.getCurrentIndex() - n - 1, n + 1);
            jsonReader.read();
            return f;
        }
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        if (n2 > 18) {
            if (n2 == cArray.length - 1) {
                char[] cArray2 = NumberConverter.readLongNumber(jsonReader, cArray);
                return NumberConverter.parseFloatGeneric(cArray2, cArray2.length, n);
            }
            return NumberConverter.parseFloatGeneric(cArray, n2, n);
        }
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeFloat(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveFloat(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveFloat(cArray, n, n2, 0);
    }

    private static float parsePositiveFloat(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < cArray.length) {
            if (n3 == n2) {
                return l;
            }
            n5 = cArray[n3];
            if (n5 == 46) break;
            n4 = cArray[n3] - 48;
            if (n4 < 0 || n4 >= 10) {
                return NumberConverter.parseFloatGeneric(cArray, n2, n);
            }
            l = (l << 3) + (l << 1) + (long)n4;
            ++n3;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < cArray.length && n3 != n2) {
                int n6 = cArray[n3] - 48;
                if (n6 < 0 || n6 >= 10) {
                    return NumberConverter.parseFloatGeneric(cArray, n2, n);
                }
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) + (long)n6;
                ++n3;
            }
            return (float)l / (float)n4;
        }
        return l;
    }

    private static float parseNegativeFloat(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < cArray.length) {
            if (n3 == n2) {
                return l;
            }
            n5 = cArray[n3];
            if (n5 == 46) break;
            n4 = cArray[n3] - 48;
            if (n4 < 0 || n4 >= 10) {
                return NumberConverter.parseFloatGeneric(cArray, n2, n);
            }
            l = (l << 3) + (l << 1) - (long)n4;
            ++n3;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < cArray.length && n3 != n2) {
                int n6 = cArray[n3] - 48;
                if (n6 < 0 || n6 >= 10) {
                    return NumberConverter.parseFloatGeneric(cArray, n2, n);
                }
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) - (long)n6;
                ++n3;
            }
            return (float)l / (float)n4;
        }
        return l;
    }

    private static float parseFloatGeneric(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 > 0 && Character.isWhitespace(cArray[n3 - 1]); --n3) {
        }
        try {
            return Float.parseFloat(new String(cArray, 0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing float number at position: " + (n2 - n), numberFormatException);
        }
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(FloatReader);
    }

    public static void deserializeFloatCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(FloatReader, collection);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(FloatReader);
    }

    public static void deserializeFloatNullableCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(FloatReader, collection);
    }

    public static void serializeNullable(Integer n, JsonWriter jsonWriter) {
        if (n == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(n, jsonWriter);
        }
    }

    public static void serialize(int n, JsonWriter jsonWriter) {
        if (n == Integer.MIN_VALUE) {
            jsonWriter.writeAscii("-2147483648");
        } else {
            int n2;
            byte[] byArray = jsonWriter.tmp;
            int n3 = 10;
            if (n < 0) {
                n2 = -n;
                jsonWriter.writeByte((byte)45);
            } else {
                n2 = n;
            }
            int n4 = 0;
            while (n3 > 1) {
                int n5 = n2 / 100;
                int n6 = n2 - ((n5 << 6) + (n5 << 5) + (n5 << 2));
                n2 = n5;
                n4 = Digits[n6];
                byArray[n3--] = (byte)n4;
                byArray[n3--] = (byte)(n4 >> 8);
                if (n2 != 0) continue;
            }
            jsonWriter.writeBuffer(n3 + 1 + (n4 >> 16), 11);
        }
    }

    public static int deserializeInt(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart() - 1;
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeInt(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveInt(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveInt(cArray, n, n2, 0);
    }

    private static int parsePositiveInt(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n3 < cArray.length && n3 != n2) {
            int n5 = cArray[n3] - 48;
            if (n5 < 0 || n5 >= 10) {
                BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
                if (bigDecimal.scale() <= 0) {
                    return bigDecimal.intValue();
                }
                throw new IOException("Error parsing int number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
            }
            n4 = (n4 << 3) + (n4 << 1) + n5;
            ++n3;
        }
        return n4;
    }

    private static int parseNegativeInt(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n3 < cArray.length && n3 != n2) {
            int n5 = cArray[n3] - 48;
            if (n5 < 0 || n5 >= 10) {
                BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
                if (bigDecimal.scale() <= 0) {
                    return bigDecimal.intValue();
                }
                throw new IOException("Error parsing int number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
            }
            n4 = (n4 << 3) + (n4 << 1) - n5;
            ++n3;
        }
        return n4;
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(IntReader);
    }

    public static void deserializeIntCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(IntReader, collection);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(IntReader);
    }

    public static void deserializeIntNullableCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(IntReader, collection);
    }

    public static void serializeNullable(Long l, JsonWriter jsonWriter) {
        if (l == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(l, jsonWriter);
        }
    }

    public static void serialize(long l, JsonWriter jsonWriter) {
        if (l == Long.MIN_VALUE) {
            jsonWriter.writeAscii("-9223372036854775808");
        } else {
            long l2;
            byte[] byArray = jsonWriter.tmp;
            int n = 20;
            if (l < 0L) {
                l2 = -l;
                jsonWriter.writeByte((byte)45);
            } else {
                l2 = l;
            }
            int n2 = 0;
            while (n > 1) {
                long l3 = l2 / 100L;
                int n3 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
                l2 = l3;
                n2 = Digits[n3];
                byArray[n--] = (byte)n2;
                byArray[n--] = (byte)(n2 >> 8);
                if (l2 != 0L) continue;
            }
            jsonWriter.writeBuffer(n + 1 + (n2 >> 16), 21);
        }
    }

    public static long deserializeLong(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart() - 1;
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeLong(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveLong(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveLong(cArray, n, n2, 0);
    }

    private static long parsePositiveLong(char[] cArray, int n, int n2, int n3) throws IOException {
        long l = 0L;
        while (n3 < cArray.length && n3 != n2) {
            int n4 = cArray[n3] - 48;
            if (n4 < 0 || n4 >= 10) {
                BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
                if (bigDecimal.scale() <= 0) {
                    return bigDecimal.longValue();
                }
                throw new IOException("Error parsing long number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
            }
            l = (l << 3) + (l << 1) + (long)n4;
            ++n3;
        }
        return l;
    }

    private static long parseNegativeLong(char[] cArray, int n, int n2, int n3) throws IOException {
        long l = 0L;
        while (n3 < cArray.length && n3 != n2) {
            int n4 = cArray[n3] - 48;
            if (n4 < 0 || n4 >= 10) {
                BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
                if (bigDecimal.scale() <= 0) {
                    return bigDecimal.longValue();
                }
                throw new IOException("Error parsing long number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
            }
            l = (l << 3) + (l << 1) - (long)n4;
            ++n3;
        }
        return l;
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(LongReader);
    }

    public static void deserializeLongCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(LongReader, collection);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(LongReader);
    }

    public static void deserializeLongNullableCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(LongReader, collection);
    }

    public static void serializeNullable(BigDecimal bigDecimal, JsonWriter jsonWriter) {
        if (bigDecimal == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeAscii(bigDecimal.toString());
        }
    }

    public static void serialize(BigDecimal bigDecimal, JsonWriter jsonWriter) {
        jsonWriter.writeAscii(bigDecimal.toString());
    }

    public static BigDecimal deserializeDecimal(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart() - 1;
        if (n2 > 18) {
            if (n2 == cArray.length - 1) {
                char[] cArray2 = NumberConverter.readLongNumber(jsonReader, cArray);
                return NumberConverter.parseNumberGeneric(cArray2, cArray2.length, n);
            }
            return NumberConverter.parseNumberGeneric(cArray, n2, n);
        }
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeDecimal(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveDecimal(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveDecimal(cArray, n, n2, 0);
    }

    private static BigDecimal parsePositiveDecimal(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < cArray.length) {
            if (n3 == n2) {
                return BigDecimal.valueOf(l);
            }
            n5 = cArray[n3];
            if (n5 == 46 || n5 == 101 || n5 == 69) break;
            n4 = n5 - 48;
            if (n4 < 0 || n4 >= 10) {
                return NumberConverter.parseNumberGeneric(cArray, n2, n);
            }
            l = (l << 3) + (l << 1) + (long)n4;
            ++n3;
        }
        if (n5 == 46) {
            int n6;
            n4 = ++n3;
            while (n3 < cArray.length) {
                if (n3 == n2) {
                    return BigDecimal.valueOf(l, n2 - n4);
                }
                n5 = cArray[n3];
                if (n5 == 101 || n5 == 69) break;
                n6 = n5 - 48;
                if (n6 < 0 || n6 >= 10) {
                    return NumberConverter.parseNumberGeneric(cArray, n2, n);
                }
                l = (l << 3) + (l << 1) + (long)n6;
                ++n3;
            }
            if (n5 == 101 || n5 == 69) {
                n6 = n3++;
                n5 = cArray[n3];
                int n7 = n5 == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
                return BigDecimal.valueOf(l, n6 - n4 - n7);
            }
            return BigDecimal.valueOf(l, n2 - n4);
        }
        if (n5 == 101 || n5 == 69) {
            n4 = (n5 = cArray[++n3]) == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
            return BigDecimal.valueOf(l, -n4);
        }
        return BigDecimal.valueOf(l);
    }

    private static BigDecimal parseNegativeDecimal(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < cArray.length) {
            if (n3 == n2) {
                return BigDecimal.valueOf(l);
            }
            n5 = cArray[n3];
            if (n5 == 46 || n5 == 101 || n5 == 69) break;
            n4 = n5 - 48;
            if (n4 < 0 || n4 >= 10) {
                return NumberConverter.parseNumberGeneric(cArray, n2, n);
            }
            l = (l << 3) + (l << 1) - (long)n4;
            ++n3;
        }
        if (n5 == 46) {
            int n6;
            n4 = ++n3;
            while (n3 < cArray.length) {
                if (n3 == n2) {
                    return BigDecimal.valueOf(l, n2 - n4);
                }
                n5 = cArray[n3];
                if (n5 == 101 || n5 == 69) break;
                n6 = n5 - 48;
                if (n6 < 0 || n6 >= 10) {
                    return NumberConverter.parseNumberGeneric(cArray, n2, n);
                }
                l = (l << 3) + (l << 1) - (long)n6;
                ++n3;
            }
            if (n5 == 101 || n5 == 69) {
                n6 = n3++;
                n5 = cArray[n3];
                int n7 = n5 == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
                return BigDecimal.valueOf(l, n6 - n4 - n7);
            }
            return BigDecimal.valueOf(l, n2 - n4);
        }
        if (n5 == 101 || n5 == 69) {
            n4 = (n5 = cArray[++n3]) == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
            return BigDecimal.valueOf(l, -n4);
        }
        return BigDecimal.valueOf(l);
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(DecimalReader);
    }

    public static void deserializeDecimalCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(DecimalReader, collection);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(DecimalReader);
    }

    public static void deserializeDecimalNullableCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(DecimalReader, collection);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            NumberConverter.Digits[i] = (i < 10 ? 65536 : 0) + (i / 10 + 48 << 8) + i % 10 + 48;
        }
        DoubleReader = new JsonReader.ReadObject<Double>(){

            @Override
            public Double read(JsonReader jsonReader) throws IOException {
                return NumberConverter.deserializeDouble(jsonReader);
            }
        };
        FloatReader = new JsonReader.ReadObject<Float>(){

            @Override
            public Float read(JsonReader jsonReader) throws IOException {
                return Float.valueOf(NumberConverter.deserializeFloat(jsonReader));
            }
        };
        IntReader = new JsonReader.ReadObject<Integer>(){

            @Override
            public Integer read(JsonReader jsonReader) throws IOException {
                return NumberConverter.deserializeInt(jsonReader);
            }
        };
        LongReader = new JsonReader.ReadObject<Long>(){

            @Override
            public Long read(JsonReader jsonReader) throws IOException {
                return NumberConverter.deserializeLong(jsonReader);
            }
        };
        DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

            @Override
            public BigDecimal read(JsonReader jsonReader) throws IOException {
                return NumberConverter.deserializeDecimal(jsonReader);
            }
        };
    }
}

