/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class StringConverter {
    private static JsonReader.ReadObject<String> Reader = new JsonReader.ReadObject<String>(){

        @Override
        public String read(JsonReader jsonReader) throws IOException {
            return StringConverter.deserialize(jsonReader);
        }
    };

    public static void serializeShortNullable(String string, JsonWriter jsonWriter) {
        if (string == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeString(string);
        }
    }

    public static void serializeShort(String string, JsonWriter jsonWriter) {
        jsonWriter.writeString(string);
    }

    public static void serializeNullable(String string, JsonWriter jsonWriter) {
        if (string == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeString(string);
        }
    }

    public static void serialize(String string, JsonWriter jsonWriter) {
        jsonWriter.writeString(string);
    }

    public static String deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readString();
    }

    public static String deserializeNullable(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 110) {
            if (!jsonReader.wasNull()) {
                throw new IOException("Expecting 'null' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
            }
            return null;
        }
        return jsonReader.readString();
    }

    public static ArrayList<String> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(Reader, collection);
    }

    public static ArrayList<String> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(Reader, collection);
    }
}

