/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.storage;

import com.dslplatform.client.Bootstrap;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.storage.S3Repository;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

public class S3
implements Serializable {
    private final S3Repository instanceRepository;
    private static final S3Repository staticRepository = Bootstrap.getLocator().resolve(S3Repository.class);
    private static final String bucketName = Bootstrap.getLocator().resolve(Properties.class).getProperty("s3-bucket");
    private String bucket;
    private String key;
    private long length;
    private String name;
    private String mimeType;
    private final HashMap<String, String> metadata = new HashMap();
    private byte[] cachedContent;
    private static final long serialVersionUID = 1L;

    @JsonCreator
    protected S3(@JacksonInject(value="_serviceLocator") ServiceLocator serviceLocator, @JsonProperty(value="Bucket") String string, @JsonProperty(value="Key") String string2, @JsonProperty(value="Length") int n, @JsonProperty(value="Name") String string3, @JsonProperty(value="MimeType") String string4, @JsonProperty(value="Metadata") Map<String, String> map) {
        this.instanceRepository = serviceLocator.resolve(S3Repository.class);
        this.bucket = string;
        this.key = string2;
        this.length = n;
        this.name = string3;
        this.mimeType = string4;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public S3() {
        this.instanceRepository = null;
    }

    public S3(S3Repository s3Repository) {
        this.instanceRepository = s3Repository;
    }

    public S3(InputStream inputStream) throws IOException {
        this.instanceRepository = null;
        this.upload(S3.streamToByteArray(inputStream));
    }

    public S3(String string) throws IOException {
        this(bucketName, string);
    }

    public S3(String string, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("bucket cannot be null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        this.instanceRepository = null;
        this.cachedContent = null;
        this.key = string2;
        this.bucket = string;
    }

    public S3(InputStream inputStream, long l) throws IOException {
        this.instanceRepository = null;
        this.upload(inputStream, l);
    }

    public S3(byte[] byArray) throws IOException {
        this.instanceRepository = null;
        this.upload(byArray);
    }

    private S3Repository getRepository() {
        return this.instanceRepository != null ? this.instanceRepository : staticRepository;
    }

    @JsonProperty(value="Bucket")
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty(value="Key")
    public String getKey() {
        return this.key;
    }

    public String getURI() {
        return this.bucket + ":" + this.key;
    }

    @JsonProperty(value="Length")
    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public S3 setName(String string) {
        this.name = string;
        return this;
    }

    @JsonProperty(value="MimeType")
    public String getMimeType() {
        return this.mimeType;
    }

    public S3 setMimeType(String string) {
        this.mimeType = string;
        return this;
    }

    @JsonProperty(value="Metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public byte[] getContent() throws IOException {
        if (this.cachedContent != null) {
            this.cachedContent = this.getBytes();
        }
        return this.cachedContent;
    }

    public InputStream getStream() throws IOException {
        if (this.key == null || this.key.isEmpty()) {
            return null;
        }
        try {
            return this.getRepository().get(this.bucket, this.key).get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
    }

    public byte[] getBytes() throws IOException {
        InputStream inputStream;
        if (this.key == null || this.key.isEmpty()) {
            return null;
        }
        try {
            inputStream = this.getRepository().get(this.bucket, this.key).get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        return S3.streamToByteArray(inputStream);
    }

    public String upload(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return this.upload(S3.streamToByteArray(byteArrayInputStream));
    }

    public String upload(InputStream inputStream, long l) throws IOException {
        return this.upload(this.bucket != null && this.bucket.length() > 0 ? this.bucket : bucketName, inputStream, l);
    }

    public String upload(String string, InputStream inputStream, long l) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream can't be null.");
        }
        if (this.key == null || this.key.isEmpty()) {
            this.bucket = string;
            this.key = UUID.randomUUID().toString();
        } else if (this.bucket != string) {
            throw new IllegalArgumentException("Can't change bucket name");
        }
        try {
            this.getRepository().upload(string, this.key, inputStream, l, this.metadata).get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        this.length = l;
        this.cachedContent = null;
        return this.key;
    }

    public String upload(byte[] byArray) throws IOException {
        return this.upload(this.bucket != null && this.bucket.length() > 0 ? this.bucket : bucketName, byArray);
    }

    public String upload(String string, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Stream can't be null.");
        }
        if (this.key == null || this.key.isEmpty()) {
            this.bucket = string;
            this.key = UUID.randomUUID().toString();
        } else if (this.bucket != string) {
            throw new IllegalArgumentException("Can't change bucket name");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.getRepository().upload(string, this.key, byteArrayInputStream, byArray.length, this.metadata).get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        this.length = byArray.length;
        this.cachedContent = null;
        return this.key;
    }

    public void delete() throws IOException {
        if (this.key == null || this.key.isEmpty()) {
            throw new IllegalArgumentException("S3 object is empty.");
        }
        this.cachedContent = null;
        try {
            this.getRepository().delete(this.bucket, this.key).get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        this.length = 0L;
        this.cachedContent = null;
        this.key = null;
    }

    private static byte[] streamToByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

