/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.HttpHeaderProvider;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.client.exceptions.HttpException;
import com.dslplatform.client.exceptions.HttpSecurityException;
import com.dslplatform.client.exceptions.HttpServerErrorException;
import com.dslplatform.client.exceptions.HttpUnexpectedCodeException;
import com.dslplatform.client.json.JsonObject;
import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.patterns.ServiceLocator;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;

class HttpClient {
    private final Logger logger;
    private final JsonSerialization jsonDeserialization;
    private final ServiceLocator locator;
    private final HttpHeaderProvider headerProvider;
    private final ExecutorService executorService;
    private final String domainPrefix;
    private final int domainPrefixLength;
    private final String[] remoteUrls;
    private final SSLSocketFactory SSL_SOCKET_FACTORY;
    private static final String MIME_TYPE = "application/json";
    private int currentUrl;
    private final BlockingDeque<JsonWriter> jsonWriters;
    private final BlockingDeque<byte[]> resultBuffers;
    private static final List<Map.Entry<String, String>> emptyHeaders = new ArrayList<Map.Entry<String, String>>(0);
    private static final ConcurrentHashMap<Class<?>, JsonReader.ReadJsonObject<JsonObject>> jsonReaders = new ConcurrentHashMap();

    static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public HttpClient(Properties properties, JsonSerialization jsonSerialization, ServiceLocator serviceLocator, Logger logger, HttpHeaderProvider httpHeaderProvider, ExecutorService executorService) {
        this.logger = logger;
        this.jsonDeserialization = jsonSerialization;
        this.locator = serviceLocator;
        this.executorService = executorService;
        this.remoteUrls = properties.getProperty("api-url").split(",\\s+");
        int n = Runtime.getRuntime().availableProcessors() * 2;
        this.jsonWriters = new LinkedBlockingDeque<JsonWriter>(n);
        this.resultBuffers = new LinkedBlockingDeque<byte[]>(n);
        for (int i = 0; i < n; ++i) {
            this.jsonWriters.addFirst(new JsonWriter());
            this.resultBuffers.addFirst(new byte[1024]);
        }
        this.SSL_SOCKET_FACTORY = this.createSSLSocketFactory(properties);
        this.domainPrefix = properties.getProperty("package-name");
        if (this.domainPrefix == null) {
            throw new IllegalArgumentException("package-name is missing from provided configuration. It is used to specify root namespace");
        }
        this.domainPrefixLength = this.domainPrefix.length() + 1;
        this.headerProvider = httpHeaderProvider;
    }

    private SSLSocketFactory createSSLSocketFactory(Properties properties) {
        String string = properties.getProperty("trustStore");
        String string2 = properties.getProperty("trustStorePassword");
        if (string != null && string2 != null) {
            return this.createSSLSocketFactory(string, string2);
        }
        String string3 = System.getenv("trustStore");
        String string4 = System.getenv("trustStorePassword");
        if (string3 != null && string4 != null) {
            return this.createSSLSocketFactory(string3, string4);
        }
        return null;
    }

    private SSLSocketFactory createSSLSocketFactory(String string, String string2) {
        String string3 = KeyStore.getDefaultType();
        try {
            if (string3.equals("jks")) {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                KeyStore keyStore = KeyStore.getInstance(string3);
                keyStore.load(HttpClient.class.getResourceAsStream(string), string2.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                sSLContext.init(null, trustManagerArray, null);
                return sSLContext.getSocketFactory();
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getDslName(Class<?> clazz) {
        String string = clazz.getName();
        if (string.startsWith(this.domainPrefix)) {
            return string.substring(this.domainPrefixLength);
        }
        throw new RuntimeException(string + " is not defined for package " + this.domainPrefix);
    }

    private static boolean contains(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <TArgument> Response doRawRequest(String string, List<Map.Entry<String, String>> list, String string2, TArgument TArgument, int[] nArray, byte[] byArray, long l) throws IOException, InterruptedException {
        Response response;
        block13: {
            JsonWriter jsonWriter = null;
            try {
                int n;
                byte[] byArray2;
                if (TArgument == null) {
                    byArray2 = null;
                    n = 0;
                    this.logger.debug("Sending request [{}]: {}", (Object)string2, (Object)string);
                } else {
                    if (TArgument instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)TArgument;
                        jsonWriter = this.jsonWriters.takeFirst();
                        jsonObject.serialize(jsonWriter, true);
                        JsonWriter.Bytes bytes = jsonWriter.toBytes();
                        jsonWriter.reset();
                        byArray2 = bytes.content;
                        n = bytes.length;
                    } else {
                        byArray2 = JsonSerialization.serializeBytes(TArgument);
                        n = byArray2.length;
                    }
                    this.logger.debug("Sending request [{}]: {}, content size: {} bytes", new Object[]{string2, string, n});
                }
                response = this.transmit(string, list, string2, byArray2, n, byArray, 2);
                if (jsonWriter == null) break block13;
            }
            catch (Throwable throwable) {
                if (jsonWriter != null) {
                    this.jsonWriters.putFirst(jsonWriter);
                }
                throw throwable;
            }
            this.jsonWriters.putFirst(jsonWriter);
        }
        if (this.logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.debug("Received response [{}, {} bytes] in {} ms", new Object[]{response.code, response.body.length, l2});
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Received response body: {}", (Object)response.bodyToString());
            }
        }
        if (response.code == 403 || response.code == 401) {
            throw new HttpSecurityException(response.bodyToString(), response.code, response.connection.getHeaderFields());
        }
        if (response.code >= 500) {
            throw new HttpServerErrorException(response.bodyToString(), response.code, response.connection.getHeaderFields());
        }
        if (nArray != null && !HttpClient.contains(nArray, response.code)) {
            throw new HttpUnexpectedCodeException(response.bodyToString(), nArray, response.code, response.connection.getHeaderFields());
        }
        if (nArray == null && response.code >= 400) {
            throw new HttpException(response.bodyToString(), response.code, response.connection.getHeaderFields());
        }
        return response;
    }

    public <TArgument> Future<byte[]> sendRawRequest(final String string, final String string2, final TArgument TArgument, final List<Map.Entry<String, String>> list, final int[] nArray) {
        final long l = System.currentTimeMillis();
        return this.executorService.submit(new Callable<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] call() throws IOException, InterruptedException {
                byte[] byArray = (byte[])HttpClient.this.resultBuffers.takeFirst();
                try {
                    Response response = HttpClient.this.doRawRequest(string, list, string2, TArgument, nArray, byArray, l);
                    if (response.code < 300) {
                        byte[] byArray2 = Arrays.copyOf(response.body, response.size);
                        byArray = response.body;
                        byte[] byArray3 = byArray2;
                        return byArray3;
                    }
                    byte[] byArray4 = response.body;
                    return byArray4;
                }
                finally {
                    HttpClient.this.resultBuffers.putFirst(byArray);
                }
            }
        });
    }

    private static JsonReader.ReadJsonObject<JsonObject> getReader(Class<?> clazz) {
        try {
            JsonReader.ReadJsonObject readJsonObject = jsonReaders.get(clazz);
            if (readJsonObject == null) {
                try {
                    readJsonObject = (JsonReader.ReadJsonObject)clazz.getField("JSON_READER").get(null);
                }
                catch (Exception exception) {
                    return null;
                }
                jsonReaders.putIfAbsent(clazz, readJsonObject);
            }
            return readJsonObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <TArgument, TResult> Future<TResult> sendRequest(final Class<TResult> clazz, final String string, final String string2, final TArgument TArgument, final int[] nArray) {
        final long l = System.currentTimeMillis();
        return this.executorService.submit(new Callable<TResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TResult call() throws IOException, InterruptedException {
                byte[] byArray = (byte[])HttpClient.this.resultBuffers.takeFirst();
                try {
                    JsonReader jsonReader;
                    JsonReader.ReadJsonObject readJsonObject;
                    Response response = HttpClient.this.doRawRequest(string, emptyHeaders, string2, TArgument, nArray, byArray, l);
                    byArray = response.body;
                    if (JsonObject.class.isAssignableFrom(clazz) && (readJsonObject = HttpClient.getReader(clazz)) != null && (jsonReader = new JsonReader(response.body, response.size, HttpClient.this.locator)).getNextToken() == 123) {
                        jsonReader.getNextToken();
                        Object t = readJsonObject.deserialize(jsonReader, HttpClient.this.locator);
                        return t;
                    }
                    readJsonObject = HttpClient.this.jsonDeserialization.deserialize(clazz, response.body, response.size);
                    return readJsonObject;
                }
                finally {
                    HttpClient.this.resultBuffers.putFirst(byArray);
                }
            }
        });
    }

    public <TArgument, TResult> Future<List<TResult>> sendCollectionRequest(final Class<TResult> clazz, final String string, final String string2, final TArgument TArgument, final int[] nArray) {
        final long l = System.currentTimeMillis();
        return this.executorService.submit(new Callable<List<TResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TResult> call() throws IOException, InterruptedException {
                byte[] byArray = (byte[])HttpClient.this.resultBuffers.takeFirst();
                try {
                    Object object;
                    JsonReader.ReadJsonObject readJsonObject;
                    Response response = HttpClient.this.doRawRequest(string, emptyHeaders, string2, TArgument, nArray, byArray, l);
                    byArray = response.body;
                    if (JsonObject.class.isAssignableFrom(clazz) && (readJsonObject = HttpClient.getReader(clazz)) != null && ((JsonReader)(object = new JsonReader(response.body, response.size, HttpClient.this.locator))).getNextToken() == 91) {
                        if (((JsonReader)object).getNextToken() == 93) {
                            ArrayList arrayList = new ArrayList(0);
                            return arrayList;
                        }
                        ArrayList arrayList = ((JsonReader)object).deserializeCollection(readJsonObject);
                        return arrayList;
                    }
                    readJsonObject = JsonSerialization.buildCollectionType(ArrayList.class, clazz);
                    object = (List)HttpClient.this.jsonDeserialization.deserialize((JavaType)readJsonObject, response.body, response.size);
                    return object;
                }
                finally {
                    HttpClient.this.resultBuffers.putFirst(byArray);
                }
            }
        });
    }

    private Response transmit(String string, List<Map.Entry<String, String>> list, String string2, byte[] byArray, int n, byte[] byArray2, int n2) throws IOException {
        IOException iOException = null;
        int n3 = this.remoteUrls.length + this.currentUrl;
        for (int i = this.currentUrl; i < n3; ++i) {
            try {
                URL uRL = new URL(this.remoteUrls[i % this.remoteUrls.length] + string);
                Response response = this.transmit(uRL, list, string2, byArray, n, byArray2);
                if (response.code == 409 && n2 > 0) {
                    return this.transmit(string, list, string2, byArray, n, byArray2, n2 - 1);
                }
                if (response.code < 500) {
                    return response;
                }
                this.logger.error("At {} [{}] {}", new Object[]{uRL, response.code, response.bodyToString()});
                this.logger.error("Error connecting to {}. Trying next server if exists...", (Object)uRL);
                iOException = new IOException(response.bodyToString());
            }
            catch (ConnectException connectException) {
                if (n2 > 0) {
                    return this.transmit(string, list, string2, byArray, n, byArray2, n2 - 1);
                }
                this.logger.error("At {} {}. Trying next server if exists...", (Object)string, (Object)connectException.getMessage());
                iOException = connectException;
            }
            catch (IOException iOException2) {
                this.logger.error("IOException {} to {}. Trying next server if exists...", (Object)iOException2.getMessage(), (Object)string);
                iOException = iOException2;
            }
            ++this.currentUrl;
            this.currentUrl %= this.remoteUrls.length;
        }
        throw iOException;
    }

    private Response transmit(URL uRL, List<Map.Entry<String, String>> list, String string, byte[] byArray, int n, byte[] byArray2) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection && this.SSL_SOCKET_FACTORY != null) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.SSL_SOCKET_FACTORY);
        }
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setRequestProperty("Accept", MIME_TYPE);
        httpURLConnection.setRequestProperty("Content-Type", MIME_TYPE);
        for (Map.Entry<String, String> entry : list) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        this.logger.debug("{} {}", (Object)string, (Object)uRL.toString());
        for (Map.Entry<String, String> entry : this.headerProvider.getHeaders()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.logger.isTraceEnabled()) {
            for (Map.Entry<String, Object> entry : httpURLConnection.getRequestProperties().entrySet()) {
                this.logger.trace("{}: {}", (Object)entry.getKey(), entry.getValue());
            }
        }
        if (byArray != null) {
            httpURLConnection.setDoOutput(true);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding payload: {}", (Object)new String(byArray, 0, n, "UTF-8"));
            }
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n));
            httpURLConnection.getOutputStream().write(byArray, 0, n);
            httpURLConnection.getOutputStream().close();
        }
        return new Response(httpURLConnection, byArray2);
    }

    static class Response {
        public final int code;
        public final byte[] body;
        public final int size;
        public final HttpURLConnection connection;

        public Response(HttpURLConnection httpURLConnection, byte[] byArray) throws IOException {
            this.code = httpURLConnection.getResponseCode();
            this.size = httpURLConnection.getContentLength();
            if (this.code < 300 && this.size >= 0) {
                byte[] byArray2 = byArray;
                if (byArray2.length < this.size) {
                    byArray2 = Arrays.copyOf(byArray2, this.size);
                }
                InputStream inputStream = httpURLConnection.getInputStream();
                for (int i = 0; i < this.size; i += inputStream.read(byArray2, i, this.size - i)) {
                }
                this.body = byArray2;
            } else {
                this.body = this.code < 400 ? Utils.inputStreamToByteArray(httpURLConnection.getInputStream()) : Utils.inputStreamToByteArray(httpURLConnection.getErrorStream());
            }
            this.connection = httpURLConnection;
        }

        public String bodyToString() {
            try {
                return this.body == null ? "" : new String(this.body, 0, this.size, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }
}

