/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class JsonWriter
extends Writer {
    public final byte[] tmp = new byte[48];
    private byte[] result;
    private int position;
    private static final Charset utf8 = Charset.forName("UTF-8");
    public static final byte OBJECT_START = 123;
    public static final byte OBJECT_END = 125;
    public static final byte ARRAY_START = 91;
    public static final byte ARRAY_END = 93;
    public static final byte COMMA = 44;
    public static final byte SEMI = 58;
    public static final byte QUOTE = 34;
    public static final byte ESCAPE = 92;

    public JsonWriter() {
        this(512);
    }

    public JsonWriter(int n) {
        this(new byte[n]);
    }

    public JsonWriter(byte[] byArray) {
        this.result = byArray;
    }

    public final void writeNull() {
        int n = this.position;
        this.position += 4;
        if (this.position >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        byte[] byArray = this.result;
        byArray[n] = 110;
        byArray[n + 1] = 117;
        byArray[n + 2] = 108;
        byArray[n + 3] = 108;
    }

    public final void writeByte(byte by) {
        if (this.position == this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        this.result[this.position++] = by;
    }

    public final void writeString(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (this.position + (n2 << 2) + (n2 << 1) + 2 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + (n2 << 2) + (n2 << 1) + 2);
        }
        for (n = 0; n < string.length() && (c = string.charAt(n)) > '\u001f' && c != '\"' && c != '\\' && c < '\u007f'; ++n) {
        }
        byte[] byArray = this.result;
        byArray[this.position] = 34;
        string.getBytes(0, n, byArray, this.position + 1);
        int n3 = this.position + n + 1;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 == '\"') {
                byArray[n3++] = 92;
                byArray[n3++] = 34;
            } else if (c2 == '\\') {
                byArray[n3++] = 92;
                byArray[n3++] = 92;
            } else if (c2 < ' ') {
                if (c2 == '\b') {
                    byArray[n3++] = 92;
                    byArray[n3++] = 98;
                } else if (c2 == '\t') {
                    byArray[n3++] = 92;
                    byArray[n3++] = 116;
                } else if (c2 == '\n') {
                    byArray[n3++] = 92;
                    byArray[n3++] = 110;
                } else if (c2 == '\f') {
                    byArray[n3++] = 92;
                    byArray[n3++] = 102;
                } else if (c2 == '\r') {
                    byArray[n3++] = 92;
                    byArray[n3++] = 114;
                } else {
                    byArray[n3] = 92;
                    byArray[n3 + 1] = 117;
                    byArray[n3 + 2] = 48;
                    byArray[n3 + 3] = 48;
                    switch (c2) {
                        case '\u0000': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 48;
                            break;
                        }
                        case '\u0001': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 49;
                            break;
                        }
                        case '\u0002': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 50;
                            break;
                        }
                        case '\u0003': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 51;
                            break;
                        }
                        case '\u0004': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 52;
                            break;
                        }
                        case '\u0005': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 53;
                            break;
                        }
                        case '\u0006': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 54;
                            break;
                        }
                        case '\u0007': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 55;
                            break;
                        }
                        case '\u000b': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 66;
                            break;
                        }
                        case '\u000e': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 69;
                            break;
                        }
                        case '\u000f': {
                            byArray[n3 + 4] = 48;
                            byArray[n3 + 5] = 70;
                            break;
                        }
                        case '\u0010': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 48;
                            break;
                        }
                        case '\u0011': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 49;
                            break;
                        }
                        case '\u0012': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 50;
                            break;
                        }
                        case '\u0013': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 51;
                            break;
                        }
                        case '\u0014': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 52;
                            break;
                        }
                        case '\u0015': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 53;
                            break;
                        }
                        case '\u0016': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 54;
                            break;
                        }
                        case '\u0017': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 55;
                            break;
                        }
                        case '\u0018': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 56;
                            break;
                        }
                        case '\u0019': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 57;
                            break;
                        }
                        case '\u001a': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 65;
                            break;
                        }
                        case '\u001b': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 66;
                            break;
                        }
                        case '\u001c': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 67;
                            break;
                        }
                        case '\u001d': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 68;
                            break;
                        }
                        case '\u001e': {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 69;
                            break;
                        }
                        default: {
                            byArray[n3 + 4] = 49;
                            byArray[n3 + 5] = 70;
                        }
                    }
                    n3 += 6;
                }
            } else if (c2 < '\u007f') {
                byArray[n3++] = (byte)c2;
            } else {
                int n4 = string.codePointAt(n);
                if (Character.isSupplementaryCodePoint(n4)) {
                    ++n;
                }
                if (n4 == 127) {
                    byArray[n3++] = (byte)n4;
                } else if (n4 <= 2047) {
                    byArray[n3++] = (byte)(0xC0 | n4 >> 6 & 0x1F);
                    byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                } else if (n4 < 55296 || n4 > 57343 && n4 <= 65533) {
                    byArray[n3++] = (byte)(0xE0 | n4 >> 12 & 0xF);
                    byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                } else if (n4 >= 65536 && n4 <= 0x10FFFF) {
                    byArray[n3++] = (byte)(0xF0 | n4 >> 18 & 7);
                    byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                } else {
                    throw new RuntimeException("Unknown unicode codepoint in string! " + Integer.toHexString(n4));
                }
            }
            ++n;
        }
        byArray[n3] = 34;
        this.position = n3 + 1;
    }

    public final void writeBuffer(int n, int n2) {
        if (this.position + 64 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        int n3 = this.position;
        byte[] byArray = this.result;
        for (int i = n; i < n2; ++i) {
            byArray[n3++] = this.tmp[i];
        }
        this.position = n3;
    }

    public final void writeBuffer(int n) {
        if (this.position + 64 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        int n2 = this.position;
        byte[] byArray = this.result;
        for (int i = 0; i < n; ++i) {
            byArray[n2 + i] = this.tmp[i];
        }
        this.position += n;
    }

    public final void writeAscii(String string) {
        int n = string.length();
        if (this.position + n >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + n);
        }
        string.getBytes(0, n, this.result, this.position);
        this.position += n;
    }

    public final void writeAscii(String string, int n) {
        if (this.position + n >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + n);
        }
        string.getBytes(0, n, this.result, this.position);
        this.position += n;
    }

    public final void writeAscii(byte[] byArray) {
        int n = byArray.length;
        if (this.position + n >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + n);
        }
        int n2 = this.position;
        byte[] byArray2 = this.result;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[n2 + i] = byArray[i];
        }
        this.position += n;
    }

    public final void writeAscii(byte[] byArray, int n) {
        if (this.position + n >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + n);
        }
        int n2 = this.position;
        byte[] byArray2 = this.result;
        for (int i = 0; i < n; ++i) {
            byArray2[n2 + i] = byArray[i];
        }
        this.position += n;
    }

    public final void writeBinary(byte[] byArray) {
        if (this.position + (byArray.length << 1) + 2 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + (byArray.length << 1) + 2);
        }
        this.result[this.position++] = 34;
        this.position += Base64.encodeToBytes(byArray, this.result, this.position);
        this.result[this.position++] = 34;
    }

    public String toString() {
        return new String(this.result, 0, this.position, utf8);
    }

    public final Bytes toBytes() {
        return new Bytes(this.result, this.position);
    }

    public final byte[] toByteArray() {
        return Arrays.copyOf(this.result, this.position);
    }

    public final void toStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.result, 0, this.position);
    }

    public final int size() {
        return this.position;
    }

    public final void reset() {
        this.position = 0;
    }

    @Override
    public void write(int n) throws IOException {
        this.tmp[0] = (byte)n;
        this.writeString(new String(this.tmp, 0, 1));
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this.writeString(new String(cArray, n, n2));
    }

    @Override
    public void write(String string, int n, int n2) {
        this.writeString(string.substring(n, n + n2));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.position = 0;
    }

    public static class Bytes {
        public final byte[] content;
        public final int length;

        public Bytes(byte[] byArray, int n) {
            this.content = byArray;
            this.length = n;
        }
    }
}

