/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapConverter {
    private static JsonReader.ReadObject<Map<String, String>> MapReader = new JsonReader.ReadObject<Map<String, String>>(){

        @Override
        public Map<String, String> read(JsonReader jsonReader) throws IOException {
            return MapConverter.deserialize(jsonReader);
        }
    };

    public static void serializeNullable(Map<String, String> map, JsonWriter jsonWriter) {
        if (map == null) {
            jsonWriter.writeNull();
        } else {
            MapConverter.serialize(map, jsonWriter);
        }
    }

    public static void serialize(Map<String, String> map, JsonWriter jsonWriter) {
        jsonWriter.writeByte((byte)123);
        int n = map.size();
        if (n > 0) {
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            Map.Entry<String, String> entry = iterator.next();
            StringConverter.serializeShort(entry.getKey(), jsonWriter);
            jsonWriter.writeByte((byte)58);
            StringConverter.serializeNullable(entry.getValue(), jsonWriter);
            for (int i = 1; i < n; ++i) {
                jsonWriter.writeByte((byte)44);
                entry = iterator.next();
                StringConverter.serializeShort(entry.getKey(), jsonWriter);
                jsonWriter.writeByte((byte)58);
                StringConverter.serializeNullable(entry.getValue(), jsonWriter);
            }
        }
        jsonWriter.writeByte((byte)125);
    }

    public static Map<String, String> deserialize(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return hashMap;
        }
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        String string2 = StringConverter.deserializeNullable(jsonReader);
        hashMap.put(string, string2);
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            string2 = StringConverter.deserializeNullable(jsonReader);
            hashMap.put(string, string2);
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return hashMap;
    }

    public static ArrayList<Map<String, String>> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(MapReader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Map<String, String>> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(MapReader, collection);
    }

    public static ArrayList<Map<String, String>> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(MapReader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Map<String, String>> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(MapReader, collection);
    }
}

