/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class NumberConverter {
    private static final int[] Digits = new int[100];
    static JsonReader.ReadObject<Double> DoubleReader = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDouble(jsonReader);
        }
    };
    static JsonWriter.WriteObject<Double> DoubleWriter = new JsonWriter.WriteObject<Double>(){

        @Override
        public void write(JsonWriter jsonWriter, Double d) {
            NumberConverter.serializeNullable(d, jsonWriter);
        }
    };
    static JsonReader.ReadObject<Float> FloatReader = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader jsonReader) throws IOException {
            return Float.valueOf(NumberConverter.deserializeFloat(jsonReader));
        }
    };
    static JsonWriter.WriteObject<Float> FloatWriter = new JsonWriter.WriteObject<Float>(){

        @Override
        public void write(JsonWriter jsonWriter, Float f) {
            NumberConverter.serializeNullable(f, jsonWriter);
        }
    };
    static JsonReader.ReadObject<Integer> IntReader = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeInt(jsonReader);
        }
    };
    static JsonWriter.WriteObject<Integer> IntWriter = new JsonWriter.WriteObject<Integer>(){

        @Override
        public void write(JsonWriter jsonWriter, Integer n) {
            NumberConverter.serializeNullable(n, jsonWriter);
        }
    };
    static JsonReader.ReadObject<Long> LongReader = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeLong(jsonReader);
        }
    };
    static JsonWriter.WriteObject<Long> LongWriter = new JsonWriter.WriteObject<Long>(){

        @Override
        public void write(JsonWriter jsonWriter, Long l) {
            NumberConverter.serializeNullable(l, jsonWriter);
        }
    };
    static JsonReader.ReadObject<BigDecimal> DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDecimal(jsonReader);
        }
    };
    static JsonWriter.WriteObject<BigDecimal> DecimalWriter = new JsonWriter.WriteObject<BigDecimal>(){

        @Override
        public void write(JsonWriter jsonWriter, BigDecimal bigDecimal) {
            NumberConverter.serializeNullable(bigDecimal, jsonWriter);
        }
    };
    private static final byte MINUS = 45;

    static void write4(int n, byte[] byArray, int n2) {
        if (n > 9999) {
            throw new IllegalArgumentException("Only 4 digits numbers are supported. Provided: " + n);
        }
        int n3 = n / 100;
        int n4 = Digits[n3];
        int n5 = Digits[n - ((n3 << 6) + (n3 << 5) + (n3 << 2))];
        byArray[n2] = (byte)(n4 >> 8);
        byArray[n2 + 1] = (byte)n4;
        byArray[n2 + 2] = (byte)(n5 >> 8);
        byArray[n2 + 3] = (byte)n5;
    }

    static void write2(int n, byte[] byArray, int n2) {
        int n3 = Digits[n];
        byArray[n2] = (byte)(n3 >> 8);
        byArray[n2 + 1] = (byte)n3;
    }

    static int read2(char[] cArray, int n) {
        int n2 = cArray[n] - 48;
        return (n2 << 3) + (n2 << 1) + cArray[n + 1] - 48;
    }

    static int read4(char[] cArray, int n) {
        int n2 = cArray[n + 1] - 48;
        int n3 = cArray[n + 2] - 48;
        return (cArray[n] - 48) * 1000 + (n2 << 6) + (n2 << 5) + (n2 << 2) + (n3 << 3) + (n3 << 1) + cArray[n + 3] - 48;
    }

    public static void serializeNullable(Double d, JsonWriter jsonWriter) {
        if (d == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(d, jsonWriter);
        }
    }

    private static BigDecimal parseNumberGeneric(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 > 0 && Character.isWhitespace(cArray[n3 - 1]); --n3) {
        }
        try {
            return new BigDecimal(cArray, 0, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing number at position: " + (n2 - n), numberFormatException);
        }
    }

    public static void serialize(double d, JsonWriter jsonWriter) {
        if (Double.isNaN(d)) {
            jsonWriter.writeAscii("\"NaN\"");
        } else if (Double.isInfinite(d)) {
            long l = Double.doubleToLongBits(d);
            if ((l & Long.MIN_VALUE) != 0L) {
                jsonWriter.writeAscii("\"-Infinity\"");
            } else {
                jsonWriter.writeAscii("\"Infinity\"");
            }
        } else {
            jsonWriter.writeAscii(Double.toString(d));
        }
    }

    public static void serialize(double[] dArray, JsonWriter jsonWriter) {
        if (dArray == null) {
            jsonWriter.writeNull();
        } else if (dArray.length == 0) {
            jsonWriter.writeAscii("[]");
        } else {
            jsonWriter.writeByte((byte)91);
            NumberConverter.serialize(dArray[0], jsonWriter);
            for (int i = 1; i < dArray.length; ++i) {
                jsonWriter.writeByte((byte)44);
                NumberConverter.serialize(dArray[i], jsonWriter);
            }
            jsonWriter.writeByte((byte)93);
        }
    }

    private static NumberInfo readLongNumber(JsonReader jsonReader, char[] cArray) throws IOException {
        int n = cArray.length;
        char[] cArray2 = Arrays.copyOf(cArray, cArray.length * 2);
        while (!jsonReader.isEndOfStream()) {
            do {
                char c = (char)jsonReader.read();
                cArray2[n++] = c;
                if (!jsonReader.isEndOfStream() && (c >= '0' && c < '9' || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E')) continue;
                return new NumberInfo(cArray2, jsonReader.isEndOfStream() ? n : n - 1);
            } while (n < cArray2.length);
            cArray2 = Arrays.copyOf(cArray2, cArray2.length * 2);
        }
        return new NumberInfo(cArray2, n);
    }

    public static double deserializeDouble(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 34) {
            int n = jsonReader.getCurrentIndex();
            char[] cArray = jsonReader.readSimpleQuote();
            return NumberConverter.parseDoubleGeneric(cArray, jsonReader.getCurrentIndex() - n - 1, n + 1);
        }
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart();
        if (n2 > 18) {
            if (n2 == cArray.length) {
                NumberInfo numberInfo = NumberConverter.readLongNumber(jsonReader, cArray);
                return NumberConverter.parseDoubleGeneric(numberInfo.buffer, numberInfo.length, n);
            }
            return NumberConverter.parseDoubleGeneric(cArray, n2, n);
        }
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeDouble(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveDouble(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveDouble(cArray, n, n2, 0);
    }

    private static double parsePositiveDouble(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < n2 && (n5 = cArray[n3]) != 46) {
            n4 = cArray[n3] - 48;
            l = (l << 3) + (l << 1) + (long)n4;
            if (n4 < 0 || n4 > 9) {
                return NumberConverter.parseDoubleGeneric(cArray, n2, n);
            }
            ++n3;
        }
        if (n3 == n2) {
            return l;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < n2) {
                int n6 = cArray[n3] - 48;
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) + (long)n6;
                if (n6 < 0 || n6 > 9) {
                    return NumberConverter.parseDoubleGeneric(cArray, n2, n);
                }
                ++n3;
            }
            return (double)l / (double)n4;
        }
        return l;
    }

    private static double parseNegativeDouble(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < n2 && (n5 = cArray[n3]) != 46) {
            n4 = cArray[n3] - 48;
            l = (l << 3) + (l << 1) - (long)n4;
            if (n4 < 0 || n4 > 9) {
                return NumberConverter.parseDoubleGeneric(cArray, n2, n);
            }
            ++n3;
        }
        if (n3 == n2) {
            return l;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < n2) {
                int n6 = cArray[n3] - 48;
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) - (long)n6;
                if (n6 < 0 || n6 > 9) {
                    return NumberConverter.parseDoubleGeneric(cArray, n2, n);
                }
                ++n3;
            }
            return (double)l / (double)n4;
        }
        return l;
    }

    private static double parseDoubleGeneric(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 > 0 && Character.isWhitespace(cArray[n3 - 1]); --n3) {
        }
        try {
            return Double.parseDouble(new String(cArray, 0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing float number at position: " + (n2 - n), numberFormatException);
        }
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DoubleReader);
    }

    public static void deserializeDoubleCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeCollection(DoubleReader, collection);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DoubleReader);
    }

    public static void deserializeDoubleNullableCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeNullableCollection(DoubleReader, collection);
    }

    public static void serializeNullable(Float f, JsonWriter jsonWriter) {
        if (f == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(f.floatValue(), jsonWriter);
        }
    }

    public static void serialize(float f, JsonWriter jsonWriter) {
        if (Float.isNaN(f)) {
            jsonWriter.writeAscii("\"NaN\"");
        } else if (Float.isInfinite(f)) {
            int n = Float.floatToIntBits(f);
            if ((n & Integer.MIN_VALUE) != 0) {
                jsonWriter.writeAscii("\"-Infinity\"");
            } else {
                jsonWriter.writeAscii("\"Infinity\"");
            }
        } else {
            jsonWriter.writeAscii(Float.toString(f));
        }
    }

    public static void serialize(float[] fArray, JsonWriter jsonWriter) {
        if (fArray == null) {
            jsonWriter.writeNull();
        } else if (fArray.length == 0) {
            jsonWriter.writeAscii("[]");
        } else {
            jsonWriter.writeByte((byte)91);
            NumberConverter.serialize(fArray[0], jsonWriter);
            for (int i = 1; i < fArray.length; ++i) {
                jsonWriter.writeByte((byte)44);
                NumberConverter.serialize(fArray[i], jsonWriter);
            }
            jsonWriter.writeByte((byte)93);
        }
    }

    public static float deserializeFloat(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 34) {
            int n = jsonReader.getCurrentIndex();
            char[] cArray = jsonReader.readSimpleQuote();
            return NumberConverter.parseFloatGeneric(cArray, jsonReader.getCurrentIndex() - n - 1, n + 1);
        }
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart();
        if (n2 > 18) {
            if (n2 == cArray.length) {
                NumberInfo numberInfo = NumberConverter.readLongNumber(jsonReader, cArray);
                return NumberConverter.parseFloatGeneric(numberInfo.buffer, numberInfo.length, n);
            }
            return NumberConverter.parseFloatGeneric(cArray, n2, n);
        }
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeFloat(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveFloat(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveFloat(cArray, n, n2, 0);
    }

    private static float parsePositiveFloat(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < n2 && (n5 = cArray[n3]) != 46) {
            n4 = cArray[n3] - 48;
            l = (l << 3) + (l << 1) + (long)n4;
            if (n4 < 0 || n4 > 9) {
                return NumberConverter.parseFloatGeneric(cArray, n2, n);
            }
            ++n3;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < n2) {
                int n6 = cArray[n3] - 48;
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) + (long)n6;
                if (n6 < 0 || n6 > 9) {
                    return NumberConverter.parseFloatGeneric(cArray, n2, n);
                }
                ++n3;
            }
            return (float)l / (float)n4;
        }
        return l;
    }

    private static float parseNegativeFloat(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < n2 && (n5 = cArray[n3]) != 46) {
            n4 = cArray[n3] - 48;
            l = (l << 3) + (l << 1) - (long)n4;
            if (n4 < 0 || n4 > 9) {
                return NumberConverter.parseFloatGeneric(cArray, n2, n);
            }
            ++n3;
        }
        if (n5 == 46) {
            ++n3;
            n4 = 1;
            while (n3 < n2) {
                int n6 = cArray[n3] - 48;
                n4 = (n4 << 3) + (n4 << 1);
                l = (l << 3) + (l << 1) - (long)n6;
                if (n6 < 0 || n6 > 9) {
                    return NumberConverter.parseFloatGeneric(cArray, n2, n);
                }
                ++n3;
            }
            return (float)l / (float)n4;
        }
        return l;
    }

    private static float parseFloatGeneric(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 > 0 && Character.isWhitespace(cArray[n3 - 1]); --n3) {
        }
        try {
            return Float.parseFloat(new String(cArray, 0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing float number at position: " + (n2 - n), numberFormatException);
        }
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(FloatReader);
    }

    public static void deserializeFloatCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeCollection(FloatReader, collection);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(FloatReader);
    }

    public static void deserializeFloatNullableCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeNullableCollection(FloatReader, collection);
    }

    public static void serializeNullable(Integer n, JsonWriter jsonWriter) {
        if (n == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(n, jsonWriter);
        }
    }

    public static void serialize(int n, JsonWriter jsonWriter) {
        if (n == Integer.MIN_VALUE) {
            jsonWriter.writeAscii("-2147483648");
        } else {
            int n2;
            byte[] byArray = jsonWriter.tmp;
            int n3 = 10;
            if (n < 0) {
                n2 = -n;
                jsonWriter.writeByte((byte)45);
            } else {
                n2 = n;
            }
            int n4 = 0;
            while (n3 > 1) {
                int n5 = n2 / 100;
                int n6 = n2 - ((n5 << 6) + (n5 << 5) + (n5 << 2));
                n2 = n5;
                n4 = Digits[n6];
                byArray[n3--] = (byte)n4;
                byArray[n3--] = (byte)(n4 >> 8);
                if (n2 != 0) continue;
            }
            jsonWriter.writeBuffer(n3 + 1 + (n4 >> 16), 11);
        }
    }

    public static void serialize(int[] nArray, JsonWriter jsonWriter) {
        if (nArray == null) {
            jsonWriter.writeNull();
        } else if (nArray.length == 0) {
            jsonWriter.writeAscii("[]");
        } else {
            jsonWriter.writeByte((byte)91);
            NumberConverter.serialize(nArray[0], jsonWriter);
            for (int i = 1; i < nArray.length; ++i) {
                jsonWriter.writeByte((byte)44);
                NumberConverter.serialize(nArray[i], jsonWriter);
            }
            jsonWriter.writeByte((byte)93);
        }
    }

    public static void serialize(short[] sArray, JsonWriter jsonWriter) {
        if (sArray == null) {
            jsonWriter.writeNull();
        } else if (sArray.length == 0) {
            jsonWriter.writeAscii("[]");
        } else {
            jsonWriter.writeByte((byte)91);
            NumberConverter.serialize(sArray[0], jsonWriter);
            for (int i = 1; i < sArray.length; ++i) {
                jsonWriter.writeByte((byte)44);
                NumberConverter.serialize(sArray[i], jsonWriter);
            }
            jsonWriter.writeByte((byte)93);
        }
    }

    public static int deserializeInt(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart();
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeInt(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveInt(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveInt(cArray, n, n2, 0);
    }

    private static int parsePositiveInt(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n3 < n2) {
            int n5 = cArray[n3] - 48;
            n4 = (n4 << 3) + (n4 << 1) + n5;
            if (n5 < 0 || n5 > 9) {
                BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
                if (bigDecimal.scale() <= 0) {
                    return bigDecimal.intValue();
                }
                throw new IOException("Error parsing int number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
            }
            ++n3;
        }
        return n4;
    }

    private static int parseNegativeInt(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n3 < n2) {
            int n5 = cArray[n3] - 48;
            n4 = (n4 << 3) + (n4 << 1) - n5;
            if (n5 < 0 || n5 > 9) {
                BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
                if (bigDecimal.scale() <= 0) {
                    return bigDecimal.intValue();
                }
                throw new IOException("Error parsing int number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
            }
            ++n3;
        }
        return n4;
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(IntReader);
    }

    public static void deserializeIntCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeCollection(IntReader, collection);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(IntReader);
    }

    public static void deserializeIntNullableCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeNullableCollection(IntReader, collection);
    }

    public static void serializeNullable(Long l, JsonWriter jsonWriter) {
        if (l == null) {
            jsonWriter.writeNull();
        } else {
            NumberConverter.serialize(l, jsonWriter);
        }
    }

    public static void serialize(long l, JsonWriter jsonWriter) {
        if (l == Long.MIN_VALUE) {
            jsonWriter.writeAscii("-9223372036854775808");
        } else {
            long l2;
            byte[] byArray = jsonWriter.tmp;
            int n = 20;
            if (l < 0L) {
                l2 = -l;
                jsonWriter.writeByte((byte)45);
            } else {
                l2 = l;
            }
            int n2 = 0;
            while (n > 1) {
                long l3 = l2 / 100L;
                int n3 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
                l2 = l3;
                n2 = Digits[n3];
                byArray[n--] = (byte)n2;
                byArray[n--] = (byte)(n2 >> 8);
                if (l2 != 0L) continue;
            }
            jsonWriter.writeBuffer(n + 1 + (n2 >> 16), 21);
        }
    }

    public static void serialize(long[] lArray, JsonWriter jsonWriter) {
        if (lArray == null) {
            jsonWriter.writeNull();
        } else if (lArray.length == 0) {
            jsonWriter.writeAscii("[]");
        } else {
            jsonWriter.writeByte((byte)91);
            NumberConverter.serialize(lArray[0], jsonWriter);
            for (int i = 1; i < lArray.length; ++i) {
                jsonWriter.writeByte((byte)44);
                NumberConverter.serialize(lArray[i], jsonWriter);
            }
            jsonWriter.writeByte((byte)93);
        }
    }

    public static long deserializeLong(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart();
        char c = cArray[0];
        int n3 = 0;
        long l = 0L;
        if (c == '-') {
            for (n3 = 1; n3 < n2; ++n3) {
                int n4 = cArray[n3] - 48;
                l = (l << 3) + (l << 1) - (long)n4;
                if (n4 >= 0 && n4 <= 9) continue;
                return NumberConverter.parseLongGeneric(cArray, n, n2);
            }
            return l;
        }
        if (c == '+') {
            n3 = 1;
        }
        while (n3 < n2) {
            int n5 = cArray[n3] - 48;
            l = (l << 3) + (l << 1) + (long)n5;
            if (n5 < 0 || n5 > 9) {
                return NumberConverter.parseLongGeneric(cArray, n, n2);
            }
            ++n3;
        }
        return l;
    }

    private static long parseLongGeneric(char[] cArray, int n, int n2) throws IOException {
        BigDecimal bigDecimal = NumberConverter.parseNumberGeneric(cArray, n2, n);
        if (bigDecimal.scale() <= 0) {
            return bigDecimal.longValue();
        }
        throw new IOException("Error parsing long number at position: " + (n - n2) + ". Found decimal value: " + bigDecimal);
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(LongReader);
    }

    public static void deserializeLongCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeCollection(LongReader, collection);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(LongReader);
    }

    public static void deserializeLongNullableCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeNullableCollection(LongReader, collection);
    }

    public static void serializeNullable(BigDecimal bigDecimal, JsonWriter jsonWriter) {
        if (bigDecimal == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeAscii(bigDecimal.toString());
        }
    }

    public static void serialize(BigDecimal bigDecimal, JsonWriter jsonWriter) {
        jsonWriter.writeAscii(bigDecimal.toString());
    }

    public static BigDecimal deserializeDecimal(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        int n = jsonReader.getCurrentIndex();
        int n2 = n - jsonReader.getTokenStart();
        if (n2 > 18) {
            if (n2 == cArray.length) {
                NumberInfo numberInfo = NumberConverter.readLongNumber(jsonReader, cArray);
                return NumberConverter.parseNumberGeneric(numberInfo.buffer, numberInfo.length, n);
            }
            return NumberConverter.parseNumberGeneric(cArray, n2, n);
        }
        char c = cArray[0];
        if (c == '-') {
            return NumberConverter.parseNegativeDecimal(cArray, n, n2, 1);
        }
        if (c == '+') {
            return NumberConverter.parsePositiveDecimal(cArray, n, n2, 1);
        }
        return NumberConverter.parsePositiveDecimal(cArray, n, n2, 0);
    }

    private static BigDecimal parsePositiveDecimal(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < n2 && (n5 = cArray[n3]) != 46 && n5 != 101 && n5 != 69) {
            n4 = n5 - 48;
            l = (l << 3) + (l << 1) + (long)n4;
            if (n4 < 0 || n4 > 9) {
                return NumberConverter.parseNumberGeneric(cArray, n2, n);
            }
            ++n3;
        }
        if (n3 == n2) {
            return BigDecimal.valueOf(l);
        }
        if (n5 == 46) {
            int n6;
            n4 = ++n3;
            while (n3 < n2 && (n5 = cArray[n3]) != 101 && n5 != 69) {
                n6 = n5 - 48;
                l = (l << 3) + (l << 1) + (long)n6;
                if (n6 < 0 || n6 > 9) {
                    return NumberConverter.parseNumberGeneric(cArray, n2, n);
                }
                ++n3;
            }
            if (n3 == n2) {
                return BigDecimal.valueOf(l, n2 - n4);
            }
            if (n5 == 101 || n5 == 69) {
                n6 = n3++;
                n5 = cArray[n3];
                int n7 = n5 == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
                return BigDecimal.valueOf(l, n6 - n4 - n7);
            }
            return BigDecimal.valueOf(l, n2 - n4);
        }
        if (n5 == 101 || n5 == 69) {
            n4 = (n5 = cArray[++n3]) == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
            return BigDecimal.valueOf(l, -n4);
        }
        return BigDecimal.valueOf(l);
    }

    private static BigDecimal parseNegativeDecimal(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        long l = 0L;
        int n5 = 32;
        while (n3 < n2 && (n5 = cArray[n3]) != 46 && n5 != 101 && n5 != 69) {
            n4 = n5 - 48;
            l = (l << 3) + (l << 1) - (long)n4;
            if (n4 < 0 || n4 > 9) {
                return NumberConverter.parseNumberGeneric(cArray, n2, n);
            }
            ++n3;
        }
        if (n3 == n2) {
            return BigDecimal.valueOf(l);
        }
        if (n5 == 46) {
            int n6;
            n4 = ++n3;
            while (n3 < n2 && (n5 = cArray[n3]) != 101 && n5 != 69) {
                n6 = n5 - 48;
                l = (l << 3) + (l << 1) - (long)n6;
                if (n6 < 0 || n6 > 9) {
                    return NumberConverter.parseNumberGeneric(cArray, n2, n);
                }
                ++n3;
            }
            if (n3 == n2) {
                return BigDecimal.valueOf(l, n2 - n4);
            }
            if (n5 == 101 || n5 == 69) {
                n6 = n3++;
                n5 = cArray[n3];
                int n7 = n5 == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
                return BigDecimal.valueOf(l, n6 - n4 - n7);
            }
            return BigDecimal.valueOf(l, n2 - n4);
        }
        if (n5 == 101 || n5 == 69) {
            n4 = (n5 = cArray[++n3]) == 45 ? NumberConverter.parseNegativeInt(cArray, n, n2, n3 + 1) : (n5 == 43 ? NumberConverter.parsePositiveInt(cArray, n, n2, n3 + 1) : NumberConverter.parsePositiveInt(cArray, n, n2, n3));
            return BigDecimal.valueOf(l, -n4);
        }
        return BigDecimal.valueOf(l);
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DecimalReader);
    }

    public static void deserializeDecimalCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeCollection(DecimalReader, collection);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DecimalReader);
    }

    public static void deserializeDecimalNullableCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeNullableCollection(DecimalReader, collection);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            NumberConverter.Digits[i] = (i < 10 ? 65536 : 0) + (i / 10 + 48 << 8) + i % 10 + 48;
        }
    }

    static class NumberInfo {
        public final char[] buffer;
        public final int length;

        public NumberInfo(char[] cArray, int n) {
            this.buffer = cArray;
            this.length = n;
        }
    }
}

