/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public class UUIDConverter {
    public static final UUID MIN_UUID;
    static JsonReader.ReadObject<UUID> Reader;
    static JsonWriter.WriteObject<UUID> Writer;
    private static final char[] Lookup;
    private static final byte[] Values;

    public static void serializeNullable(UUID uUID, JsonWriter jsonWriter) {
        if (uUID == null) {
            jsonWriter.writeNull();
        } else {
            UUIDConverter.serialize(uUID, jsonWriter);
        }
    }

    public static void serialize(UUID uUID, JsonWriter jsonWriter) {
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = (int)(l2 >> 32);
        int n4 = (int)l2;
        byte[] byArray = jsonWriter.tmp;
        byArray[0] = 34;
        int n5 = n >> 24 & 0xFF;
        char c = Lookup[n5];
        byArray[1] = (byte)(c >> 8);
        byArray[2] = (byte)c;
        n5 = n >> 16 & 0xFF;
        c = Lookup[n5];
        byArray[3] = (byte)(c >> 8);
        byArray[4] = (byte)c;
        n5 = n >> 8 & 0xFF;
        c = Lookup[n5];
        byArray[5] = (byte)(c >> 8);
        byArray[6] = (byte)c;
        n5 = n & 0xFF;
        c = Lookup[n5];
        byArray[7] = (byte)(c >> 8);
        byArray[8] = (byte)c;
        byArray[9] = 45;
        n5 = n2 >> 24 & 0xFF;
        c = Lookup[n5];
        byArray[10] = (byte)(c >> 8);
        byArray[11] = (byte)c;
        n5 = n2 >> 16 & 0xFF;
        c = Lookup[n5];
        byArray[12] = (byte)(c >> 8);
        byArray[13] = (byte)c;
        byArray[14] = 45;
        n5 = n2 >> 8 & 0xFF;
        c = Lookup[n5];
        byArray[15] = (byte)(c >> 8);
        byArray[16] = (byte)c;
        n5 = n2 & 0xFF;
        c = Lookup[n5];
        byArray[17] = (byte)(c >> 8);
        byArray[18] = (byte)c;
        byArray[19] = 45;
        n5 = n3 >> 24 & 0xFF;
        c = Lookup[n5];
        byArray[20] = (byte)(c >> 8);
        byArray[21] = (byte)c;
        n5 = n3 >> 16 & 0xFF;
        c = Lookup[n5];
        byArray[22] = (byte)(c >> 8);
        byArray[23] = (byte)c;
        byArray[24] = 45;
        n5 = n3 >> 8 & 0xFF;
        c = Lookup[n5];
        byArray[25] = (byte)(c >> 8);
        byArray[26] = (byte)c;
        n5 = n3 & 0xFF;
        c = Lookup[n5];
        byArray[27] = (byte)(c >> 8);
        byArray[28] = (byte)c;
        n5 = n4 >> 24 & 0xFF;
        c = Lookup[n5];
        byArray[29] = (byte)(c >> 8);
        byArray[30] = (byte)c;
        n5 = n4 >> 16 & 0xFF;
        c = Lookup[n5];
        byArray[31] = (byte)(c >> 8);
        byArray[32] = (byte)c;
        n5 = n4 >> 8 & 0xFF;
        c = Lookup[n5];
        byArray[33] = (byte)(c >> 8);
        byArray[34] = (byte)c;
        n5 = n4 & 0xFF;
        c = Lookup[n5];
        byArray[35] = (byte)(c >> 8);
        byArray[36] = (byte)c;
        byArray[37] = 34;
        jsonWriter.writeBuffer(38);
    }

    public static UUID deserialize(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readSimpleQuote();
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart();
        if (n == 37 && cArray[8] == '-' && cArray[13] == '-' && cArray[18] == '-' && cArray[23] == '-') {
            try {
                int n2;
                int n3;
                long l = 0L;
                for (n3 = 0; n3 < 8; ++n3) {
                    l = (l << 4) + (long)Values[cArray[n3] - 48];
                }
                for (n3 = 9; n3 < 13; ++n3) {
                    l = (l << 4) + (long)Values[cArray[n3] - 48];
                }
                for (n3 = 14; n3 < 18; ++n3) {
                    l = (l << 4) + (long)Values[cArray[n3] - 48];
                }
                long l2 = 0L;
                for (n2 = 19; n2 < 23; ++n2) {
                    l2 = (l2 << 4) + (long)Values[cArray[n2] - 48];
                }
                for (n2 = 24; n2 < 36; ++n2) {
                    l2 = (l2 << 4) + (long)Values[cArray[n2] - 48];
                }
                return new UUID(l, l2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return UUID.fromString(new String(cArray, 0, 36));
            }
        }
        if (n == 33) {
            try {
                long l = 0L;
                for (int i = 0; i < 16; ++i) {
                    l = (l << 4) + (long)Values[cArray[i] - 48];
                }
                long l3 = 0L;
                for (int i = 16; i < 32; ++i) {
                    l3 = (l3 << 4) + (long)Values[cArray[i] - 48];
                }
                return new UUID(l, l3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return UUID.fromString(new String(cArray, 0, 32));
            }
        }
        return UUID.fromString(new String(cArray, 0, n - 1));
    }

    public static ArrayList<UUID> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<UUID> collection) throws IOException {
        jsonReader.deserializeCollection(Reader, collection);
    }

    public static ArrayList<UUID> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<UUID> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Reader, collection);
    }

    static {
        int n;
        MIN_UUID = new UUID(0L, 0L);
        Reader = new JsonReader.ReadObject<UUID>(){

            @Override
            public UUID read(JsonReader jsonReader) throws IOException {
                return UUIDConverter.deserialize(jsonReader);
            }
        };
        Writer = new JsonWriter.WriteObject<UUID>(){

            @Override
            public void write(JsonWriter jsonWriter, UUID uUID) {
                UUIDConverter.serializeNullable(uUID, jsonWriter);
            }
        };
        Lookup = new char[256];
        Values = new byte[55];
        for (n = 0; n < 256; ++n) {
            int n2 = n >> 4 & 0xF;
            int n3 = n & 0xF;
            UUIDConverter.Lookup[n] = (char)(((n2 < 10 ? 48 + n2 : 97 + n2 - 10) << 8) + (n3 < 10 ? 48 + n3 : 97 + n3 - 10));
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            UUIDConverter.Values[n - 48] = (byte)(n - 48);
        }
        for (n = 97; n <= 102; n = (int)((char)(n + 1))) {
            UUIDConverter.Values[n - 48] = (byte)(n - 97 + 10);
        }
        for (n = 65; n <= 70; n = (int)((char)(n + 1))) {
            UUIDConverter.Values[n - 48] = (byte)(n - 65 + 10);
        }
    }
}

