/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConverter {
    static JsonReader.ReadObject<Element> Reader = new JsonReader.ReadObject<Element>(){

        @Override
        public Element read(JsonReader jsonReader) throws IOException {
            return XmlConverter.deserialize(jsonReader);
        }
    };
    static JsonWriter.WriteObject<Element> Writer = new JsonWriter.WriteObject<Element>(){

        @Override
        public void write(JsonWriter jsonWriter, Element element) {
            XmlConverter.serializeNullable(element, jsonWriter);
        }
    };
    private static DocumentBuilder documentBuilder;

    public static void serializeNullable(Element element, JsonWriter jsonWriter) {
        if (element == null) {
            jsonWriter.writeNull();
        } else {
            XmlConverter.serialize(element, jsonWriter);
        }
    }

    public static void serialize(Element element, JsonWriter jsonWriter) {
        Document document = element.getOwnerDocument();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lSOutput.setCharacterStream(stringWriter);
        lSSerializer.write(document, lSOutput);
        StringConverter.serialize(stringWriter.toString(), jsonWriter);
    }

    public static Element deserialize(JsonReader jsonReader) throws IOException {
        try {
            InputSource inputSource = new InputSource(new StringReader(jsonReader.readString()));
            return documentBuilder.parse(inputSource).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    public static ArrayList<Element> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Element> collection) throws IOException {
        jsonReader.deserializeCollection(Reader, collection);
    }

    public static ArrayList<Element> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Element> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Reader, collection);
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }
}

