/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BinaryConverter {
    static final JsonReader.ReadObject<byte[]> Base64Reader = new JsonReader.ReadObject<byte[]>(){

        @Override
        public byte[] read(JsonReader jsonReader) throws IOException {
            return BinaryConverter.deserialize(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<byte[]> Base64Writer = new JsonWriter.WriteObject<byte[]>(){

        @Override
        public void write(JsonWriter jsonWriter, byte[] byArray) {
            BinaryConverter.serialize(byArray, jsonWriter);
        }
    };

    public static void serialize(byte[] byArray, JsonWriter jsonWriter) {
        if (byArray == null) {
            jsonWriter.writeNull();
        } else if (byArray.length == 0) {
            jsonWriter.writeAscii("\"\"");
        } else {
            jsonWriter.writeBinary(byArray);
        }
    }

    public static byte[] deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readBase64();
    }

    public static ArrayList<byte[]> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Base64Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<byte[]> collection) throws IOException {
        jsonReader.deserializeCollection(Base64Reader, collection);
    }

    public static ArrayList<byte[]> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(Base64Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<byte[]> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Base64Reader, collection);
    }
}

