/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.BinaryConverter;
import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NumberConverter;
import com.dslplatform.client.json.StringConverter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;

public abstract class GeomConverter {
    static final JsonReader.ReadObject<Point2D.Double> LocationReader = new JsonReader.ReadObject<Point2D.Double>(){

        @Override
        public Point2D.Double read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeLocation(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Point2D> LocationWriter = new JsonWriter.WriteObject<Point2D>(){

        @Override
        public void write(JsonWriter jsonWriter, Point2D point2D) {
            GeomConverter.serializeLocationNullable(point2D, jsonWriter);
        }
    };
    static final JsonReader.ReadObject<Point> PointReader = new JsonReader.ReadObject<Point>(){

        @Override
        public Point read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializePoint(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Point> PointWriter = new JsonWriter.WriteObject<Point>(){

        @Override
        public void write(JsonWriter jsonWriter, Point point) {
            GeomConverter.serializePointNullable(point, jsonWriter);
        }
    };
    static final JsonReader.ReadObject<Rectangle2D.Double> RectangleReader = new JsonReader.ReadObject<Rectangle2D.Double>(){

        @Override
        public Rectangle2D.Double read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeRectangle(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Rectangle2D> RectangleWriter = new JsonWriter.WriteObject<Rectangle2D>(){

        @Override
        public void write(JsonWriter jsonWriter, Rectangle2D rectangle2D) {
            GeomConverter.serializeRectangleNullable(rectangle2D, jsonWriter);
        }
    };
    static final JsonWriter.WriteObject<Image> ImageWriter = new JsonWriter.WriteObject<Image>(){

        @Override
        public void write(JsonWriter jsonWriter, Image image) {
            GeomConverter.serialize(image, jsonWriter);
        }
    };
    static final JsonReader.ReadObject<BufferedImage> ImageReader = new JsonReader.ReadObject<BufferedImage>(){

        @Override
        public BufferedImage read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeImage(jsonReader);
        }
    };

    public static void serializeLocationNullable(Point2D point2D, JsonWriter jsonWriter) {
        if (point2D == null) {
            jsonWriter.writeNull();
        } else {
            GeomConverter.serializeLocation(point2D, jsonWriter);
        }
    }

    public static void serializeLocation(Point2D point2D, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(point2D.getX(), jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(point2D.getY(), jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Point2D.Double deserializeLocation(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new Point2D.Double();
        }
        double d = 0.0;
        double d2 = 0.0;
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        double d3 = NumberConverter.deserializeDouble(jsonReader);
        if ("X".equalsIgnoreCase(string)) {
            d = d3;
        } else if ("Y".equalsIgnoreCase(string)) {
            d2 = d3;
        }
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            d3 = NumberConverter.deserializeDouble(jsonReader);
            if ("X".equalsIgnoreCase(string)) {
                d = d3;
                continue;
            }
            if (!"Y".equalsIgnoreCase(string)) continue;
            d2 = d3;
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return new Point2D.Double(d, d2);
    }

    public static ArrayList<Point2D> deserializeLocationCollection(JsonReader jsonReader) throws IOException {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(4);
        jsonReader.deserializeCollection(LocationReader, arrayList);
        return arrayList;
    }

    public static void deserializeLocationCollection(JsonReader jsonReader, Collection<Point2D> collection) throws IOException {
        jsonReader.deserializeCollection(LocationReader, collection);
    }

    public static ArrayList<Point2D> deserializeLocationNullableCollection(JsonReader jsonReader) throws IOException {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(4);
        jsonReader.deserializeNullableCollection(LocationReader, arrayList);
        return arrayList;
    }

    public static void deserializeLocationNullableCollection(JsonReader jsonReader, Collection<Point2D> collection) throws IOException {
        jsonReader.deserializeNullableCollection(LocationReader, collection);
    }

    public static void serializePointNullable(Point point, JsonWriter jsonWriter) {
        if (point == null) {
            jsonWriter.writeNull();
        } else {
            GeomConverter.serializePoint(point, jsonWriter);
        }
    }

    public static void serializePoint(Point point, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(point.x, jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(point.y, jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Point deserializePoint(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new Point();
        }
        int n = 0;
        int n2 = 0;
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        int n3 = NumberConverter.deserializeInt(jsonReader);
        if ("X".equalsIgnoreCase(string)) {
            n = n3;
        } else if ("Y".equalsIgnoreCase(string)) {
            n2 = n3;
        }
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            n3 = NumberConverter.deserializeInt(jsonReader);
            if ("X".equalsIgnoreCase(string)) {
                n = n3;
                continue;
            }
            if (!"Y".equalsIgnoreCase(string)) continue;
            n2 = n3;
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return new Point(n, n2);
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(PointReader);
    }

    public static void deserializePointCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeCollection(PointReader, collection);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(PointReader);
    }

    public static void deserializePointNullableCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeNullableCollection(PointReader, collection);
    }

    public static void serializeRectangleNullable(Rectangle2D rectangle2D, JsonWriter jsonWriter) {
        if (rectangle2D == null) {
            jsonWriter.writeNull();
        } else {
            GeomConverter.serializeRectangle(rectangle2D, jsonWriter);
        }
    }

    public static void serializeRectangle(Rectangle2D rectangle2D, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(rectangle2D.getX(), jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(rectangle2D.getY(), jsonWriter);
        jsonWriter.writeAscii(",\"Width\":");
        NumberConverter.serialize(rectangle2D.getWidth(), jsonWriter);
        jsonWriter.writeAscii(",\"Height\":");
        NumberConverter.serialize(rectangle2D.getHeight(), jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Rectangle2D.Double deserializeRectangle(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new Rectangle2D.Double();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        double d5 = NumberConverter.deserializeDouble(jsonReader);
        if ("X".equalsIgnoreCase(string)) {
            d = d5;
        } else if ("Y".equalsIgnoreCase(string)) {
            d2 = d5;
        } else if ("Width".equalsIgnoreCase(string)) {
            d3 = d5;
        } else if ("Height".equalsIgnoreCase(string)) {
            d4 = d5;
        }
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            d5 = NumberConverter.deserializeDouble(jsonReader);
            if ("X".equalsIgnoreCase(string)) {
                d = d5;
                continue;
            }
            if ("Y".equalsIgnoreCase(string)) {
                d2 = d5;
                continue;
            }
            if ("Width".equalsIgnoreCase(string)) {
                d3 = d5;
                continue;
            }
            if (!"Height".equalsIgnoreCase(string)) continue;
            d4 = d5;
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleCollection(JsonReader jsonReader) throws IOException {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(4);
        jsonReader.deserializeCollection(RectangleReader, arrayList);
        return arrayList;
    }

    public static void deserializeRectangleCollection(JsonReader jsonReader, Collection<Rectangle2D> collection) throws IOException {
        jsonReader.deserializeCollection(RectangleReader, collection);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleNullableCollection(JsonReader jsonReader) throws IOException {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(4);
        jsonReader.deserializeNullableCollection(RectangleReader, arrayList);
        return arrayList;
    }

    public static void deserializeRectangleNullableCollection(JsonReader jsonReader, Collection<Rectangle2D> collection) throws IOException {
        jsonReader.deserializeNullableCollection(RectangleReader, collection);
    }

    public static void serialize(Image image, JsonWriter jsonWriter) {
        Object object;
        Object object2;
        if (image == null) {
            jsonWriter.writeNull();
            return;
        }
        if (image instanceof RenderedImage) {
            object2 = (RenderedImage)((Object)image);
        } else {
            object = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            object2 = object;
        }
        object = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)object2, "png", (OutputStream)object);
            BinaryConverter.serialize(((ByteArrayOutputStream)object).toByteArray(), jsonWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage deserializeImage(JsonReader jsonReader) throws IOException {
        byte[] byArray = BinaryConverter.deserialize(jsonReader);
        return ImageIO.read(new ByteArrayInputStream(byArray));
    }

    public static ArrayList<BufferedImage> deserializeImageCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(ImageReader);
    }

    public static void deserializeImageCollection(JsonReader jsonReader, Collection<BufferedImage> collection) throws IOException {
        jsonReader.deserializeCollection(ImageReader, collection);
    }

    public static ArrayList<BufferedImage> deserializeImageNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(ImageReader);
    }

    public static void deserializeImageNullableCollection(JsonReader jsonReader, Collection<BufferedImage> collection) throws IOException {
        jsonReader.deserializeNullableCollection(ImageReader, collection);
    }
}

