/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.DslJsonSerialization;
import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NumberConverter;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ObjectConverter {
    static final JsonReader.ReadObject<Object> ObjectReader = new JsonReader.ReadObject<Object>(){

        @Override
        public Object read(JsonReader jsonReader) throws IOException {
            return ObjectConverter.deserializeObject(jsonReader);
        }
    };
    static final JsonReader.ReadObject<Collection> CollectionReader = new JsonReader.ReadObject<Collection>(){

        @Override
        public Collection read(JsonReader jsonReader) throws IOException {
            return ObjectConverter.deserializeList(jsonReader);
        }
    };
    static final JsonReader.ReadObject<LinkedHashMap> MapReader = new JsonReader.ReadObject<LinkedHashMap>(){

        @Override
        public LinkedHashMap read(JsonReader jsonReader) throws IOException {
            return ObjectConverter.deserializeMap(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Map> MapWriter = new JsonWriter.WriteObject<Map>(){

        @Override
        public void write(JsonWriter jsonWriter, Map map) {
            try {
                ObjectConverter.serializeMap(map, jsonWriter);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    };
    private static final DslJsonSerialization JSON = new DslJsonSerialization(null);

    public static Object deserializeObject(JsonReader jsonReader) throws IOException {
        switch (jsonReader.last()) {
            case 110: {
                if (!jsonReader.wasNull()) {
                    throw new IOException("Expecting 'null' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
                }
                return null;
            }
            case 34: {
                return jsonReader.readString();
            }
            case 123: {
                return ObjectConverter.deserializeMap(jsonReader);
            }
            case 91: {
                return ObjectConverter.deserializeList(jsonReader);
            }
        }
        return NumberConverter.deserializeNumber(jsonReader);
    }

    public static ArrayList<Object> deserializeList(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 91) {
            throw new IOException("Expecting '[' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 93) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        arrayList.add(ObjectConverter.deserializeObject(jsonReader));
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            arrayList.add(ObjectConverter.deserializeObject(jsonReader));
        }
        if (by != 93) {
            throw new IOException("Expecting ']' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return arrayList;
    }

    public static void serializeMap(Map<String, Object> map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeByte((byte)123);
        int n = map.size();
        if (n > 0) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            Map.Entry<String, Object> entry = iterator.next();
            jsonWriter.writeString(entry.getKey());
            jsonWriter.writeByte((byte)58);
            JSON.serialize(jsonWriter, entry.getValue());
            for (int i = 1; i < n; ++i) {
                jsonWriter.writeByte((byte)44);
                entry = iterator.next();
                jsonWriter.writeString(entry.getKey());
                jsonWriter.writeByte((byte)58);
                JSON.serialize(jsonWriter, entry.getValue());
            }
        }
        jsonWriter.writeByte((byte)125);
    }

    public static LinkedHashMap<String, Object> deserializeMap(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        linkedHashMap.put(string, ObjectConverter.deserializeObject(jsonReader));
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            linkedHashMap.put(string, ObjectConverter.deserializeObject(jsonReader));
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return linkedHashMap;
    }
}

