/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class StringConverter {
    static final JsonReader.ReadObject<String> Reader = new JsonReader.ReadObject<String>(){

        @Override
        public String read(JsonReader jsonReader) throws IOException {
            return jsonReader.readString();
        }
    };
    static final JsonWriter.WriteObject<String> Writer = new JsonWriter.WriteObject<String>(){

        @Override
        public void write(JsonWriter jsonWriter, String string) {
            StringConverter.serializeNullable(string, jsonWriter);
        }
    };

    public static void serializeShortNullable(String string, JsonWriter jsonWriter) {
        if (string == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeString(string);
        }
    }

    public static void serializeShort(String string, JsonWriter jsonWriter) {
        jsonWriter.writeString(string);
    }

    public static void serializeNullable(String string, JsonWriter jsonWriter) {
        if (string == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeString(string);
        }
    }

    public static void serialize(String string, JsonWriter jsonWriter) {
        jsonWriter.writeString(string);
    }

    public static String deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readString();
    }

    public static String deserializeNullable(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 110) {
            if (!jsonReader.wasNull()) {
                throw new IOException("Expecting 'null' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
            }
            return null;
        }
        return jsonReader.readString();
    }

    public static ArrayList<String> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeCollection(Reader, collection);
    }

    public static ArrayList<String> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Reader, collection);
    }

    public static void serialize(List<String> list, JsonWriter jsonWriter) {
        jsonWriter.writeByte((byte)91);
        if (list.size() != 0) {
            jsonWriter.writeString(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                jsonWriter.writeByte((byte)44);
                jsonWriter.writeString(list.get(i));
            }
        }
        jsonWriter.writeByte((byte)93);
    }
}

