/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.patterns.ServiceLocator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

class MapServiceLocator
implements ServiceLocator {
    private final Map<Class<?>, Object> components = new LinkedHashMap();
    private static final boolean cacheResult = true;

    MapServiceLocator() {
        this.components.put(ServiceLocator.class, this);
    }

    MapServiceLocator(Map<Class<?>, Object> map) {
        this.components.put(ServiceLocator.class, this);
        this.components.putAll(map);
    }

    <T> T resolveOrRegister(Class<T> clazz, LazyInstance<T> lazyInstance) {
        if (this.components.containsKey(clazz)) {
            return this.resolve(clazz);
        }
        T t = lazyInstance.create();
        this.components.put(clazz, t);
        return t;
    }

    @Override
    public <T> T resolve(Class<T> clazz) {
        Object object = this.resolve(clazz, true);
        return clazz.cast(object);
    }

    private void cacheIf(Class<?> clazz, Object object) {
        if (object != null) {
            this.register(clazz, object);
        }
    }

    private Object resolve(Class<?> clazz, boolean bl) {
        Object object = this.components.get(clazz);
        if (object != null) {
            return object instanceof Class ? this.tryResolve((Class)object) : object;
        }
        Object object2 = this.tryResolve(clazz);
        if (object2 == null && bl) {
            throw new RuntimeException("Container could not locate class of type: " + clazz.getName());
        }
        this.cacheIf(clazz, object2);
        return object2;
    }

    private Object tryResolve(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = true;
            for (Class<?> clazz2 : constructor.getParameterTypes()) {
                Object object = this.resolve(clazz2, false);
                if (object == null) {
                    bl = false;
                    break;
                }
                arrayList.add(object);
            }
            if (!bl) continue;
            try {
                Object obj = constructor.newInstance(arrayList.toArray());
                this.cacheIf(clazz, obj);
                return obj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> MapServiceLocator register(Class<T> clazz, Object object) {
        this.components.put(clazz, object);
        return this;
    }

    static interface LazyInstance<T> {
        public T create();
    }
}

