/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.dslplatform.client.json.BinaryConverter;
import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NumberConverter;
import com.dslplatform.client.json.StringConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AndroidGeomConverter {
    static final JsonReader.ReadObject<PointF> LocationReader = new JsonReader.ReadObject<PointF>(){

        @Override
        public PointF read(JsonReader jsonReader) throws IOException {
            return AndroidGeomConverter.deserializeLocation(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<PointF> LocationWriter = new JsonWriter.WriteObject<PointF>(){

        @Override
        public void write(JsonWriter jsonWriter, PointF pointF) {
            AndroidGeomConverter.serializeLocationNullable(pointF, jsonWriter);
        }
    };
    static final JsonReader.ReadObject<Point> PointReader = new JsonReader.ReadObject<Point>(){

        @Override
        public Point read(JsonReader jsonReader) throws IOException {
            return AndroidGeomConverter.deserializePoint(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Point> PointWriter = new JsonWriter.WriteObject<Point>(){

        @Override
        public void write(JsonWriter jsonWriter, Point point) {
            AndroidGeomConverter.serializePointNullable(point, jsonWriter);
        }
    };
    static final JsonReader.ReadObject<Rect> RectangleReader = new JsonReader.ReadObject<Rect>(){

        @Override
        public Rect read(JsonReader jsonReader) throws IOException {
            return AndroidGeomConverter.deserializeRectangle(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Rect> RectangleWriter = new JsonWriter.WriteObject<Rect>(){

        @Override
        public void write(JsonWriter jsonWriter, Rect rect) {
            AndroidGeomConverter.serializeRectangleNullable(rect, jsonWriter);
        }
    };
    static final JsonReader.ReadObject<Bitmap> ImageReader = new JsonReader.ReadObject<Bitmap>(){

        @Override
        public Bitmap read(JsonReader jsonReader) throws IOException {
            return AndroidGeomConverter.deserializeImage(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Bitmap> ImageWriter = new JsonWriter.WriteObject<Bitmap>(){

        @Override
        public void write(JsonWriter jsonWriter, Bitmap bitmap) {
            AndroidGeomConverter.serialize(bitmap, jsonWriter);
        }
    };

    public static void serializeLocationNullable(PointF pointF, JsonWriter jsonWriter) {
        if (pointF == null) {
            jsonWriter.writeNull();
        } else {
            AndroidGeomConverter.serializeLocation(pointF, jsonWriter);
        }
    }

    public static void serializeLocation(PointF pointF, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(pointF.x, jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(pointF.y, jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static PointF deserializeLocation(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new PointF();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        float f3 = NumberConverter.deserializeFloat(jsonReader);
        if ("X".equalsIgnoreCase(string)) {
            f = f3;
        } else if ("Y".equalsIgnoreCase(string)) {
            f2 = f3;
        }
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            f3 = NumberConverter.deserializeFloat(jsonReader);
            if ("X".equalsIgnoreCase(string)) {
                f = f3;
                continue;
            }
            if (!"Y".equalsIgnoreCase(string)) continue;
            f2 = f3;
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return new PointF(f, f2);
    }

    public static ArrayList<PointF> deserializeLocationCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(LocationReader);
    }

    public static void deserializeLocationCollection(JsonReader jsonReader, Collection<PointF> collection) throws IOException {
        jsonReader.deserializeCollection(LocationReader, collection);
    }

    public static ArrayList<PointF> deserializeLocationNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(LocationReader);
    }

    public static void deserializeLocationNullableCollection(JsonReader jsonReader, Collection<PointF> collection) throws IOException {
        jsonReader.deserializeNullableCollection(LocationReader, collection);
    }

    public static void serializePointNullable(Point point, JsonWriter jsonWriter) {
        if (point == null) {
            jsonWriter.writeNull();
        } else {
            AndroidGeomConverter.serializePoint(point, jsonWriter);
        }
    }

    public static void serializePoint(Point point, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(point.x, jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(point.y, jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Point deserializePoint(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new Point();
        }
        int n = 0;
        int n2 = 0;
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        int n3 = NumberConverter.deserializeInt(jsonReader);
        if ("X".equalsIgnoreCase(string)) {
            n = n3;
        } else if ("Y".equalsIgnoreCase(string)) {
            n2 = n3;
        }
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            n3 = NumberConverter.deserializeInt(jsonReader);
            if ("X".equalsIgnoreCase(string)) {
                n = n3;
                continue;
            }
            if (!"Y".equalsIgnoreCase(string)) continue;
            n2 = n3;
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return new Point(n, n2);
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(PointReader);
    }

    public static void deserializePointCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeCollection(PointReader, collection);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(PointReader);
    }

    public static void deserializePointNullableCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeNullableCollection(PointReader, collection);
    }

    public static void serializeRectangleNullable(Rect rect, JsonWriter jsonWriter) {
        if (rect == null) {
            jsonWriter.writeNull();
        } else {
            AndroidGeomConverter.serializeRectangle(rect, jsonWriter);
        }
    }

    public static void serializeRectangle(Rect rect, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"X\":");
        NumberConverter.serialize(rect.left, jsonWriter);
        jsonWriter.writeAscii(",\"Y\":");
        NumberConverter.serialize(rect.top, jsonWriter);
        jsonWriter.writeAscii(",\"Width\":");
        NumberConverter.serialize(rect.width(), jsonWriter);
        jsonWriter.writeAscii(",\"Height\":");
        NumberConverter.serialize(rect.height(), jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static Rect deserializeRectangle(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return new Rect();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        int n5 = NumberConverter.deserializeInt(jsonReader);
        if ("X".equalsIgnoreCase(string)) {
            n = n5;
        } else if ("Y".equalsIgnoreCase(string)) {
            n2 = n5;
        } else if ("Width".equalsIgnoreCase(string)) {
            n3 = n5;
        } else if ("Height".equalsIgnoreCase(string)) {
            n4 = n5;
        }
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            n5 = NumberConverter.deserializeInt(jsonReader);
            if ("X".equalsIgnoreCase(string)) {
                n = n5;
                continue;
            }
            if ("Y".equalsIgnoreCase(string)) {
                n2 = n5;
                continue;
            }
            if ("Width".equalsIgnoreCase(string)) {
                n3 = n5;
                continue;
            }
            if (!"Height".equalsIgnoreCase(string)) continue;
            n4 = n5;
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return new Rect(n, n2, n + n3, n2 + n4);
    }

    public static ArrayList<Rect> deserializeRectangleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(RectangleReader);
    }

    public static void deserializeRectangleCollection(JsonReader jsonReader, Collection<Rect> collection) throws IOException {
        jsonReader.deserializeCollection(RectangleReader, collection);
    }

    public static ArrayList<Rect> deserializeRectangleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(RectangleReader);
    }

    public static void deserializeRectangleNullableCollection(JsonReader jsonReader, Collection<Rect> collection) throws IOException {
        jsonReader.deserializeNullableCollection(RectangleReader, collection);
    }

    public static void serialize(Bitmap bitmap, JsonWriter jsonWriter) {
        if (bitmap == null) {
            jsonWriter.writeNull();
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bitmap.getByteCount());
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            BinaryConverter.serialize(byteArrayOutputStream.toByteArray(), jsonWriter);
        }
    }

    public static Bitmap deserializeImage(JsonReader jsonReader) throws IOException {
        byte[] byArray = BinaryConverter.deserialize(jsonReader);
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static ArrayList<Bitmap> deserializeImageCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(ImageReader);
    }

    public static void deserializeImageCollection(JsonReader jsonReader, Collection<Bitmap> collection) throws IOException {
        jsonReader.deserializeCollection(ImageReader, collection);
    }

    public static ArrayList<Bitmap> deserializeImageNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(ImageReader);
    }

    public static void deserializeImageNullableCollection(JsonReader jsonReader, Collection<Bitmap> collection) throws IOException {
        jsonReader.deserializeNullableCollection(ImageReader, collection);
    }
}

