/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BoolConverter {
    static final JsonReader.ReadObject<Boolean> BooleanReader = new JsonReader.ReadObject<Boolean>(){

        @Override
        public Boolean read(JsonReader jsonReader) throws IOException {
            return BoolConverter.deserialize(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Boolean> BooleanWriter = new JsonWriter.WriteObject<Boolean>(){

        @Override
        public void write(JsonWriter jsonWriter, Boolean bl) {
            BoolConverter.serializeNullable(bl, jsonWriter);
        }
    };

    public static void serializeNullable(Boolean bl, JsonWriter jsonWriter) {
        if (bl == null) {
            jsonWriter.writeNull();
        } else if (bl.booleanValue()) {
            jsonWriter.writeAscii("true");
        } else {
            jsonWriter.writeAscii("false");
        }
    }

    public static void serialize(boolean bl, JsonWriter jsonWriter) {
        if (bl) {
            jsonWriter.writeAscii("true");
        } else {
            jsonWriter.writeAscii("false");
        }
    }

    public static void serialize(boolean[] blArray, JsonWriter jsonWriter) {
        if (blArray == null) {
            jsonWriter.writeNull();
        } else if (blArray.length == 0) {
            jsonWriter.writeAscii("[]");
        } else {
            jsonWriter.writeByte((byte)91);
            jsonWriter.writeAscii(blArray[0] ? "true" : "false");
            for (int i = 1; i < blArray.length; ++i) {
                jsonWriter.writeAscii(blArray[i] ? ",true" : ",false");
            }
            jsonWriter.writeByte((byte)93);
        }
    }

    public static boolean deserialize(JsonReader jsonReader) throws IOException {
        if (jsonReader.wasTrue()) {
            return true;
        }
        if (jsonReader.wasFalse()) {
            return false;
        }
        throw new IOException("Found invalid boolean value at: " + jsonReader.positionInStream());
    }

    public static ArrayList<Boolean> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(BooleanReader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Boolean> collection) throws IOException {
        jsonReader.deserializeCollection(BooleanReader, collection);
    }

    public static ArrayList<Boolean> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(BooleanReader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Boolean> collection) throws IOException {
        jsonReader.deserializeNullableCollection(BooleanReader, collection);
    }
}

