/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.client.json.AndroidGeomConverter;
import com.dslplatform.client.json.BinaryConverter;
import com.dslplatform.client.json.BoolConverter;
import com.dslplatform.client.json.DateConverter;
import com.dslplatform.client.json.GeomConverter;
import com.dslplatform.client.json.JacksonJsonSerialization;
import com.dslplatform.client.json.JsonObject;
import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NetConverter;
import com.dslplatform.client.json.NumberConverter;
import com.dslplatform.client.json.ObjectConverter;
import com.dslplatform.client.json.StorageConverter;
import com.dslplatform.client.json.StringConverter;
import com.dslplatform.client.json.UUIDConverter;
import com.dslplatform.client.json.XmlConverter;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.Bytes;
import com.dslplatform.patterns.History;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.patterns.Snapshot;
import com.dslplatform.storage.S3;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.w3c.dom.Element;

public class DslJsonSerialization
implements JsonSerialization {
    private final ServiceLocator locator;
    private final ConcurrentHashMap<Class<?>, JsonReader.ReadJsonObject<JsonObject>> jsonObjectReaders = new ConcurrentHashMap();
    private final HashMap<Class<?>, JsonReader.ReadObject<?>> jsonReaders = new HashMap();
    private final HashMap<Class<?>, JsonWriter.WriteObject<?>> jsonWriters = new HashMap();
    private final ConcurrentMap<Class<?>, Class<?>> writerMap = new ConcurrentHashMap();
    private Object jackson;
    private static final Bytes NULL = new Bytes(new byte[]{110, 117, 108, 108}, 4);

    public DslJsonSerialization(ServiceLocator serviceLocator) {
        this.locator = serviceLocator;
        this.registerReader(byte[].class, BinaryConverter.Base64Reader);
        this.registerWriter(byte[].class, BinaryConverter.Base64Writer);
        this.registerReader(Boolean.TYPE, BoolConverter.BooleanReader);
        this.registerReader(Boolean.class, BoolConverter.BooleanReader);
        this.registerWriter(Boolean.TYPE, BoolConverter.BooleanWriter);
        this.registerWriter(Boolean.class, BoolConverter.BooleanWriter);
        DslJsonSerialization.registerJodaConverters(this);
        if (Utils.IS_ANDROID) {
            DslJsonSerialization.registerAndroidSpecifics(this);
        } else {
            DslJsonSerialization.registerJavaSpecifics(this);
        }
        this.registerReader(LinkedHashMap.class, ObjectConverter.MapReader);
        this.registerReader(HashMap.class, ObjectConverter.MapReader);
        this.registerReader(Map.class, ObjectConverter.MapReader);
        this.registerWriter(Map.class, ObjectConverter.MapWriter);
        this.registerReader(URI.class, NetConverter.UriReader);
        this.registerWriter(URI.class, NetConverter.UriWriter);
        this.registerReader(InetAddress.class, NetConverter.AddressReader);
        this.registerWriter(InetAddress.class, NetConverter.AddressWriter);
        this.registerReader(Double.TYPE, NumberConverter.DoubleReader);
        this.registerWriter(Double.TYPE, NumberConverter.DoubleWriter);
        this.registerReader(Double.class, NumberConverter.DoubleReader);
        this.registerWriter(Double.class, NumberConverter.DoubleWriter);
        this.registerReader(Float.TYPE, NumberConverter.FloatReader);
        this.registerWriter(Float.TYPE, NumberConverter.FloatWriter);
        this.registerReader(Float.class, NumberConverter.FloatReader);
        this.registerWriter(Float.class, NumberConverter.FloatWriter);
        this.registerReader(Integer.TYPE, NumberConverter.IntReader);
        this.registerWriter(Integer.TYPE, NumberConverter.IntWriter);
        this.registerReader(Integer.class, NumberConverter.IntReader);
        this.registerWriter(Integer.class, NumberConverter.IntWriter);
        this.registerReader(Long.TYPE, NumberConverter.LongReader);
        this.registerWriter(Long.TYPE, NumberConverter.LongWriter);
        this.registerReader(Long.class, NumberConverter.LongReader);
        this.registerWriter(Long.class, NumberConverter.LongWriter);
        this.registerReader(BigDecimal.class, NumberConverter.DecimalReader);
        this.registerWriter(BigDecimal.class, NumberConverter.DecimalWriter);
        this.registerReader(String.class, StringConverter.Reader);
        this.registerWriter(String.class, StringConverter.Writer);
        this.registerReader(UUID.class, UUIDConverter.Reader);
        this.registerWriter(UUID.class, UUIDConverter.Writer);
        this.registerReader(Element.class, XmlConverter.Reader);
        this.registerWriter(Element.class, XmlConverter.Writer);
        this.registerReader(S3.class, StorageConverter.S3Reader);
        this.registerWriter(S3.class, StorageConverter.S3Writer);
        this.registerReader(Number.class, NumberConverter.NumberReader);
    }

    static void registerAndroidSpecifics(DslJsonSerialization dslJsonSerialization) {
        dslJsonSerialization.registerReader(PointF.class, AndroidGeomConverter.LocationReader);
        dslJsonSerialization.registerWriter(PointF.class, AndroidGeomConverter.LocationWriter);
        dslJsonSerialization.registerReader(Point.class, AndroidGeomConverter.PointReader);
        dslJsonSerialization.registerWriter(Point.class, AndroidGeomConverter.PointWriter);
        dslJsonSerialization.registerReader(Rect.class, AndroidGeomConverter.RectangleReader);
        dslJsonSerialization.registerWriter(Rect.class, AndroidGeomConverter.RectangleWriter);
        dslJsonSerialization.registerReader(Bitmap.class, AndroidGeomConverter.ImageReader);
        dslJsonSerialization.registerWriter(Bitmap.class, AndroidGeomConverter.ImageWriter);
    }

    static void registerJodaConverters(DslJsonSerialization dslJsonSerialization) {
        dslJsonSerialization.registerReader(LocalDate.class, DateConverter.LocalDateReader);
        dslJsonSerialization.registerWriter(LocalDate.class, DateConverter.LocalDateWriter);
        dslJsonSerialization.registerReader(DateTime.class, DateConverter.DateTimeReader);
        dslJsonSerialization.registerWriter(DateTime.class, DateConverter.DateTimeWriter);
    }

    static void registerJavaSpecifics(DslJsonSerialization dslJsonSerialization) {
        dslJsonSerialization.registerReader(Point2D.Double.class, GeomConverter.LocationReader);
        dslJsonSerialization.registerReader(Point2D.class, GeomConverter.LocationReader);
        dslJsonSerialization.registerWriter(Point2D.class, GeomConverter.LocationWriter);
        dslJsonSerialization.registerReader(java.awt.Point.class, GeomConverter.PointReader);
        dslJsonSerialization.registerWriter(java.awt.Point.class, GeomConverter.PointWriter);
        dslJsonSerialization.registerReader(Rectangle2D.Double.class, GeomConverter.RectangleReader);
        dslJsonSerialization.registerReader(Rectangle2D.class, GeomConverter.RectangleReader);
        dslJsonSerialization.registerWriter(Rectangle2D.class, GeomConverter.RectangleWriter);
        dslJsonSerialization.registerReader(BufferedImage.class, GeomConverter.ImageReader);
        dslJsonSerialization.registerReader(Image.class, GeomConverter.ImageReader);
        dslJsonSerialization.registerWriter(Image.class, GeomConverter.ImageWriter);
    }

    private static boolean isNull(int n, byte[] byArray) {
        return n == 4 && byArray[0] == 110 && byArray[1] == 117 && byArray[2] == 108 && byArray[3] == 108;
    }

    <T, S extends T> void registerReader(Class<T> clazz, JsonReader.ReadObject<S> readObject) {
        this.jsonReaders.put(clazz, readObject);
    }

    <T> void registerWriter(Class<T> clazz, JsonWriter.WriteObject<T> writeObject) {
        this.writerMap.put(clazz, clazz);
        this.jsonWriters.put(clazz, writeObject);
    }

    private JsonWriter.WriteObject<?> tryFindWriter(Class<?> clazz) {
        Class clazz2 = (Class)this.writerMap.get(clazz);
        if (clazz2 != null) {
            return this.jsonWriters.get(clazz2);
        }
        ArrayList arrayList = new ArrayList();
        DslJsonSerialization.findAllSignatures(clazz, arrayList);
        for (Class<?> clazz3 : arrayList) {
            JsonWriter.WriteObject<?> writeObject = this.jsonWriters.get(clazz3);
            if (writeObject == null) continue;
            this.writerMap.putIfAbsent(clazz, clazz3);
            return writeObject;
        }
        return null;
    }

    private static void findAllSignatures(Class<?> clazz, ArrayList<Class<?>> arrayList) {
        if (arrayList.contains(clazz)) {
            return;
        }
        arrayList.add(clazz);
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && clazz2 != Object.class) {
            DslJsonSerialization.findAllSignatures(clazz2, arrayList);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            DslJsonSerialization.findAllSignatures(clazz3, arrayList);
        }
    }

    private JsonReader.ReadJsonObject<JsonObject> getObjectReader(Class<?> clazz) {
        try {
            JsonReader.ReadJsonObject readJsonObject = this.jsonObjectReaders.get(clazz);
            if (readJsonObject == null) {
                try {
                    readJsonObject = (JsonReader.ReadJsonObject)clazz.getField("JSON_READER").get(null);
                }
                catch (Exception exception) {
                    return null;
                }
                this.jsonObjectReaders.putIfAbsent(clazz, readJsonObject);
            }
            return readJsonObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <TResult> TResult deserialize(Class<TResult> clazz, byte[] byArray, int n) throws IOException {
        Class<?> clazz2;
        Object object;
        if (DslJsonSerialization.isNull(n, byArray)) {
            return null;
        }
        if (n == 2 && byArray[0] == 123 && byArray[1] == 125 && !clazz.isInterface()) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
        }
        if (JsonObject.class.isAssignableFrom(clazz)) {
            object = this.getObjectReader(clazz);
            clazz2 = new JsonReader(byArray, n, this.locator);
            if (object != null && ((JsonReader)((Object)clazz2)).getNextToken() == 123) {
                ((JsonReader)((Object)clazz2)).getNextToken();
                return (TResult)object.deserialize((JsonReader)((Object)clazz2), this.locator);
            }
        }
        if ((object = this.jsonReaders.get(clazz)) == null) {
            if (clazz.isArray()) {
                clazz2 = clazz.getComponentType();
                List<TResult> list = this.deserializeList((Class<TResult>)clazz2, byArray, n);
                if (list == null) {
                    return null;
                }
                Object object2 = Array.newInstance(clazz2, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(object2, i, list.get(i));
                }
                return (TResult)object2;
            }
            if (Utils.HAS_JACKSON) {
                return DslJsonSerialization.deserializeJackson(this, clazz, byArray, n);
            }
            this.showErrorMessage(clazz);
        }
        clazz2 = new JsonReader(byArray, n, this.locator);
        ((JsonReader)((Object)clazz2)).getNextToken();
        if (((JsonReader)((Object)clazz2)).wasNull()) {
            return null;
        }
        Object t = object.read((JsonReader)((Object)clazz2));
        if (((JsonReader)((Object)clazz2)).positionInStream() > ((JsonReader)((Object)clazz2)).length) {
            throw new IOException("JSON string was not closed with a double quote");
        }
        return (TResult)t;
    }

    private void showErrorMessage(Class<?> clazz) throws IOException {
        ArrayList arrayList = new ArrayList();
        DslJsonSerialization.findAllSignatures(clazz, arrayList);
        for (Class<?> clazz2 : arrayList) {
            if (!this.jsonReaders.containsKey(clazz2)) continue;
            throw new IOException("Unable to find reader for provided type: " + clazz + " and Jackson is not found on classpath.\n" + "Found reader for: " + clazz2 + " so try deserializing into it instead?\n" + "Alternatively, try initializing system with custom JsonSerialization or register specified type using registerReader into " + DslJsonSerialization.class);
        }
        throw new IOException("Unable to find reader for provided type: " + clazz + " and Jackson is not found on classpath.\n" + "Try initializing system with custom JsonSerialization or register specified type using registerReader into " + DslJsonSerialization.class);
    }

    private static <TResult> TResult deserializeJackson(DslJsonSerialization dslJsonSerialization, Class<TResult> clazz, byte[] byArray, int n) throws IOException {
        if (dslJsonSerialization.jackson == null) {
            dslJsonSerialization.jackson = new JacksonJsonSerialization(dslJsonSerialization.locator);
        }
        return ((JacksonJsonSerialization)dslJsonSerialization.jackson).deserialize(clazz, byArray, n);
    }

    private static <TResult> List<TResult> deserializeJacksonList(DslJsonSerialization dslJsonSerialization, Class<TResult> clazz, byte[] byArray, int n) throws IOException {
        if (dslJsonSerialization.jackson == null) {
            dslJsonSerialization.jackson = new JacksonJsonSerialization(dslJsonSerialization.locator);
        }
        return ((JacksonJsonSerialization)dslJsonSerialization.jackson).deserializeList(clazz, byArray, n);
    }

    private static Bytes serializeJackson(DslJsonSerialization dslJsonSerialization, Object object) throws IOException {
        if (dslJsonSerialization.jackson == null) {
            dslJsonSerialization.jackson = new JacksonJsonSerialization(dslJsonSerialization.locator);
        }
        return ((JacksonJsonSerialization)dslJsonSerialization.jackson).serialize(object);
    }

    public <TResult> List<TResult> deserializeList(Class<TResult> clazz, byte[] byArray, int n) throws IOException {
        JsonReader.ReadObject<?> readObject;
        if (DslJsonSerialization.isNull(n, byArray)) {
            return null;
        }
        if (n == 2 && byArray[0] == 91 && byArray[1] == 93) {
            return new ArrayList(0);
        }
        JsonReader jsonReader = new JsonReader(byArray, n, this.locator);
        if (jsonReader.getNextToken() != 91) {
            if (jsonReader.wasNull()) {
                return null;
            }
            throw new IOException("Expecting '[' as array start. Found: " + (char)jsonReader.last());
        }
        if (jsonReader.getNextToken() == 93) {
            return new ArrayList(0);
        }
        if (JsonObject.class.isAssignableFrom(clazz) && (readObject = this.getObjectReader(clazz)) != null) {
            return jsonReader.deserializeNullableCollection(readObject);
        }
        readObject = this.jsonReaders.get(clazz);
        if (readObject == null) {
            if (Utils.HAS_JACKSON) {
                return DslJsonSerialization.deserializeJacksonList(this, clazz, byArray, n);
            }
            this.showErrorMessage(clazz);
        }
        return jsonReader.deserializeNullableCollection(readObject);
    }

    public <TResult extends AggregateRoot> List<History<TResult>> deserializeHistoryList(Class<TResult> clazz, byte[] byArray, int n) throws IOException {
        if (DslJsonSerialization.isNull(n, byArray)) {
            return null;
        }
        if (n == 2 && byArray[0] == 91 && byArray[1] == 93) {
            return new ArrayList<History<TResult>>(0);
        }
        JsonReader jsonReader = new JsonReader(byArray, n, this.locator);
        if (jsonReader.getNextToken() != 91) {
            throw new IOException("Expecting '[' as array start. Found: " + (char)jsonReader.last());
        }
        if (jsonReader.getNextToken() == 93) {
            return new ArrayList<History<TResult>>(0);
        }
        JsonReader.ReadJsonObject<JsonObject> readJsonObject = this.getObjectReader(clazz);
        if (readJsonObject == null) {
            throw new IOException("Unable to find reader for provided history type: " + clazz);
        }
        ArrayList<History<TResult>> arrayList = new ArrayList<History<TResult>>();
        block4: while (true) {
            if (jsonReader.last() != 123) {
                throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
            }
            ArrayList<Snapshot<Object>> arrayList2 = null;
            jsonReader.getNextToken();
            String string = jsonReader.readString();
            if (jsonReader.getNextToken() != 58) {
                throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
            }
            if ("Snapshots".equalsIgnoreCase(string)) {
                arrayList2 = DslJsonSerialization.readSnaphosts(clazz, readJsonObject, jsonReader, this.locator);
            } else {
                jsonReader.skip();
            }
            while (jsonReader.getNextToken() == 44) {
                string = jsonReader.readString();
                if (jsonReader.getNextToken() != 58) {
                    throw new IOException("Expecting ':' at" + jsonReader.getCurrentIndex());
                }
                if ("Snapshots".equalsIgnoreCase(string)) {
                    arrayList2 = DslJsonSerialization.readSnaphosts(clazz, readJsonObject, jsonReader, this.locator);
                    continue;
                }
                jsonReader.skip();
            }
            if (jsonReader.last() != 125) {
                throw new IOException("Expecting '}' at " + jsonReader.getCurrentIndex());
            }
            if (arrayList2 == null) {
                throw new IOException("Snapshots not provided. It can't be null. Error at " + jsonReader.getCurrentIndex());
            }
            arrayList.add(new History(arrayList2));
            switch (jsonReader.getNextToken()) {
                case 93: {
                    return arrayList;
                }
                case 44: {
                    jsonReader.getNextToken();
                    continue block4;
                }
            }
            break;
        }
        throw new IOException("Expecting ']' or ',' at " + jsonReader.getCurrentIndex());
    }

    private static <TResult extends AggregateRoot> ArrayList<Snapshot<TResult>> readSnaphosts(Class<TResult> clazz, JsonReader.ReadJsonObject<JsonObject> readJsonObject, JsonReader jsonReader, ServiceLocator serviceLocator) throws IOException {
        if (jsonReader.getNextToken() != 91) {
            throw new IOException("Expecting '[' at " + jsonReader.getCurrentIndex());
        }
        if (jsonReader.getNextToken() == 93) {
            return new ArrayList<Snapshot<TResult>>(0);
        }
        ArrayList<Snapshot<TResult>> arrayList = new ArrayList<Snapshot<TResult>>();
        block4: while (true) {
            if (jsonReader.last() != 123) {
                throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
            }
            DateTime dateTime = Utils.MIN_DATE_TIME;
            String string = null;
            AggregateRoot aggregateRoot = null;
            jsonReader.getNextToken();
            String string2 = jsonReader.readString();
            if (jsonReader.getNextToken() != 58) {
                throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
            }
            jsonReader.getNextToken();
            if ("at".equalsIgnoreCase(string2)) {
                dateTime = DateConverter.deserializeDateTime(jsonReader);
            } else if ("action".equalsIgnoreCase(string2)) {
                string = StringConverter.deserialize(jsonReader);
            } else if ("value".equalsIgnoreCase(string2)) {
                if (jsonReader.last() != 123) {
                    throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
                }
                jsonReader.getNextToken();
                aggregateRoot = (AggregateRoot)((Object)readJsonObject.deserialize(jsonReader, serviceLocator));
            } else {
                jsonReader.skip();
            }
            while (jsonReader.getNextToken() == 44) {
                jsonReader.getNextToken();
                string2 = jsonReader.readString();
                if (jsonReader.getNextToken() != 58) {
                    throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
                }
                jsonReader.getNextToken();
                if ("at".equalsIgnoreCase(string2)) {
                    dateTime = DateConverter.deserializeDateTime(jsonReader);
                    continue;
                }
                if ("action".equalsIgnoreCase(string2)) {
                    string = StringConverter.deserialize(jsonReader);
                    continue;
                }
                if ("value".equalsIgnoreCase(string2)) {
                    if (jsonReader.last() != 123) {
                        throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
                    }
                    jsonReader.getNextToken();
                    aggregateRoot = (AggregateRoot)((Object)readJsonObject.deserialize(jsonReader, serviceLocator));
                    continue;
                }
                jsonReader.skip();
            }
            if (jsonReader.last() != 125) {
                throw new IOException("Expecting '}' at " + jsonReader.getCurrentIndex());
            }
            if (string == null) {
                throw new IOException("Action not provided. It can't be null. Error at " + jsonReader.getCurrentIndex());
            }
            if (aggregateRoot == null) {
                throw new IOException("Value not provided. It can't be null. Error at " + jsonReader.getCurrentIndex());
            }
            arrayList.add(new Snapshot<AggregateRoot>(dateTime, string, aggregateRoot));
            switch (jsonReader.getNextToken()) {
                case 93: {
                    return arrayList;
                }
                case 44: {
                    jsonReader.getNextToken();
                    continue block4;
                }
            }
            break;
        }
        throw new IOException("Expecting ']' or ',' at " + jsonReader.getCurrentIndex());
    }

    public <T extends JsonObject> void serialize(JsonWriter jsonWriter, T[] TArray) {
        if (TArray == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeByte((byte)91);
        if (TArray.length != 0) {
            T t = TArray[0];
            if (t != null) {
                t.serialize(jsonWriter, false);
            } else {
                jsonWriter.writeNull();
            }
            for (int i = 1; i < TArray.length; ++i) {
                jsonWriter.writeByte((byte)44);
                t = TArray[i];
                if (t != null) {
                    t.serialize(jsonWriter, false);
                    continue;
                }
                jsonWriter.writeNull();
            }
        }
        jsonWriter.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(JsonWriter jsonWriter, List<T> list) {
        if (list == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeByte((byte)91);
        if (list.size() != 0) {
            JsonObject jsonObject = (JsonObject)list.get(0);
            if (jsonObject != null) {
                jsonObject.serialize(jsonWriter, false);
            } else {
                jsonWriter.writeNull();
            }
            for (int i = 1; i < list.size(); ++i) {
                jsonWriter.writeByte((byte)44);
                jsonObject = (JsonObject)list.get(i);
                if (jsonObject != null) {
                    jsonObject.serialize(jsonWriter, false);
                    continue;
                }
                jsonWriter.writeNull();
            }
        }
        jsonWriter.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(JsonWriter jsonWriter, Collection<T> collection) {
        if (collection == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeByte((byte)91);
        if (!collection.isEmpty()) {
            Iterator<T> iterator = collection.iterator();
            JsonObject jsonObject = (JsonObject)iterator.next();
            if (jsonObject != null) {
                jsonObject.serialize(jsonWriter, false);
            } else {
                jsonWriter.writeNull();
            }
            while (iterator.hasNext()) {
                jsonWriter.writeByte((byte)44);
                jsonObject = (JsonObject)iterator.next();
                if (jsonObject != null) {
                    jsonObject.serialize(jsonWriter, false);
                    continue;
                }
                jsonWriter.writeNull();
            }
        }
        jsonWriter.writeByte((byte)93);
    }

    public <T> boolean serialize(JsonWriter jsonWriter, Class<?> clazz, Object object) {
        JsonWriter.WriteObject<?> writeObject;
        Object object2;
        if (object == null) {
            jsonWriter.writeNull();
            return true;
        }
        if (object instanceof JsonObject) {
            ((JsonObject)object).serialize(jsonWriter, false);
            return true;
        }
        if (object instanceof JsonObject[]) {
            this.serialize(jsonWriter, (JsonObject[])object);
            return true;
        }
        JsonWriter.WriteObject<?> writeObject2 = this.tryFindWriter(clazz);
        if (writeObject2 != null) {
            writeObject2.write(jsonWriter, object);
            return true;
        }
        if (clazz.isArray()) {
            if (Array.getLength(object) == 0) {
                jsonWriter.writeAscii("[]");
                return true;
            }
            object2 = clazz.getComponentType();
            if (((Class)object2).isPrimitive()) {
                if (object2 == Boolean.TYPE) {
                    BoolConverter.serialize((boolean[])object, jsonWriter);
                } else if (object2 == Integer.TYPE) {
                    NumberConverter.serialize((int[])object, jsonWriter);
                } else if (object2 == Long.TYPE) {
                    NumberConverter.serialize((long[])object, jsonWriter);
                } else if (object2 == Byte.TYPE) {
                    BinaryConverter.serialize((byte[])object, jsonWriter);
                } else if (object2 == Short.TYPE) {
                    NumberConverter.serialize((short[])object, jsonWriter);
                } else if (object2 == Float.TYPE) {
                    NumberConverter.serialize((float[])object, jsonWriter);
                } else if (object2 == Double.TYPE) {
                    NumberConverter.serialize((double[])object, jsonWriter);
                } else if (object2 == Character.TYPE) {
                    StringConverter.serialize(new String((char[])object), jsonWriter);
                } else {
                    return false;
                }
                return true;
            }
            writeObject = this.tryFindWriter((Class<?>)object2);
            if (writeObject != null) {
                jsonWriter.serialize((Object[])object, writeObject);
                return true;
            }
        }
        if (object instanceof Collection) {
            Object object3;
            object2 = (Collection)object;
            if (object2.isEmpty()) {
                jsonWriter.writeAscii("[]");
                return true;
            }
            writeObject = null;
            Iterator iterator = object2.iterator();
            do {
                Class<?> clazz2;
                if ((object3 = iterator.next()) == null || (clazz2 = object3.getClass()) == writeObject || writeObject != null && !clazz2.isAssignableFrom((Class<?>)((Object)writeObject))) continue;
                writeObject = clazz2;
            } while (iterator.hasNext());
            if (writeObject == null) {
                jsonWriter.writeByte((byte)91);
                jsonWriter.writeNull();
                for (int i = 1; i < object2.size(); ++i) {
                    jsonWriter.writeAscii(",null");
                }
                jsonWriter.writeByte((byte)93);
                return true;
            }
            if (JsonObject.class.isAssignableFrom((Class<?>)((Object)writeObject))) {
                this.serialize(jsonWriter, (Collection<T>)object2);
                return true;
            }
            object3 = this.tryFindWriter((Class<?>)((Object)writeObject));
            if (object3 != null) {
                jsonWriter.serialize(object2, object3);
                return true;
            }
        }
        return false;
    }

    @Override
    public final Bytes serialize(Object object) throws IOException {
        if (object == null) {
            return NULL;
        }
        JsonWriter jsonWriter = new JsonWriter();
        Class<?> clazz = object.getClass();
        if (!this.serialize(jsonWriter, clazz, object)) {
            if (Utils.HAS_JACKSON) {
                return DslJsonSerialization.serializeJackson(this, object);
            }
            throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + clazz);
        }
        return jsonWriter.toBytes();
    }

    @Override
    public final void serialize(Writer writer, Object object) throws IOException {
        if (writer instanceof JsonWriter) {
            this.serialize((JsonWriter)writer, object);
        } else {
            JsonWriter jsonWriter = new JsonWriter();
            this.serialize(jsonWriter, object);
            writer.write(jsonWriter.toString());
        }
    }

    public final void serialize(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (!this.serialize(jsonWriter, clazz, object)) {
            if (Utils.HAS_JACKSON) {
                Bytes bytes = DslJsonSerialization.serializeJackson(this, object);
                jsonWriter.write(bytes.toUtf8());
            }
            throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + clazz);
        }
    }
}

