/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.Base64;
import com.dslplatform.client.json.JsonObject;
import com.dslplatform.patterns.ServiceLocator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;

public final class JsonReader {
    private static final boolean[] Whitespace = new boolean[256];
    private int tokenStart;
    private int currentIndex = 0;
    private byte last = (byte)32;
    final int length;
    private final char[] tmp;
    final ServiceLocator locator;
    private final byte[] buffer;
    private static final Charset UTF_8;

    private JsonReader(char[] cArray, byte[] byArray, int n, ServiceLocator serviceLocator) {
        this.tmp = cArray;
        this.buffer = byArray;
        this.length = n;
        this.locator = serviceLocator;
    }

    public JsonReader(byte[] byArray, ServiceLocator serviceLocator) {
        this(new char[64], byArray, byArray.length, serviceLocator);
    }

    public JsonReader(byte[] byArray, ServiceLocator serviceLocator, char[] cArray) {
        this(cArray, byArray, byArray.length, serviceLocator);
        if (cArray == null) {
            throw new NullPointerException("tmp buffer provided as null.");
        }
    }

    public JsonReader(byte[] byArray, int n, ServiceLocator serviceLocator) throws IOException {
        this(byArray, n, serviceLocator, new char[64]);
    }

    public JsonReader(byte[] byArray, int n, ServiceLocator serviceLocator, char[] cArray) throws IOException {
        this(cArray, byArray, n, serviceLocator);
        if (cArray == null) {
            throw new NullPointerException("tmp buffer provided as null.");
        }
        if (n > byArray.length) {
            throw new IOException("length can't be longer than buffer.length");
        }
        if (n < byArray.length) {
            byArray[n] = 0;
        }
    }

    public String toString() {
        return new String(this.buffer, 0, this.length, UTF_8);
    }

    public final byte read() throws IOException {
        if (this.currentIndex >= this.length) {
            throw new IOException("Unexpected end of JSON input");
        }
        this.last = this.buffer[this.currentIndex++];
        return this.last;
    }

    boolean isEndOfStream() {
        return this.length == this.currentIndex;
    }

    public final byte last() {
        return this.last;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    public final char[] readNumber() {
        this.tokenStart = this.currentIndex - 1;
        this.tmp[0] = (char)this.last;
        int n = 1;
        int n2 = this.currentIndex;
        byte by = this.last;
        while (n < this.tmp.length && n2 < this.length && (by = this.buffer[n2++]) != 44 && by != 125 && by != 93) {
            this.tmp[n++] = (char)by;
        }
        this.currentIndex += n - 1;
        this.last = by;
        return this.tmp;
    }

    public final String readSimpleString() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        int n = 0;
        int n2 = this.currentIndex;
        try {
            byte by;
            while (n < this.tmp.length && (by = this.buffer[n2++]) != 34) {
                this.tmp[n++] = (char)by;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.currentIndex);
        }
        if (n2 > this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.currentIndex);
        }
        this.currentIndex = n2;
        return new String(this.tmp, 0, n);
    }

    public final char[] readSimpleQuote() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        int n = this.tokenStart = this.currentIndex;
        try {
            byte by;
            for (int i = 0; i < this.tmp.length && (by = this.buffer[n++]) != 34; ++i) {
                this.tmp[i] = (char)by;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.currentIndex);
        }
        if (n > this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.currentIndex);
        }
        this.currentIndex = n;
        return this.tmp;
    }

    public final String readString() throws IOException {
        int n;
        int n2;
        int n3 = this.currentIndex;
        if (this.last != 34) {
            throw new IOException("JSON string must start with a double quote at: " + this.currentIndex);
        }
        byte by = 0;
        int n4 = this.currentIndex;
        try {
            for (n2 = 0; n2 < this.tmp.length; ++n2) {
                if ((by = this.buffer[n4++]) == 34) {
                    this.currentIndex = n4;
                    return new String(this.tmp, 0, n2);
                }
                if ((by ^ 0x5C) >= 1) {
                    this.tmp[n2] = (char)by;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.currentIndex);
        }
        if (n4 >= this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + n4);
        }
        while (n4 < this.buffer.length && (by ^ 0x5C) >= 1) {
            if ((by = this.buffer[n4++]) != 34) continue;
            this.currentIndex = n4;
            return new String(this.buffer, n3, this.currentIndex - n3 - 1, "ISO-8859-1");
        }
        this.currentIndex = n4;
        if (this.currentIndex >= this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + n4);
        }
        n2 = --this.currentIndex - n3;
        char[] cArray = new char[n2 + 256];
        for (n = n2 - 1; n >= 0; --n) {
            cArray[n] = (char)this.buffer[n3 + n];
        }
        while (this.currentIndex < this.length) {
            block32: {
                block31: {
                    if ((n = this.buffer[this.currentIndex++]) == 34) {
                        return new String(cArray, 0, n2);
                    }
                    if (n2 >= cArray.length - 3) {
                        char[] cArray2 = new char[cArray.length << 1];
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        cArray = cArray2;
                    }
                    if (n != 92) break block31;
                    n = this.buffer[this.currentIndex++];
                    switch (n) {
                        case 98: {
                            n = 8;
                            break block32;
                        }
                        case 116: {
                            n = 9;
                            break block32;
                        }
                        case 110: {
                            n = 10;
                            break block32;
                        }
                        case 102: {
                            n = 12;
                            break block32;
                        }
                        case 114: {
                            n = 13;
                            break block32;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block32;
                        }
                        case 117: {
                            n = (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 12) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 8) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 4) + JsonReader.hexToInt(this.buffer[this.currentIndex++]);
                            break block32;
                        }
                        default: {
                            throw new IOException("Could not parse String, got invalid escape combination '\\" + n + "'");
                        }
                    }
                }
                if ((n & 0x80) != 0) {
                    byte by2 = this.buffer[this.currentIndex++];
                    if ((n & 0xE0) == 192) {
                        n = ((n & 0x1F) << 6) + (by2 & 0x3F);
                    } else {
                        byte by3 = this.buffer[this.currentIndex++];
                        if ((n & 0xF0) == 224) {
                            n = ((n & 0xF) << 12) + ((by2 & 0x3F) << 6) + (by3 & 0x3F);
                        } else {
                            byte by4 = this.buffer[this.currentIndex++];
                            if ((n & 0xF8) != 240) {
                                throw new IOException();
                            }
                            n = ((n & 7) << 18) + ((by2 & 0x3F) << 12) + ((by3 & 0x3F) << 6) + (by4 & 0x3F);
                            if (n >= 65536) {
                                if (n >= 0x110000) {
                                    throw new IOException();
                                }
                                int n5 = n - 65536;
                                cArray[n2++] = (char)((n5 >>> 10) + 55296);
                                cArray[n2++] = (char)((n5 & 0x3FF) + 56320);
                            }
                        }
                    }
                }
            }
            cArray[n2++] = (char)n;
        }
        throw new IOException("JSON string was not closed with a double quote!");
    }

    private static int hexToInt(byte by) throws IOException {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 55;
        }
        if (by >= 97 && by <= 102) {
            return by - 87;
        }
        throw new IOException("Could not parse unicode escape, expected a hexadecimal digit, got '" + by + "'");
    }

    private boolean wasWhiteSpace() {
        switch (this.last) {
            case -96: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
            case -31: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -102 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
            case -30: {
                if (this.currentIndex + 1 < this.length) {
                    byte by = this.buffer[this.currentIndex];
                    byte by2 = this.buffer[this.currentIndex + 1];
                    if (by == -127 && by2 == -97) {
                        this.currentIndex += 2;
                        this.last = (byte)32;
                        return true;
                    }
                    if (by != -128) {
                        return false;
                    }
                    switch (by2) {
                        case -128: 
                        case -127: 
                        case -126: 
                        case -125: 
                        case -124: 
                        case -123: 
                        case -122: 
                        case -121: 
                        case -120: 
                        case -119: 
                        case -118: 
                        case -88: 
                        case -87: 
                        case -81: {
                            this.currentIndex += 2;
                            this.last = (byte)32;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case -29: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -128 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public final byte getNextToken() throws IOException {
        this.read();
        if (Whitespace[this.last + 128]) {
            while (this.wasWhiteSpace()) {
                this.read();
            }
        }
        return this.last;
    }

    public final int positionInStream() {
        return this.currentIndex;
    }

    public final int fillName() throws IOException {
        byte by;
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.tokenStart = this.currentIndex;
        int n = this.currentIndex;
        long l = -2128831035L;
        while (n < this.buffer.length && (by = this.buffer[n++]) != 34) {
            l ^= (long)by;
            l *= 16777619L;
        }
        this.currentIndex = n;
        if (!(this.read() == 58 || this.wasWhiteSpace() && this.getNextToken() == 58)) {
            throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return (int)l;
    }

    public final int calcHash() throws IOException {
        byte by;
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.tokenStart = this.currentIndex;
        int n = this.currentIndex;
        long l = -2128831035L;
        while (n < this.buffer.length && (by = this.buffer[n++]) != 34) {
            l ^= (long)by;
            l *= 16777619L;
        }
        this.currentIndex = n;
        return (int)l;
    }

    public final boolean wasLastName(String string) {
        if (string.length() != this.currentIndex - this.tokenStart) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == this.buffer[this.tokenStart + i]) continue;
            return false;
        }
        return true;
    }

    public final String getLastName() throws IOException {
        return new String(this.buffer, this.tokenStart, this.currentIndex - this.tokenStart - 1, "ISO-8859-1");
    }

    private byte skipString() throws IOException {
        byte by;
        byte by2 = by = this.read();
        while (by != 34 || by2 == 92) {
            by2 = by;
            by = this.read();
        }
        return this.getNextToken();
    }

    public final byte skip() throws IOException {
        if (this.last == 34) {
            return this.skipString();
        }
        if (this.last == 123) {
            byte by = this.getNextToken();
            if (by == 125) {
                return this.getNextToken();
            }
            if (by != 34) {
                throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)by);
            }
            by = this.skipString();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)by);
            }
            this.getNextToken();
            by = this.skip();
            while (by == 44) {
                by = this.getNextToken();
                if (by != 34) {
                    throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)by);
                }
                by = this.skipString();
                if (by != 58) {
                    throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)by);
                }
                this.getNextToken();
                by = this.skip();
            }
            if (by != 125) {
                throw new IOException("Expecting '}' at position " + this.positionInStream() + ". Found " + (char)by);
            }
            return this.getNextToken();
        }
        if (this.last == 91) {
            this.getNextToken();
            byte by = this.skip();
            while (by == 44) {
                this.getNextToken();
                by = this.skip();
            }
            if (by != 93) {
                throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)by);
            }
            return this.getNextToken();
        }
        while (this.last != 44 && this.last != 125 && this.last != 93) {
            this.read();
        }
        return this.last;
    }

    public final String readNext() throws IOException {
        int n = this.currentIndex - 1;
        this.skip();
        return new String(this.buffer, n, this.currentIndex - n - 1, "UTF-8");
    }

    public final byte[] readBase64() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + " at base64 start. Found " + (char)this.last);
        }
        int n = this.currentIndex;
        this.currentIndex = Base64.findEnd(this.buffer, n);
        this.last = this.buffer[this.currentIndex++];
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + " at base64 end. Found " + (char)this.last);
        }
        return Base64.decodeFast(this.buffer, n, this.currentIndex - 1);
    }

    public final boolean wasNull() throws IOException {
        if (this.last == 110) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 117 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 108) {
                this.currentIndex += 3;
                this.last = (byte)108;
                return true;
            }
            throw new IOException("Invalid null value found at: " + this.currentIndex);
        }
        return false;
    }

    public final boolean wasTrue() throws IOException {
        if (this.last == 116) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 114 && this.buffer[this.currentIndex + 1] == 117 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 3;
                this.last = (byte)101;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.currentIndex);
        }
        return false;
    }

    public final boolean wasFalse() throws IOException {
        if (this.last == 102) {
            if (this.currentIndex + 3 < this.length && this.buffer[this.currentIndex] == 97 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 115 && this.buffer[this.currentIndex + 3] == 101) {
                this.currentIndex += 4;
                this.last = (byte)101;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.currentIndex);
        }
        return false;
    }

    public final void checkArrayEnd() throws IOException {
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw new IOException("Unexpected end of JSON in collection.");
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
    }

    public final <T, S extends T> ArrayList<T> deserializeCollection(ReadObject<S> readObject) throws IOException {
        ArrayList arrayList = new ArrayList(4);
        this.deserializeCollection(readObject, arrayList);
        return arrayList;
    }

    public final <T, S extends T> void deserializeCollection(ReadObject<S> readObject, Collection<T> collection) throws IOException {
        collection.add(readObject.read(this));
        while (this.getNextToken() == 44) {
            this.getNextToken();
            collection.add(readObject.read(this));
        }
        this.checkArrayEnd();
    }

    public final <T, S extends T> ArrayList<T> deserializeNullableCollection(ReadObject<S> readObject) throws IOException {
        ArrayList arrayList = new ArrayList(4);
        this.deserializeNullableCollection(readObject, arrayList);
        return arrayList;
    }

    public final <T, S extends T> void deserializeNullableCollection(ReadObject<S> readObject, Collection<T> collection) throws IOException {
        if (this.wasNull()) {
            collection.add(null);
        } else {
            collection.add(readObject.read(this));
        }
        while (this.getNextToken() == 44) {
            this.getNextToken();
            if (this.wasNull()) {
                collection.add(null);
                continue;
            }
            collection.add(readObject.read(this));
        }
        this.checkArrayEnd();
    }

    public final <T extends JsonObject> ArrayList<T> deserializeCollection(ReadJsonObject<T> readJsonObject) throws IOException {
        ArrayList arrayList = new ArrayList(4);
        this.deserializeCollection(readJsonObject, arrayList);
        return arrayList;
    }

    public final <T extends JsonObject> void deserializeCollection(ReadJsonObject<T> readJsonObject, Collection<T> collection) throws IOException {
        if (this.last == 123) {
            this.getNextToken();
            collection.add(readJsonObject.deserialize(this, this.locator));
        } else {
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        while (this.getNextToken() == 44) {
            if (this.getNextToken() == 123) {
                this.getNextToken();
                collection.add(readJsonObject.deserialize(this, this.locator));
                continue;
            }
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.checkArrayEnd();
    }

    public final <T extends JsonObject> ArrayList<T> deserializeNullableCollection(ReadJsonObject<T> readJsonObject) throws IOException {
        ArrayList arrayList = new ArrayList(4);
        this.deserializeNullableCollection(readJsonObject, arrayList);
        return arrayList;
    }

    public final <T extends JsonObject> void deserializeNullableCollection(ReadJsonObject<T> readJsonObject, Collection<T> collection) throws IOException {
        if (this.last == 123) {
            this.getNextToken();
            collection.add(readJsonObject.deserialize(this, this.locator));
        } else if (this.wasNull()) {
            collection.add(null);
        } else {
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        while (this.getNextToken() == 44) {
            if (this.getNextToken() == 123) {
                this.getNextToken();
                collection.add(readJsonObject.deserialize(this, this.locator));
                continue;
            }
            if (this.wasNull()) {
                collection.add(null);
                continue;
            }
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.checkArrayEnd();
    }

    static {
        JsonReader.Whitespace[137] = true;
        JsonReader.Whitespace[138] = true;
        JsonReader.Whitespace[139] = true;
        JsonReader.Whitespace[140] = true;
        JsonReader.Whitespace[141] = true;
        JsonReader.Whitespace[160] = true;
        JsonReader.Whitespace[32] = true;
        JsonReader.Whitespace[97] = true;
        JsonReader.Whitespace[98] = true;
        JsonReader.Whitespace[99] = true;
        UTF_8 = Charset.forName("UTF-8");
    }

    public static interface ReadJsonObject<T extends JsonObject> {
        public T deserialize(JsonReader var1, ServiceLocator var2) throws IOException;
    }

    static interface ReadObject<T> {
        public T read(JsonReader var1) throws IOException;
    }
}

