/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.ObjectConverter;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlConverter {
    static final JsonReader.ReadObject<Element> Reader = new JsonReader.ReadObject<Element>(){

        @Override
        public Element read(JsonReader jsonReader) throws IOException {
            return XmlConverter.deserialize(jsonReader);
        }
    };
    static final JsonWriter.WriteObject<Element> Writer = new JsonWriter.WriteObject<Element>(){

        @Override
        public void write(JsonWriter jsonWriter, Element element) {
            XmlConverter.serializeNullable(element, jsonWriter);
        }
    };
    private static DocumentBuilder documentBuilder;
    private static final String TEXT_NODE_TAG = "#text";
    private static final String COMMENT_NODE_TAG = "#comment";
    private static final String CDATA_NODE_TAG = "#cdata-section";

    public static void serializeNullable(Element element, JsonWriter jsonWriter) {
        if (element == null) {
            jsonWriter.writeNull();
        } else {
            XmlConverter.serialize(element, jsonWriter);
        }
    }

    public static void serialize(Element element, JsonWriter jsonWriter) {
        Document document = element.getOwnerDocument();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lSOutput.setCharacterStream(stringWriter);
        lSSerializer.write(document, lSOutput);
        StringConverter.serialize(stringWriter.toString(), jsonWriter);
    }

    public static Element deserialize(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 34) {
            try {
                InputSource inputSource = new InputSource(new StringReader(jsonReader.readString()));
                return documentBuilder.parse(inputSource).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException);
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = ObjectConverter.deserializeMap(jsonReader);
        return XmlConverter.mapToXml(linkedHashMap);
    }

    public static Element mapToXml(Map<String, Object> map) throws IOException {
        Set<String> set = map.keySet();
        if (set.size() > 1) {
            throw new IOException("Invalid XML. Expecting root element");
        }
        String string = set.iterator().next();
        Document document = XmlConverter.createDocument();
        Element element = document.createElement(string);
        document.appendChild(element);
        XmlConverter.buildXmlFromHashMap(document, element, map.get(string));
        return element;
    }

    private static synchronized Document createDocument() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
    }

    private static void buildXmlFromHashMap(Document document, Element element, Object object) {
        if (object instanceof HashMap) {
            HashMap hashMap = (HashMap)object;
            for (Map.Entry entry : hashMap.entrySet()) {
                Node node;
                String string = (String)entry.getKey();
                if (string.startsWith("@")) {
                    element.setAttribute(string.substring(1), entry.getValue().toString());
                    continue;
                }
                if (string.startsWith("#")) {
                    if (string.equals(TEXT_NODE_TAG)) {
                        if (entry.getValue() instanceof List) {
                            XmlConverter.buildTextNodeList(document, element, (List)entry.getValue());
                            continue;
                        }
                        node = document.createTextNode(entry.getValue().toString());
                        element.appendChild(node);
                        continue;
                    }
                    if (string.equals(CDATA_NODE_TAG)) {
                        if (entry.getValue() instanceof List) {
                            XmlConverter.buildCDataList(document, element, (List)entry.getValue());
                            continue;
                        }
                        node = document.createCDATASection(entry.getValue().toString());
                        element.appendChild(node);
                        continue;
                    }
                    if (!string.equals(COMMENT_NODE_TAG)) continue;
                    if (entry.getValue() instanceof List) {
                        XmlConverter.buildCommentList(document, element, (List)entry.getValue());
                        continue;
                    }
                    node = document.createComment(entry.getValue().toString());
                    element.appendChild(node);
                    continue;
                }
                node = document.createElement(string);
                element.appendChild(node);
                XmlConverter.buildXmlFromHashMap(document, node, entry.getValue());
            }
        } else if (object instanceof List) {
            XmlConverter.buildXmlFromJsonArray(document, element, (List)object);
        } else if (object != null) {
            element.setTextContent(object.toString());
        }
    }

    private static void buildTextNodeList(Document document, Node node, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
        }
        node.appendChild(document.createTextNode(stringBuilder.toString()));
    }

    private static void buildCDataList(Document document, Node node, List<String> list) {
        for (String string : list) {
            node.appendChild(document.createCDATASection(string));
        }
    }

    private static void buildCommentList(Document document, Node node, List<String> list) {
        for (String string : list) {
            node.appendChild(document.createComment(string));
        }
    }

    private static void buildXmlFromJsonArray(Document document, Node node, List<Object> list) {
        Node node2 = node.getParentNode();
        XmlConverter.buildXmlFromHashMap(document, (Element)node, list.get(0));
        for (Object object : list.subList(1, list.size())) {
            Element element = document.createElement(node.getNodeName());
            node2.appendChild(element);
            XmlConverter.buildXmlFromHashMap(document, element, object);
        }
    }

    public static ArrayList<Element> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Element> collection) throws IOException {
        jsonReader.deserializeCollection(Reader, collection);
    }

    public static ArrayList<Element> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Element> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Reader, collection);
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }
}

