/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.JacksonJsonSerialization;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JodaTimeConverter;
import com.dslplatform.json.JsonObject;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.StorageConverter;
import com.dslplatform.json.StringConverter;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.Bytes;
import com.dslplatform.patterns.History;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.patterns.Snapshot;
import com.dslplatform.storage.S3;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public class DslJsonSerialization
extends DslJson<ServiceLocator>
implements JsonSerialization {
    private Object jackson;
    private static final Bytes NULL = new Bytes(new byte[]{110, 117, 108, 108}, 4);

    public DslJsonSerialization(ServiceLocator serviceLocator) {
        super((Object)serviceLocator, Utils.IS_ANDROID, !Utils.IS_ANDROID, true, (DslJson.Fallback)new DslFallback(), Collections.emptyList());
        ((DslFallback)this.fallback).bind(this);
        this.registerReader(S3.class, StorageConverter.S3Reader);
        this.registerWriter(S3.class, StorageConverter.S3Writer);
    }

    private static <TResult> TResult deserializeJackson(DslJsonSerialization dslJsonSerialization, Type type, byte[] byArray, int n) throws IOException {
        if (dslJsonSerialization.jackson == null) {
            dslJsonSerialization.jackson = new JacksonJsonSerialization((ServiceLocator)dslJsonSerialization.context);
        }
        return (TResult)((JacksonJsonSerialization)dslJsonSerialization.jackson).deserialize(type, byArray, n);
    }

    private static Bytes serializeJackson(DslJsonSerialization dslJsonSerialization, Object object) throws IOException {
        if (dslJsonSerialization.jackson == null) {
            dslJsonSerialization.jackson = new JacksonJsonSerialization((ServiceLocator)dslJsonSerialization.context);
        }
        return ((JacksonJsonSerialization)dslJsonSerialization.jackson).serialize(object);
    }

    public <TResult extends AggregateRoot> List<History<TResult>> deserializeHistoryList(Class<TResult> clazz, byte[] byArray, int n) throws IOException {
        if (DslJsonSerialization.isNull((int)n, (byte[])byArray)) {
            return null;
        }
        if (n == 2 && byArray[0] == 91 && byArray[1] == 93) {
            return new ArrayList<History<TResult>>(0);
        }
        JsonReader jsonReader = new JsonReader(byArray, n, this.context);
        if (jsonReader.getNextToken() != 91) {
            throw new IOException("Expecting '[' as array start. Found: " + (char)jsonReader.last());
        }
        if (jsonReader.getNextToken() == 93) {
            return new ArrayList<History<TResult>>(0);
        }
        JsonReader.ReadJsonObject readJsonObject = this.getObjectReader(clazz);
        if (readJsonObject == null) {
            throw new IOException("Unable to find reader for provided history type: " + clazz);
        }
        ArrayList<History<TResult>> arrayList = new ArrayList<History<TResult>>();
        block4: while (true) {
            if (jsonReader.last() != 123) {
                throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
            }
            ArrayList<Snapshot<Object>> arrayList2 = null;
            jsonReader.getNextToken();
            String string = jsonReader.readString();
            if (jsonReader.getNextToken() != 58) {
                throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
            }
            if ("Snapshots".equalsIgnoreCase(string)) {
                arrayList2 = DslJsonSerialization.readSnaphosts(clazz, (JsonReader.ReadJsonObject<JsonObject>)readJsonObject, jsonReader, (ServiceLocator)this.context);
            } else {
                jsonReader.skip();
            }
            while (jsonReader.getNextToken() == 44) {
                string = jsonReader.readString();
                if (jsonReader.getNextToken() != 58) {
                    throw new IOException("Expecting ':' at" + jsonReader.getCurrentIndex());
                }
                if ("Snapshots".equalsIgnoreCase(string)) {
                    arrayList2 = DslJsonSerialization.readSnaphosts(clazz, (JsonReader.ReadJsonObject<JsonObject>)readJsonObject, jsonReader, (ServiceLocator)this.context);
                    continue;
                }
                jsonReader.skip();
            }
            if (jsonReader.last() != 125) {
                throw new IOException("Expecting '}' at " + jsonReader.getCurrentIndex());
            }
            if (arrayList2 == null) {
                throw new IOException("Snapshots not provided. It can't be null. Error at " + jsonReader.getCurrentIndex());
            }
            arrayList.add(new History(arrayList2));
            switch (jsonReader.getNextToken()) {
                case 93: {
                    return arrayList;
                }
                case 44: {
                    jsonReader.getNextToken();
                    continue block4;
                }
            }
            break;
        }
        throw new IOException("Expecting ']' or ',' at " + jsonReader.getCurrentIndex());
    }

    private static <TResult extends AggregateRoot> ArrayList<Snapshot<TResult>> readSnaphosts(Class<TResult> clazz, JsonReader.ReadJsonObject<JsonObject> readJsonObject, JsonReader jsonReader, ServiceLocator serviceLocator) throws IOException {
        if (jsonReader.getNextToken() != 91) {
            throw new IOException("Expecting '[' at " + jsonReader.getCurrentIndex());
        }
        if (jsonReader.getNextToken() == 93) {
            return new ArrayList<Snapshot<TResult>>(0);
        }
        ArrayList<Snapshot<TResult>> arrayList = new ArrayList<Snapshot<TResult>>();
        block4: while (true) {
            if (jsonReader.last() != 123) {
                throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
            }
            DateTime dateTime = Utils.MIN_DATE_TIME;
            String string = null;
            AggregateRoot aggregateRoot = null;
            jsonReader.getNextToken();
            String string2 = jsonReader.readString();
            if (jsonReader.getNextToken() != 58) {
                throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
            }
            jsonReader.getNextToken();
            if ("at".equalsIgnoreCase(string2)) {
                dateTime = JodaTimeConverter.deserializeDateTime((JsonReader)jsonReader);
            } else if ("action".equalsIgnoreCase(string2)) {
                string = StringConverter.deserialize((JsonReader)jsonReader);
            } else if ("value".equalsIgnoreCase(string2)) {
                if (jsonReader.last() != 123) {
                    throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
                }
                jsonReader.getNextToken();
                aggregateRoot = (AggregateRoot)readJsonObject.deserialize(jsonReader);
            } else {
                jsonReader.skip();
            }
            while (jsonReader.getNextToken() == 44) {
                jsonReader.getNextToken();
                string2 = jsonReader.readString();
                if (jsonReader.getNextToken() != 58) {
                    throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
                }
                jsonReader.getNextToken();
                if ("at".equalsIgnoreCase(string2)) {
                    dateTime = JodaTimeConverter.deserializeDateTime((JsonReader)jsonReader);
                    continue;
                }
                if ("action".equalsIgnoreCase(string2)) {
                    string = StringConverter.deserialize((JsonReader)jsonReader);
                    continue;
                }
                if ("value".equalsIgnoreCase(string2)) {
                    if (jsonReader.last() != 123) {
                        throw new IOException("Expecting '{' at " + jsonReader.getCurrentIndex());
                    }
                    jsonReader.getNextToken();
                    aggregateRoot = (AggregateRoot)readJsonObject.deserialize(jsonReader);
                    continue;
                }
                jsonReader.skip();
            }
            if (jsonReader.last() != 125) {
                throw new IOException("Expecting '}' at " + jsonReader.getCurrentIndex());
            }
            if (string == null) {
                throw new IOException("Action not provided. It can't be null. Error at " + jsonReader.getCurrentIndex());
            }
            if (aggregateRoot == null) {
                throw new IOException("Value not provided. It can't be null. Error at " + jsonReader.getCurrentIndex());
            }
            arrayList.add(new Snapshot<AggregateRoot>(dateTime, string, aggregateRoot));
            switch (jsonReader.getNextToken()) {
                case 93: {
                    return arrayList;
                }
                case 44: {
                    jsonReader.getNextToken();
                    continue block4;
                }
            }
            break;
        }
        throw new IOException("Expecting ']' or ',' at " + jsonReader.getCurrentIndex());
    }

    @Override
    public final Bytes serialize(Object object) throws IOException {
        if (object == null) {
            return NULL;
        }
        JsonWriter jsonWriter = new JsonWriter();
        Class<?> clazz = object.getClass();
        if (!this.serialize(jsonWriter, clazz, object)) {
            if (Utils.HAS_JACKSON) {
                return DslJsonSerialization.serializeJackson(this, object);
            }
            throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + clazz);
        }
        return new Bytes(jsonWriter.getByteBuffer(), jsonWriter.size());
    }

    @Override
    public final void serialize(Writer writer, Object object) throws IOException {
        if (writer instanceof JsonWriter) {
            this.serialize((JsonWriter)writer, object);
        } else {
            JsonWriter jsonWriter = new JsonWriter();
            this.serialize(jsonWriter, object);
            writer.write(jsonWriter.toString());
        }
    }

    static class DslFallback
    implements DslJson.Fallback<ServiceLocator> {
        private DslJsonSerialization dslJson;

        DslFallback() {
        }

        public void bind(DslJsonSerialization dslJsonSerialization) {
            this.dslJson = dslJsonSerialization;
        }

        public void serialize(Object object, OutputStream outputStream) throws IOException {
            Bytes bytes = DslJsonSerialization.serializeJackson(this.dslJson, object);
            bytes.copyTo(outputStream);
        }

        public Object deserialize(ServiceLocator serviceLocator, Type type, byte[] byArray, int n) throws IOException {
            return DslJsonSerialization.deserializeJackson(this.dslJson, type, byArray, n);
        }
    }
}

