/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;

public abstract class Guards {
    private static final Comparator<BigDecimal> bigDecimalComparator = new Comparator<BigDecimal>(){

        @Override
        public int compare(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal == null && bigDecimal2 == null ? 0 : (bigDecimal == null ? -1 : (bigDecimal2 == null ? 1 : bigDecimal.compareTo(bigDecimal2)));
        }
    };

    public static <T> void checkNulls(Iterable<T> iterable) {
        if (iterable == null) {
            return;
        }
        int n = 0;
        for (T t : iterable) {
            if (t == null) {
                throw new IllegalArgumentException("Element at index " + n + " was a null value, which is not permitted.");
            }
            ++n;
        }
    }

    public static <T> void checkNulls(T[] TArray) {
        if (TArray == null) {
            return;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] != null) continue;
            throw new IllegalArgumentException("Element at index " + i + " was a null value, which is not permitted.");
        }
    }

    public static <T> void checkNulls(List<T> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null) continue;
            throw new IllegalArgumentException("Element at index " + i + " was a null value, which is not permitted.");
        }
    }

    public static <T> void checkNulls(LinkedList<T> linkedList) {
        if (linkedList == null) {
            return;
        }
        int n = 0;
        for (Object e : linkedList) {
            if (e == null) {
                throw new IllegalArgumentException("Element at index " + n + " was a null value, which is not permitted.");
            }
            ++n;
        }
    }

    public static void checkScale(BigDecimal bigDecimal, int n) {
        if (bigDecimal == null) {
            return;
        }
        try {
            bigDecimal.setScale(n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Decimal places allowed: " + n + ". Value: " + bigDecimal, arithmeticException);
        }
    }

    public static void checkScale(BigDecimal[] bigDecimalArray, int n) {
        if (bigDecimalArray == null) {
            return;
        }
        for (int i = 0; i < bigDecimalArray.length; ++i) {
            BigDecimal bigDecimal = bigDecimalArray[i];
            if (bigDecimal == null) continue;
            try {
                bigDecimal.setScale(n);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Decimal places allowed: " + n + ". Value: " + bigDecimal, arithmeticException);
            }
        }
    }

    public static void checkScale(List<BigDecimal> list, int n) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            BigDecimal bigDecimal = list.get(i);
            if (bigDecimal == null) continue;
            try {
                bigDecimal.setScale(n);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Decimal places allowed: " + n + ". Value: " + bigDecimal, arithmeticException);
            }
        }
    }

    public static void checkScale(LinkedList<BigDecimal> linkedList, int n) {
        if (linkedList == null) {
            return;
        }
        int n2 = 0;
        for (BigDecimal bigDecimal : linkedList) {
            try {
                if (bigDecimal != null) {
                    bigDecimal.setScale(n);
                }
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Invalid value for element at index " + n2 + ". Decimal places allowed: " + n + ". Value: " + bigDecimal, arithmeticException);
            }
            ++n2;
        }
    }

    public static void checkScale(Iterable<BigDecimal> iterable, int n) {
        if (iterable == null) {
            return;
        }
        int n2 = 0;
        for (BigDecimal bigDecimal : iterable) {
            try {
                if (bigDecimal != null) {
                    bigDecimal.setScale(n);
                }
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Invalid value for element at index " + n2 + ". Decimal places allowed: " + n + ". Value: " + bigDecimal, arithmeticException);
            }
            ++n2;
        }
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) {
        return bigDecimal.setScale(n, 4);
    }

    public static Set<BigDecimal> setScale(Set<BigDecimal> set, int n) {
        if (set == null) {
            return null;
        }
        HashSet<BigDecimal> hashSet = new HashSet<BigDecimal>(set.size());
        for (BigDecimal bigDecimal : set) {
            hashSet.add(bigDecimal != null ? Guards.setScale(bigDecimal, n) : null);
        }
        return hashSet;
    }

    public static BigDecimal[] setScale(BigDecimal[] bigDecimalArray, int n) {
        if (bigDecimalArray == null) {
            return null;
        }
        BigDecimal[] bigDecimalArray2 = new BigDecimal[bigDecimalArray.length];
        for (int i = 0; i < bigDecimalArray.length; ++i) {
            BigDecimal bigDecimal = bigDecimalArray[i];
            bigDecimalArray2[i] = bigDecimal != null ? Guards.setScale(bigDecimal, n) : null;
        }
        return bigDecimalArray2;
    }

    public static List<BigDecimal> setScale(List<BigDecimal> list, int n) {
        if (list == null) {
            return null;
        }
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            BigDecimal bigDecimal = list.get(i);
            arrayList.add(bigDecimal != null ? Guards.setScale(bigDecimal, n) : null);
        }
        return arrayList;
    }

    public static Stack<BigDecimal> setScale(Stack<BigDecimal> stack, int n) {
        if (stack == null) {
            return null;
        }
        Stack<BigDecimal> stack2 = new Stack<BigDecimal>();
        for (int i = 0; i < stack.size(); ++i) {
            BigDecimal bigDecimal = (BigDecimal)stack.get(i);
            stack2.add(bigDecimal != null ? Guards.setScale(bigDecimal, n) : null);
        }
        return stack2;
    }

    public static Vector<BigDecimal> setScale(Vector<BigDecimal> vector, int n) {
        if (vector == null) {
            return null;
        }
        Vector<BigDecimal> vector2 = new Vector<BigDecimal>();
        for (int i = 0; i < vector.size(); ++i) {
            BigDecimal bigDecimal = vector.get(i);
            vector2.add(bigDecimal != null ? Guards.setScale(bigDecimal, n) : null);
        }
        return vector2;
    }

    public static Queue<BigDecimal> setScale(Queue<BigDecimal> queue, int n) {
        if (queue == null) {
            return null;
        }
        ArrayDeque<BigDecimal> arrayDeque = new ArrayDeque<BigDecimal>();
        for (BigDecimal bigDecimal : queue) {
            if (bigDecimal == null) {
                throw new NullPointerException("Default Queue implementation (java.util.ArrayDeque) does not support null elements!");
            }
            arrayDeque.add(Guards.setScale(bigDecimal, n));
        }
        return arrayDeque;
    }

    public static LinkedList<BigDecimal> setScale(LinkedList<BigDecimal> linkedList, int n) {
        if (linkedList == null) {
            return null;
        }
        LinkedList<BigDecimal> linkedList2 = new LinkedList<BigDecimal>();
        for (BigDecimal bigDecimal : linkedList) {
            linkedList2.add(bigDecimal != null ? Guards.setScale(bigDecimal, n) : null);
        }
        return linkedList2;
    }

    public static void checkLength(String string, int n) {
        if (string != null && string.length() > n) {
            throw new IllegalArgumentException("Maximum length allowed: " + n + ". Value: " + string);
        }
    }

    public static void checkLength(Iterable<String> iterable, int n) {
        if (iterable == null) {
            return;
        }
        int n2 = 0;
        for (String string : iterable) {
            if (string != null && string.length() > n) {
                throw new IllegalArgumentException("Invalid value for element at index " + n2 + ". Maximum length allowed: " + n + ". Value: " + string);
            }
            ++n2;
        }
    }

    public static void checkLength(String[] stringArray, int n) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || string.length() <= n) continue;
            throw new IllegalArgumentException("Invalid value for element at index " + i + ". Maximum length allowed: " + n + ". Value: " + string);
        }
    }

    public static void checkLength(List<String> list, int n) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string == null || string.length() <= n) continue;
            throw new IllegalArgumentException("Invalid value for element at index " + i + ". Maximum length allowed: " + n + ". Value: " + string);
        }
    }

    public static void checkLength(LinkedList<String> linkedList, int n) {
        if (linkedList == null) {
            return;
        }
        int n2 = 0;
        for (String string : linkedList) {
            if (string != null && string.length() > n) {
                throw new IllegalArgumentException("Invalid value for element at index " + n2 + ". Maximum length allowed: " + n + ". Value: " + string);
            }
            ++n2;
        }
    }

    public static boolean compareBigDecimal(Iterable<BigDecimal> iterable, Iterable<BigDecimal> iterable2) {
        if (iterable == null && iterable2 == null) {
            return true;
        }
        if (iterable == null || iterable2 == null) {
            return false;
        }
        Iterator<BigDecimal> iterator = iterable.iterator();
        Iterator<BigDecimal> iterator2 = iterable2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = iterator.next();
            if (bigDecimal2 == (bigDecimal = iterator2.next()) || bigDecimal2 != null && bigDecimal != null && bigDecimal2.compareTo(bigDecimal) == 0) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    public static boolean compareBigDecimal(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        if (bigDecimalArray == null && bigDecimalArray2 == null) {
            return true;
        }
        if (bigDecimalArray == null || bigDecimalArray2 == null) {
            return false;
        }
        if (bigDecimalArray.length != bigDecimalArray2.length) {
            return false;
        }
        for (int i = 0; i < bigDecimalArray.length; ++i) {
            BigDecimal bigDecimal = bigDecimalArray[i];
            BigDecimal bigDecimal2 = bigDecimalArray2[i];
            if (bigDecimal == bigDecimal2 || bigDecimal != null && bigDecimal2 != null && bigDecimal.compareTo(bigDecimal2) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBigDecimal(Set<BigDecimal> set, Set<BigDecimal> set2) {
        if (set == null && set2 == null) {
            return true;
        }
        if (set == null || set2 == null) {
            return false;
        }
        if (set.size() != set2.size()) {
            return false;
        }
        BigDecimal[] bigDecimalArray = set.toArray(new BigDecimal[set.size()]);
        Arrays.sort(bigDecimalArray, bigDecimalComparator);
        BigDecimal[] bigDecimalArray2 = set2.toArray(new BigDecimal[set2.size()]);
        Arrays.sort(bigDecimalArray2, bigDecimalComparator);
        return Guards.compareBigDecimal(bigDecimalArray, bigDecimalArray2);
    }

    public static boolean compareBinary(Iterable<byte[]> iterable, Iterable<byte[]> iterable2) {
        if (iterable == null && iterable2 == null) {
            return true;
        }
        if (iterable == null || iterable2 == null) {
            return false;
        }
        Iterator<byte[]> iterator = iterable.iterator();
        Iterator<byte[]> iterator2 = iterable2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            byte[] byArray;
            byte[] byArray2 = iterator.next();
            if (Arrays.equals(byArray2, byArray = iterator2.next())) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    public static boolean compareBinary(byte[][] byArray, byte[][] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (Arrays.equals(byArray[i], byArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBinary(Set<byte[]> set, Set<byte[]> set2) {
        if (set == null && set2 == null) {
            return true;
        }
        if (set == null || set2 == null) {
            return false;
        }
        if (set.size() != set2.size()) {
            return false;
        }
        block0: for (byte[] byArray : set) {
            for (byte[] byArray2 : set2) {
                if (!Arrays.equals(byArray, byArray2)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static <T> boolean compareQueue(Queue<T> queue, Queue<T> queue2) {
        if (queue == null && queue2 == null) {
            return true;
        }
        if (queue == null || queue2 == null) {
            return false;
        }
        Iterator iterator = queue.iterator();
        Iterator iterator2 = queue2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            if (e2 == (e = iterator2.next()) || e2 != null && e != null && e2.equals(e)) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    public static boolean compareXml(Iterable<Element> iterable, Iterable<Element> iterable2) {
        if (iterable == null && iterable2 == null) {
            return true;
        }
        if (iterable == null || iterable2 == null) {
            return false;
        }
        Iterator<Element> iterator = iterable.iterator();
        Iterator<Element> iterator2 = iterable2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Element element;
            Element element2 = iterator.next();
            if (element2 == (element = iterator2.next()) || element2 != null && element != null && element2.isEqualNode(element)) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    public static boolean compareXml(Element[] elementArray, Element[] elementArray2) {
        if (elementArray == null && elementArray2 == null) {
            return true;
        }
        if (elementArray == null || elementArray2 == null) {
            return false;
        }
        if (elementArray.length != elementArray2.length) {
            return false;
        }
        for (int i = 0; i < elementArray.length; ++i) {
            Element element = elementArray[i];
            Element element2 = elementArray2[i];
            if (element == element2 || element != null && element2 != null && element.isEqualNode(element2)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareXml(Set<Element> set, Set<Element> set2) {
        if (set == null && set2 == null) {
            return true;
        }
        if (set == null || set2 == null) {
            return false;
        }
        if (set.size() != set2.size()) {
            return false;
        }
        block0: for (Element element : set) {
            for (Element element2 : set2) {
                if (element != element2 && (element == null || element2 == null || !element.isEqualNode(element2))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }
}

