/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.db.DbType;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.BaseVisitor;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import java.util.List;

public class GroupByVisitor
extends BaseVisitor {
    public GroupByVisitor(List<ParameterExpression> parameters, DbType dbType) {
        super(parameters, dbType);
    }

    public void visit(NewExpression newExpression) {
        BlockExpression classBody = newExpression.getClassBody();
        if (classBody == null) {
            return;
        }
        List expressions = classBody.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            this.visit((Expression)expressions.get(i));
            if (i >= expressions.size() - 1) continue;
            this.data.append(",");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) throw new IllegalExpressionException(methodCall);
            int index = this.parameters.indexOf(parameter);
            String fn = SqlUtil.fieldName(methodCall.getMethod());
            this.putField(index, fn);
            return;
        } else {
            this.methodCallVisitor(methodCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(FieldSelectExpression fieldSelect) {
        if (fieldSelect.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(fieldSelect.getField().getType())) throw new IllegalExpressionException(fieldSelect);
            int index = this.parameters.indexOf(parameter);
            String fn = SqlUtil.fieldName(fieldSelect.getField());
            this.putField(index, fn);
            return;
        } else {
            this.tryPutExprValue(fieldSelect);
        }
    }

    public void visit(ConstantExpression constant) {
        this.putValue(constant.getValue());
    }

    public void visit(ReferenceExpression reference) {
        this.putValue(reference.getValue());
    }
}

