/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.db.DbType;
import com.easy.query.api.lambda.sqlext.SqlFunctions;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.BaseVisitor;
import com.easy.query.core.lambda.visitor.Pair;
import com.easy.query.core.lambda.visitor.SqlValue;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SetVisitor
extends BaseVisitor {
    private final List<Pair> pairs = new ArrayList<Pair>();
    private Pair curPair;

    public SetVisitor(List<ParameterExpression> parameters, DbType dbType) {
        super(parameters, dbType);
    }

    public List<Pair> getPairs() {
        return this.pairs;
    }

    private void checkHasPair(Expression expression) {
        if (this.curPair == null) {
            throw new RuntimeException(expression.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            if (!this.parameters.contains(parameter)) throw new IllegalExpressionException(methodCall);
            this.curPair = new Pair();
            this.curPair.property = SqlUtil.fieldName(methodCall.getMethod());
            for (Expression arg : methodCall.getArgs()) {
                this.visit(arg);
            }
            this.pairs.add(this.curPair);
            this.cleanIndexBlock();
            return;
        } else {
            this.checkHasPair((Expression)methodCall);
            StringBuilder sqlSegment = this.curPair.sqlSegment;
            Method callMethod = methodCall.getMethod();
            Class<?> declaringClass = callMethod.getDeclaringClass();
            if (SqlFunctions.class.isAssignableFrom(declaringClass)) {
                SqlFunctions.Ext[] exts = (SqlFunctions.Ext[])callMethod.getAnnotationsByType(SqlFunctions.Ext.class);
                if (exts.length == 0) {
                    sqlSegment.append(callMethod.getName()).append("(");
                    List args = methodCall.getArgs();
                    for (int i = 0; i < args.size(); ++i) {
                        Expression arg = (Expression)args.get(i);
                        this.visit(arg);
                        if (i >= args.size() - 1) continue;
                        sqlSegment.append(",");
                    }
                    sqlSegment.append(")");
                    return;
                } else {
                    String function = this.getTargetSqlFuncExt(exts).function();
                    this.tryReplace(methodCall, function, sqlSegment);
                }
                return;
            } else {
                if (ExpressionUtil.hasParameter((Expression)methodCall)) {
                    throw new RuntimeException(methodCall.toString());
                }
                sqlSegment.append(this.indexBlock());
                this.curPair.sqlValue.add(new SqlValue(methodCall.getValue()));
            }
        }
    }

    public void visit(ConstantExpression constant) {
        this.checkHasPair((Expression)constant);
        this.curPair.sqlSegment.append(this.indexBlock());
        this.curPair.sqlValue.add(new SqlValue(constant.getValue()));
    }

    public void visit(ReferenceExpression reference) {
        this.checkHasPair((Expression)reference);
        this.curPair.sqlSegment.append(this.indexBlock());
        this.curPair.sqlValue.add(new SqlValue(reference.getValue()));
    }
}

