package com.easycodebox.common.validate;

/**
 * @author WangXiaoJin
 * 
 */
public enum Regex {
	
	/**
	 * 邮件
	 */
	EMAIL(
		"^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$",
		"邮件格式不正确"
	),
	/**
	 * url
	 */
	URL(
		"^\\b(https?|ftp):\\/\\/([-A-Za-z0-9.:]+)(\\/[-A-Za-z0-9+&@#\\/%=~_|!:,.;]*)?(\\?[A-Za-z0-9+&@#\\/%=~_|!:,.;]*)?$",
		"网址不正确"
	),
	/**
	 * image
	 */
	IMAGE(
		"\\.(jpg|bmp|gif|ico|pcx|jpeg|tif|png|raw|tga)$",
		"图片的格式不正确"
	),
	/**
	 * 字母
	 */
	ALPHA(
		"^[A-Za-z]+$",
		"{0}只能输入字母"
	),
	/**
	 * 字母、下划线和数字
	 */
	WORD(
		"^\\w+$",
		"{0}只能输入字母、下划线和数字"
	),
	/**
	 * 中文
	 */
	CHINESE(
		"^[\\u4E00-\\u9FA5\\uF900-\\uFA2D]+$",
		"{0}只能输入中文"
	),
	/**
	 * 只要出现中文
	 */
	ANY_CHINESE(
		"[\\u4E00-\\u9FA5\\uF900-\\uFA2D]",
		"{0}没有中文"
	),
	/**
	 * 中文、字母、下划线、左括号、右括号和数字
	 */
	WORD_ZH(
		"^[\\u4E00-\\u9FA5\\uF900-\\uFA2D\\w\\(\\)\\（\\）]+$",
		"{0}只能输入中文、字母、括号和数字"
	),
	/**
	 * 手机号
	 */
	MOBILE(
		"^(13[0-9]{9}|15[0-9]{9}|18[0-9]{9}|147[0-9]{8})$",	
		"请输入正确的手机号"
	),
	/**
	 * 身份证
	 */
	IDCARD(
		"(^\\d{15}$)|(^\\d{17}(\\d|X)$)",
		"请输入正确的身份证号"
	),
	/**
	 * 固话
	 */
	TEL(
		"^(([0\\+]\\d{2,3}-)?(0\\d{2,3})-)?(\\d{7,8})(-(\\d{3,}))?$",
		"请输入正确的固定电话"
	),
	/**
	 * ascii
	 */
	ASCII(
		"^[\\x00-\\xFF]+$",
		"{0}只能输入ascii码"
	),
	/**
	 * empty
	 */
	EMPTY(
		"^\\s*$",
		"{0}只能为空"
	),	
	/**
	 * not_empty
	 */
	NOT_EMPTY(
		"^\\S+$",
		"{0}不能为空"
	),
	/**
	 * ip4
	 */
	IP4(
		"^(?:(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$",
		"请输入正确的IP4地址"
	),
	/**
	 * ip6
	 */
	IP6(
		"^(?:(?:(?:[A-F\\d]{1,4}:){5}[A-F\\d]{1,4}" +
		"|(?:[A-F\\d]{1,4}:){4}:[A-F\\d]{1,4}" +
		"|(?:[A-F\\d]{1,4}:){3}(?::[A-F\\d]{1,4}){1,2}" +
		"|(?:[A-F\\d]{1,4}:){2}(?::[A-F\\d]{1,4}){1,3}" +
		"|[A-F\\d]{1,4}:(?::[A-F\\d]{1,4}){1,4}" +
		"|(?:[A-F\\d]{1,4}:){1,5}|:(?::[A-F\\d]{1,4}){1,5}|:)" +
		":(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.){3}" +
		"(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)|(?:[A-F\\d]{1,4}:){7}[A-F\\d]{1,4}" +
		"|(?:[A-F\\d]{1,4}:){6}:[A-F\\d]{1,4}|(?:[A-F\\d]{1,4}:){5}" +
		"(?::[A-F\\d]{1,4}){1,2}|(?:[A-F\\d]{1,4}:){4}" +
		"(?::[A-F\\d]{1,4}){1,3}|(?:[A-F\\d]{1,4}:){3}" +
		"(?::[A-F\\d]{1,4}){1,4}|(?:[A-F\\d]{1,4}:){2}" +
		"(?::[A-F\\d]{1,4}){1,5}|[A-F\\d]{1,4}:(?::[A-F\\d]{1,4}){1,6}" +
		"|(?:[A-F\\d]{1,4}:){1,7}:|:(?::[A-F\\d]{1,4}){1,7})$",
		"请输入正确的IP6地址"
	),
	/**
	 * 只匹配数字
	 */
	DIGIT(
		"^\\d+$",
		"{0}只能输入数字"
	),
	/**
	 * 整数（包括负数、0、正数）
	 */
	INT(
		"^[\\+-]?\\d+$",
		"{0}只能输入整数"
	),
	/**
	 * 正整数
	 */
	INT_PLUS(
		"^\\+?[0-9]*[1-9][0-9]*$",
		"{0}只能输入正整数"
	),
	/**
	 * 负整数
	 */
	INT_MINUS(
		"^-[0-9]*[1-9][0-9]*$",
		"{0}只能输入负整数"
	),
	/**
	 * 非负整数（正整数 + 0）
	 */
	INT_NO_MINUS(
		"^\\+?\\d+$",
		"{0}只能输入非负整数"
	),
	/**
	 * 非正整数（负整数 + 0）
	 */
	INT_NO_PLUS(
		"^((-\\d+)|(0))$",
		"{0}只能输入非正整数"
	),
	/**
	 * 浮点数 或 整数(包含正负数)
	 */
	NUMBER(
		"^([\\+-]?)\\d*\\.?\\d+$",
		"{0}只能输入小数或整数"
	),
	/**
	 * 正小数、正整数
	 */
	NUMBER_PLUS(
		"^\\+?((\\d*[1-9]\\d*\\.?\\d*)|(0+\\.\\d*[1-9]\\d*))$",
		"{0}只能输入正小数、正整数"
	),
	/**
	 * 负小数、负整数
	 */
	NUMBER_MINUS(
		"^-((\\d*[1-9]\\d*\\.?\\d*)|(0+\\.\\d*[1-9]\\d*))$",
		"{0}只能输入负小数、负整数"
	),
	/**
	 * 非正小数、非正整数
	 */
	NUMBER_NO_PLUS(
		"^-\\d*\\.?\\d+$",
		"{0}只能输入非正小数、非正整数"
	),
	/**
	 * 非负小数、非负整数
	 */
	NUMBER_NO_MINUS(
		"^\\+?\\d*\\.?\\d+$",
		"{0}只能输入非负小数、非负整数"
	),
	/**
	 * 只能是浮点数不能为整数(包含正负数)
	 */
	DECEMAL(
		"^([\\+-]?)\\d*\\.\\d+$",
		"{0}只能输入小数"
	),
	/**
	 * 正小数
	 */
	DECEMAL_PLUS(
		"^\\+?((\\d*[1-9]\\d*\\.\\d*)|(0+\\.\\d*[1-9]\\d*))$",
		"{0}只能输入正小数"
	),
	/**
	 * 负小数
	 */
	DECEMAL_MINUS(
		"^-((\\d*[1-9]\\d*\\.\\d*)|(0+\\.\\d*[1-9]\\d*))$",
		"{0}只能输入负小数"
	),
	/**
	 * 非正小数
	 */
	DECEMAL_NO_PLUS(
		"^-\\d*\\.\\d+$",
		"{0}只能输入非正小数"
	),
	/**
	 * 非负小数
	 */
	DECEMAL_NO_MINUS(
		"^\\+?\\d*\\.\\d+$",
		"{0}只能输入非负小数"
	);
	
	public static final String SCRIPT = "<\\s*script[^>]*>(.*?<\\s*/\\s*script[^>]*>)?";
	public static final String STYLE = "<\\s*style[^>]*>(.*?<\\s*/\\s*style[^>]*>)?";
	public static final String FRAME = "<\\s*((frameset)|(frame)|(iframe))[^>]*>(.*?<\\s*/\\s*((frameset)|(frame)|(iframe))[^>]*>)?";
	public static final String HTML = "<[^>]+>";
	
	private String regex;
	private String msg;
   
    Regex(String regex, String msg) {
        this.regex = regex;
        this.msg = msg;
    }

	public String getRegex() {
		return regex;
	}

	public String getMsg() {
		return msg;
	}

	public String getClassName() {
		return this.name();
	}
	
}
