/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.lang.dto.UserInfo;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.security.SecurityContext;
import com.easycodebox.common.security.SecurityContexts;
import com.easycodebox.common.security.SecurityUtils;
import com.easycodebox.common.validate.Assert;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;

public class ShiroSecurityInfoHandler
implements SecurityUtils.SecurityInfoHandler<Session, UserInfo> {
    public SecurityContext<UserInfo> newSecurityContext(Session storage, HttpServletRequest request, HttpServletResponse response) {
        if (storage == null) {
            storage = SecurityUtils.getSubject().getSession();
        }
        SecurityContext context = new SecurityContext();
        UserInfo user = this.getSecurityInfo(storage);
        context.setSessionId(storage.getId());
        if (user != null) {
            context.setSecurity((Serializable)user);
        }
        if (request != null) {
            context.setIp(HttpUtils.getIpAddr((HttpServletRequest)request));
            context.setUserAgent(request.getHeader("User-Agent"));
            context.setRequest(request);
        }
        if (response != null) {
            context.setResponse(response);
        }
        return context;
    }

    public UserInfo getSecurityInfo(Session storage) {
        return storage == null ? null : (UserInfo)storage.getAttribute((Object)BaseConstants.USER_KEY);
    }

    public void storeSecurityInfo(Session storage, UserInfo securityInfo) {
        Assert.notNull((Object)storage);
        storage.setAttribute((Object)BaseConstants.USER_KEY, (Object)securityInfo);
        SecurityContext sc = SecurityContexts.getCurSecurityContext();
        if (sc == null) {
            SecurityContext tmp = new SecurityContext();
            tmp.setSecurity((Serializable)securityInfo);
            tmp.setSessionId(storage.getId());
            SecurityContexts.setCurSecurityContext((SecurityContext)tmp);
        } else {
            sc.setSecurity((Serializable)securityInfo);
            sc.setSessionId(storage.getId());
        }
    }

    public void destroySecurityInfo(Session storage) {
        if (storage == null) {
            return;
        }
        storage.removeAttribute((Object)BaseConstants.USER_KEY);
        SecurityContexts.setCurSecurityContext(null);
    }
}

