/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.filter;

import com.easycodebox.common.error.ErrorContext;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

public class DefaultCasFilter
extends CasFilter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String failureUrl;
    private String reloginUrl;
    private String logoutUrl;

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        AuthenticationToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        try {
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (Exception e) {
            return this.onLoginFailure(token, e, request, response);
        }
    }

    protected boolean onLoginFailure(AuthenticationToken token, Exception exception, ServletRequest request, ServletResponse response) {
        Subject subject = this.getSubject(request, response);
        if (subject.isAuthenticated() || subject.isRemembered()) {
            subject.logout();
        }
        String url = null;
        HashMap<String, String> queryParams = null;
        if (exception instanceof ErrorContext || exception.getCause() != null && exception.getCause() instanceof ErrorContext) {
            url = this.logoutUrl;
            queryParams = new HashMap<String, String>(1);
            ErrorContext error = exception instanceof ErrorContext ? (ErrorContext)exception : (ErrorContext)exception.getCause();
            try {
                queryParams.put("service", StringUtils.format((String)this.reloginUrl, (Object[])new Object[]{URLEncoder.encode(URLEncoder.encode(error.getMessage(), "UTF-8"), "UTF-8")}));
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)"URLEncoder params error : {0}", new Object[]{error.getMessage(), e});
            }
        } else {
            url = this.failureUrl;
        }
        try {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)url, queryParams);
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot redirect to failure url : {0}", new Object[]{this.failureUrl, e});
        }
        return false;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setReloginUrl(String reloginUrl) {
        this.reloginUrl = reloginUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }
}

