/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.filter;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.web.callback.CallbackData;
import com.easycodebox.common.web.callback.Callbacks;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;

public class DefaultFormAuthenticationFilter
extends FormAuthenticationFilter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String pjaxKey;

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                this.log.trace((Object)"Login submission detected.  Attempting to execute login.");
                return this.executeLogin(request, response);
            }
            this.log.trace((Object)"Login page view.");
            return true;
        }
        this.log.trace((Object)"Attempting to access a path which requires authentication.  Forwarding to the Authentication url [{0}]", new Object[]{this.getLoginUrl()});
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (HttpUtils.isAjaxRequest((HttpServletRequest)req) && req.getHeader(this.pjaxKey == null ? BaseConstants.pjaxKey : this.pjaxKey) == null) {
            HttpUtils.outJson((Object)CodeMsg.NO_LOGIN, (HttpServletResponse)resp);
        } else if (req.getParameter(BaseConstants.DIALOG_REQ) != null) {
            Callbacks.callback((CallbackData)Callbacks.closeDialog((String)null), null, (HttpServletResponse)resp);
        } else {
            this.saveRequestAndRedirectToLogin(request, response);
        }
        return false;
    }

    public String getPjaxKey() {
        return this.pjaxKey;
    }

    public void setPjaxKey(String pjaxKey) {
        this.pjaxKey = pjaxKey;
    }
}

