/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.filter;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.web.callback.CallbackData;
import com.easycodebox.common.web.callback.Callbacks;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;

public class DefaultPermissionsAuthorizationFilter
extends PermissionsAuthorizationFilter {
    private String pathDivider = "/";

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        if (mappedValue == null) {
            String path = HttpUtils.getShortPath((HttpServletRequest)((HttpServletRequest)request));
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!"/".equals(this.pathDivider)) {
                path = path.replace("/", this.pathDivider);
            }
            if (StringUtils.isNotBlank((String)path)) {
                mappedValue = new String[]{path};
            }
        }
        return super.isAccessAllowed(request, response, (Object)mappedValue);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        block17: {
            HttpServletResponse res = (HttpServletResponse)response;
            if (HttpUtils.isAjaxRequest((HttpServletRequest)((HttpServletRequest)request))) {
                response.setContentType("application/json;charset=UTF-8");
                try (JsonGenerator jsonGenerator = Jacksons.NON_NULL.getFactory().createGenerator((Writer)response.getWriter());){
                    Jacksons.NON_NULL.writeValue(jsonGenerator, (Object)CodeMsg.FAIL.msg("\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c", new Object[0]));
                    break block17;
                }
                catch (Exception e) {
                    throw new BaseException("Could not write JSON string.", (Throwable)e, new Object[0]);
                }
            }
            if (request.getParameter(BaseConstants.DIALOG_REQ) != null) {
                Callbacks.callback((CallbackData)Callbacks.closeDialogQuiet((CodeMsg)CodeMsg.FAIL.msg("\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c", new Object[0])), null, (HttpServletResponse)res);
            } else {
                super.onAccessDenied(request, response);
            }
        }
        return false;
    }

    public String getPathDivider() {
        return this.pathDivider;
    }

    public void setPathDivider(String pathDivider) {
        this.pathDivider = pathDivider;
    }
}

