/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.filter;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;

public class SenseLoginFilter
extends FormAuthenticationFilter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String TICKET_PARAMETER = "ticket";

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.getSubject(request, response);
        return subject.isAuthenticated() || request.getParameter(TICKET_PARAMETER) == null;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                this.log.trace((Object)"Login submission detected.  Attempting to execute login.");
                return this.executeLogin(request, response);
            }
            this.log.trace((Object)"Login page view.");
            return true;
        }
        this.log.trace((Object)"Attempting to access a path which requires authentication.  Forwarding to the Authentication url [{0}]", new Object[]{this.getLoginUrl()});
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }
}

