/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.permission;

import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.login.shiro.permission.GlobalPermission;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;

public class UrlWildcardPermission
implements GlobalPermission {
    private static final long serialVersionUID = -5844939019312129337L;
    protected static final String DIVIDER_TOKEN = ",";
    protected static final String NO_PERMITTED_FLAG = ":0";
    private PatternMatcher pathMatcher;
    private String dividerToken;
    private String noPermittedFlag = ":0";
    private String[] parts;
    private boolean permitted;

    public UrlWildcardPermission(String wildcardString) {
        this(wildcardString, null);
    }

    public UrlWildcardPermission(String wildcardString, String dividerToken) {
        this(wildcardString, dividerToken, null);
    }

    public UrlWildcardPermission(String wildcardString, String dividerToken, PatternMatcher pathMatcher) {
        this.dividerToken = dividerToken == null ? DIVIDER_TOKEN : dividerToken;
        this.pathMatcher = pathMatcher == null ? new AntPathMatcher() : pathMatcher;
        this.setParts(wildcardString);
    }

    protected void setParts(String wildcardString) {
        if ((wildcardString = StringUtils.trimToNull((String)wildcardString)) == null) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
        }
        if (wildcardString.endsWith(this.noPermittedFlag)) {
            wildcardString = wildcardString.substring(0, wildcardString.length() - this.noPermittedFlag.length());
            this.permitted = false;
        } else {
            this.permitted = true;
        }
        this.parts = wildcardString.split(this.dividerToken);
        if (this.parts.length == 0) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
    }

    @Override
    public boolean isPermitted() {
        return this.permitted;
    }

    public boolean implies(Permission p) {
        String[] otherParts;
        if (!(p instanceof UrlWildcardPermission)) {
            return false;
        }
        UrlWildcardPermission wp = (UrlWildcardPermission)p;
        for (String otherPart : otherParts = wp.getParts()) {
            boolean matched = false;
            for (String part : this.getParts()) {
                if (!this.pathMatcher.matches(part, otherPart)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return StringUtils.join((Object[])this.parts, (String)this.dividerToken) + (this.isPermitted() ? "" : this.noPermittedFlag);
    }

    public boolean equals(Object o) {
        if (o instanceof UrlWildcardPermission) {
            UrlWildcardPermission wp = (UrlWildcardPermission)o;
            return new EqualsBuilder().append((Object[])this.parts, (Object[])wp.parts).append(this.isPermitted(), wp.isPermitted()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object[])this.parts).append(this.isPermitted()).hashCode();
    }

    public String[] getParts() {
        return this.parts;
    }

    public String getDividerToken() {
        return this.dividerToken;
    }

    public void setDividerToken(String dividerToken) {
        this.dividerToken = dividerToken;
    }

    public PatternMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PatternMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public String getNoPermittedFlag() {
        return this.noPermittedFlag;
    }

    public void setNoPermittedFlag(String noPermittedFlag) {
        this.noPermittedFlag = noPermittedFlag;
    }
}

