/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.realm;

import com.easycodebox.auth.model.bo.user.UserFullBo;
import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.lang.dto.UserInfo;
import com.easycodebox.login.shiro.ShiroSecurityInfoHandler;
import com.easycodebox.login.shiro.permission.GlobalPermission;
import com.easycodebox.login.ws.UserWsService;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.session.Session;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Value;

public class DefaultCasRealm
extends CasRealm
implements Serializable {
    private static final long serialVersionUID = 2888923134019023168L;
    @Resource
    private UserWsService userWsService;
    @Resource
    private ShiroSecurityInfoHandler securityInfoHandler;
    @Value(value="${project}")
    private String projectNo;
    @Value(value="${valid_project_auth:true}")
    private boolean validProjectAuth;
    private boolean globalPermissionMode;
    private TicketValidator ticketValidator;

    protected boolean isPermitted(Permission permission, AuthorizationInfo info) {
        Collection perms = this.getPermissions(info);
        boolean included = false;
        if (perms != null && !perms.isEmpty()) {
            for (Permission perm : perms) {
                if (perm instanceof GlobalPermission) {
                    GlobalPermission gp = (GlobalPermission)perm;
                    if (!perm.implies(permission)) continue;
                    if (gp.isPermitted()) {
                        return true;
                    }
                    included = true;
                    continue;
                }
                if (!perm.implies(permission)) continue;
                return true;
            }
        }
        return this.globalPermissionMode && !included;
    }

    protected TicketValidator createTicketValidator() {
        return this.ticketValidator == null ? super.createTicketValidator() : this.ticketValidator;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        try {
            SimpleAuthenticationInfo info = (SimpleAuthenticationInfo)super.doGetAuthenticationInfo(token);
            if (info == null) {
                return null;
            }
            CasToken casToken = (CasToken)token;
            Map attributes = (Map)info.getPrincipals().asList().get(1);
            UserFullBo user = this.userWsService.loginSuc((String)casToken.getPrincipal(), this.projectNo, this.validProjectAuth);
            if (user.getRoleNames() != null) {
                attributes.put(this.getRoleAttributeNames(), user.getRoleNames());
            }
            if (user.getPermissions() != null) {
                attributes.put(this.getPermissionAttributeNames(), user.getPermissions());
            }
            Session session = SecurityUtils.getSubject().getSession(false);
            UserInfo userInfo = new UserInfo(user.getId(), user.getUsername(), user.getNickname(), user.getRealname(), user.getPic(), (DetailEnum)user.getStatus(), user.getGroupId(), user.getGroupName());
            this.securityInfoHandler.storeSecurityInfo(session, userInfo);
            session.setAttribute((Object)BaseConstants.LEFT_MENU_KEY, DefaultCasRealm.treePermissions(null, user.getMenus()));
            return info;
        }
        catch (CasAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CasAuthenticationException("Authenticated error!", (Throwable)e);
        }
    }

    private static List<com.easycodebox.auth.model.entity.user.Permission> treePermissions(Long parentId, List<com.easycodebox.auth.model.entity.user.Permission> all) {
        LinkedList<com.easycodebox.auth.model.entity.user.Permission> cur = new LinkedList<com.easycodebox.auth.model.entity.user.Permission>();
        for (com.easycodebox.auth.model.entity.user.Permission o : all) {
            if (!(parentId == null ? o.getParentId() == null : parentId.equals(o.getParentId()))) continue;
            o.setChildren(DefaultCasRealm.treePermissions(o.getId(), all));
            cur.add(o);
        }
        return cur;
    }

    public boolean isGlobalPermissionMode() {
        return this.globalPermissionMode;
    }

    public void setGlobalPermissionMode(boolean globalPermissionMode) {
        this.globalPermissionMode = globalPermissionMode;
    }

    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }
}

