/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.login.shiro.realm;

import com.easycodebox.common.enums.entity.LogLevel;
import com.easycodebox.common.error.ErrorContext;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import javax.sql.DataSource;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DefaultJdbcRealm
extends JdbcRealm {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private JdbcTemplate jdbcTemplate;
    private String authFailMsg;
    private RowMapper<?> rowMapper;

    public DefaultJdbcRealm() {
        this.setAuthenticationTokenClass(CasToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        CasToken casToken = (CasToken)token;
        if (casToken == null) {
            return null;
        }
        String userId = (String)casToken.getPrincipal();
        try {
            Object user = null;
            user = this.rowMapper != null ? this.getJdbcTemplate().queryForObject(this.authenticationQuery, this.rowMapper, new Object[]{userId}) : this.getJdbcTemplate().queryForMap(this.authenticationQuery, new Object[]{userId});
            SimplePrincipalCollection principalCollection = new SimplePrincipalCollection(user, this.getName());
            return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)((String)casToken.getCredentials()));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw ErrorContext.instance((String)this.authFailMsg, (Object[])new Object[0]).logLevel(LogLevel.WARN);
            }
            String msg = "Multiple records found for user [" + userId + "]";
            this.log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
        catch (DataAccessException e) {
            String msg = "There was a SQL error while authenticating user [" + userId + "]";
            this.log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        super.setDataSource(dataSource);
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getAuthFailMsg() {
        return this.authFailMsg;
    }

    public void setAuthFailMsg(String authFailMsg) {
        this.authFailMsg = authFailMsg;
    }

    public RowMapper<?> getRowMapper() {
        return this.rowMapper;
    }

    public void setRowMapper(RowMapper<?> rowMapper) {
        this.rowMapper = rowMapper;
    }
}

