/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.share_link;

import com.fangcloud.sdk.YfyBaseClient;
import com.fangcloud.sdk.api.ShareLinkAccessEnum;
import com.fangcloud.sdk.api.SuccessResult;
import com.fangcloud.sdk.api.share_link.CreateShareLinkArg;
import com.fangcloud.sdk.api.share_link.UpdateShareLinkArg;
import com.fangcloud.sdk.api.share_link.YfyShareLink;
import com.fangcloud.sdk.exception.YfyException;
import java.util.HashMap;
import java.util.Map;

public class YfyShareLinkRequest {
    private static final String ITEM_API_PATH = "api/v2/share_link/";
    private static final String GET_SHARE_LINK_PATH = "api/v2/share_link/%s/info";
    private static final String CREATE_SHARE_LINK_PATH = "api/v2/share_link/create";
    private static final String UPDATE_SHARE_LINK_PATH = "api/v2/share_link/%s/update";
    private static final String REVOKE_SHARE_LINK_PATH = "api/v2/share_link/%s/revoke";
    private final YfyBaseClient.YfyInternalClient client;

    public YfyShareLinkRequest(YfyBaseClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyShareLink getShareLink(String uniqueName) throws YfyException {
        String[] params = new String[]{uniqueName};
        return this.getShareLink(params, null);
    }

    public YfyShareLink getShareLink(String uniqueName, final String password) throws YfyException {
        String[] params = new String[]{uniqueName};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("password", password);
            }
        };
        return this.getShareLink(params, (Map<String, String>)mapParams);
    }

    private YfyShareLink getShareLink(String[] params, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(GET_SHARE_LINK_PATH, params, mapParams, YfyShareLink.class);
    }

    public YfyShareLink createFileShareLink(long fileId, ShareLinkAccessEnum access, boolean disableDownload, String dueTime, String password) throws YfyException {
        boolean passwordProtected = false;
        if (password != null && !password.isEmpty()) {
            passwordProtected = true;
        }
        return this.createShareLink(new CreateShareLinkArg(null, fileId, access.getAccess(), disableDownload, dueTime, passwordProtected, password));
    }

    public YfyShareLink createFolderShareLink(long folderId, ShareLinkAccessEnum access, boolean disableDownload, String dueTime, String password) throws YfyException {
        boolean passwordProtected = false;
        if (password != null && !password.isEmpty()) {
            passwordProtected = true;
        }
        return this.createShareLink(new CreateShareLinkArg(folderId, null, access.getAccess(), disableDownload, dueTime, passwordProtected, password));
    }

    private YfyShareLink createShareLink(CreateShareLinkArg createShareLinkArg) throws YfyException {
        return this.client.doPost(CREATE_SHARE_LINK_PATH, null, createShareLinkArg, YfyShareLink.class);
    }

    public YfyShareLink updateShareLink(String uniqueName, ShareLinkAccessEnum access, boolean disableDownload, String dueTime, String password) throws YfyException {
        String[] params = new String[]{uniqueName};
        boolean passwordProtected = false;
        if (password != null && !password.isEmpty()) {
            passwordProtected = true;
        }
        return this.updateShareLink(params, new UpdateShareLinkArg(access.getAccess(), disableDownload, dueTime, passwordProtected, password));
    }

    private YfyShareLink updateShareLink(String[] params, UpdateShareLinkArg updateShareLinkArg) throws YfyException {
        return this.client.doPost(UPDATE_SHARE_LINK_PATH, params, updateShareLinkArg, YfyShareLink.class);
    }

    public SuccessResult revokeShareLink(String uniqueName) throws YfyException {
        String[] params = new String[]{uniqueName};
        return this.revokeShareLink(params);
    }

    private SuccessResult revokeShareLink(String[] params) throws YfyException {
        return this.client.doPost(REVOKE_SHARE_LINK_PATH, params, null, SuccessResult.class);
    }
}

