package com.flutterwave.bean;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.GsonBuilder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SettlementResponse {
    public String status;
    public String message;
    public SettlementData data;

    public static SettlementResponse toResponse(String value){
        try{
            return new GsonBuilder().create().
                    fromJson(value, SettlementResponse.class);
        }catch (Exception e){
            throw new RuntimeException("Error processing request, please contact support!");
        }
    }

    @Override
    public String toString() {

        String value = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            value = objectMapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }

        return value;

    }


    @Getter
    @Setter
    @NoArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class SettlementData {

        public int id;
        public int account_id;
        public String merchant_name;
        public String merchant_email;
        public String settlement_account;
        public String bank_code;
        public Date transaction_date;
        public Date due_date;
        public Object processed_date;
        public String status;
        public boolean is_local;
        public String currency;
        public BigDecimal gross_amount;
        public BigDecimal app_fee;
        public BigDecimal merchant_fee;
        public int chargeback;
        public int refund;
        public int stampduty_charge;
        public BigDecimal net_amount;
        public int transaction_count;
        public String processor_ref;
        public String disburse_ref;
        public Object disburse_message;
        public String channel;
        public String destination;
        public String fx_data;
        public String flag_message;
        public Object meta;
        public Object refund_meta;
        public Object chargeback_meta;
        public String source_bankcode;
        public Date created_at;
        public List<Transaction> transactions;


        @Getter
        @Setter
        @NoArgsConstructor
        @JsonInclude(JsonInclude.Include.NON_NULL)
        public static class Transaction {
            public String customer_email;
            public String flw_ref;
            public String tx_ref;
            public int id;
            public BigDecimal charged_amount;
            public BigDecimal app_fee;
            public BigDecimal merchant_fee;
            public BigDecimal stampduty_charge;
            public BigDecimal settlement_amount;
            public String status;
            public String payment_entity;
            public String transaction_date;
            public String currency;
            public String card_locale;
            public String rrn;
            public int subaccount_settlement;
        }
    }
}
