/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FieldCodec;
import com.zink.fly.FlyAccessException;
import com.zink.fly.stub.EmptyObjectFactory;
import com.zink.fly.stub.FieldFilter;
import com.zink.fly.stub.ObjectCodec;
import com.zink.fly.stub.ObjectLayout;
import com.zink.fly.stub.Remoter;
import com.zink.fly.stub.VersionLink;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TypeChain {
    private final long EMPTY_ENTRY = Integer.MAX_VALUE;
    private Remoter remoter;
    private DataInputStream dis;
    private ObjectCodec objCodec;
    private FieldFilter filter = new FieldFilter();
    private EmptyObjectFactory objectFact = new EmptyObjectFactory();
    private Map<Class, VersionLink> bridges = new HashMap<Class, VersionLink>();
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(1048);
    private DataOutputStream dos = new DataOutputStream(this.bos);

    public TypeChain(Remoter remoter, FieldCodec fieldCodec) {
        try {
            this.objCodec = new ObjectCodec(fieldCodec);
            this.remoter = remoter;
            this.dis = remoter.getDataInputStream();
        }
        catch (Exception exception) {
            throw new FlyAccessException("Could not make TypeChain", exception);
        }
    }

    public synchronized int getChannel(Object object) {
        Class<?> clazz = object.getClass();
        VersionLink versionLink = this.bridges.get(clazz);
        if (versionLink == null) {
            int n = object.getClass().getModifiers();
            if (!Modifier.isPublic(n)) {
                throw new IllegalArgumentException("Fly entries must be public :" + object.getClass());
            }
            ObjectLayout objectLayout = new ObjectLayout(object);
            versionLink = this.createBridge(objectLayout);
            this.bridges.put(clazz, versionLink);
        }
        return versionLink.getChannel();
    }

    private VersionLink createBridge(ObjectLayout objectLayout) {
        VersionLink versionLink = null;
        try {
            this.bos.reset();
            this.dos.writeInt(-88997878);
            objectLayout.write(this.dos);
            long l = this.remoter.sendOperation(this.bos.toByteArray());
            ObjectLayout objectLayout2 = new ObjectLayout(this.dis, 0);
            this.remoter.setMessageComplete();
            int n = objectLayout2.getChannel();
            objectLayout.setChannel(n);
            versionLink = new VersionLink(objectLayout, objectLayout2, n, l);
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        return versionLink;
    }

    public void writeObject(DataOutputStream dataOutputStream, Object object) {
        this.writeIDObject(dataOutputStream, object, null);
    }

    public void writeIDObject(DataOutputStream dataOutputStream, Object object, UUID uUID) {
        VersionLink versionLink = this.bridges.get(object.getClass());
        if (versionLink.getEvolutionResponse() == 0L) {
            try {
                int n = versionLink.getHostLayout().getInfos().size();
                dataOutputStream.writeInt(n);
                if (uUID != null) {
                    dataOutputStream.writeLong(uUID.getMostSignificantBits());
                    dataOutputStream.writeLong(uUID.getLeastSignificantBits());
                }
                for (Field field : ObjectLayout.getAllFields(object.getClass())) {
                    if (!this.filter.applyFilter(field)) continue;
                    field.setAccessible(Boolean.TRUE);
                    this.objCodec.writeObject(dataOutputStream, (Serializable)field.get(object));
                }
            }
            catch (Exception exception) {
                throw new FlyAccessException(exception);
            }
        } else {
            String string = "Entry layout in Fly server differs to " + object.getClass().getName();
            throw new FlyAccessException(string);
        }
    }

    public Object readObject(DataInputStream dataInputStream, long l, Class clazz) {
        Object object = null;
        try {
            object = this.objectFact.makeEmptyObject(clazz);
            long l2 = dataInputStream.readLong();
            long l3 = dataInputStream.readLong();
            if (l == Integer.MAX_VALUE) {
                return object;
            }
            int n = 0;
            for (Field field : ObjectLayout.getAllFields(object.getClass())) {
                if (!this.filter.applyFilter(field)) continue;
                Object object2 = this.objCodec.readObject(dataInputStream);
                field.setAccessible(Boolean.TRUE);
                field.set(object, object2);
                ++n;
            }
            if ((long)n != l) {
                throw new IllegalStateException("Fly Internal Type Error : filtered fields do not match");
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        return object;
    }
}

