/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.kit;

import com.zink.fly.kit.FlyPinger;
import com.zink.fly.kit.MulticastRequestListener;
import com.zink.fly.kit.MulticastResponder;
import com.zink.fly.kit.RequestHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DiscoveryConnector
implements RequestHandler,
Callable {
    private static final int DEFAULT_PING_INTERVAL = 5000;
    private static final int DEFAULT_PING_TIMEOUT = 2000;
    private InetAddress remoteAddress;
    private FlyPinger pinger;
    private int pingInterval = 5000;
    private ExecutorService requestListener;
    private MulticastResponder responder;
    private boolean currentlyConnected = false;
    private String[] tags;
    private final StringBuilder sb = new StringBuilder();
    private final char SPACE_CHAR = (char)32;

    public DiscoveryConnector(InetAddress inetAddress) {
        this.remoteAddress = inetAddress;
        this.pinger = new FlyPinger(2000L);
        this.responder = new MulticastResponder();
        this.requestListener = Executors.newSingleThreadExecutor();
        this.requestListener.submit(new MulticastRequestListener(this));
    }

    public Object call() {
        try {
            boolean bl = true;
            while (!Thread.interrupted()) {
                try {
                    this.tags = this.pinger.ping(this.remoteAddress);
                    if (this.tags != null && this.tags.length != 0) {
                        this.tags[0] = this.tags[0] + ":" + this.remoteAddress.getHostAddress();
                        if (!this.currentlyConnected) {
                            this.currentlyConnected = true;
                            bl = true;
                        }
                    } else if (this.currentlyConnected) {
                        this.currentlyConnected = false;
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bl) {
                    if (this.currentlyConnected) {
                        System.out.println("<~> " + this.remoteAddress.getHostAddress());
                    } else {
                        System.out.println(">~< " + this.remoteAddress.getHostAddress());
                    }
                    bl = false;
                }
                Thread.sleep(this.pingInterval);
            }
        }
        catch (Exception exception) {
            System.err.println("Tunnel thread broken " + exception.toString());
        }
        finally {
            this.requestListener.shutdown();
        }
        return null;
    }

    @Override
    public void request(String string) {
        if (this.currentlyConnected) {
            this.sb.setLength(0);
            boolean bl = Boolean.TRUE;
            for (String string2 : this.tags) {
                if (bl) {
                    bl = Boolean.FALSE;
                } else {
                    this.sb.append(' ');
                }
                this.sb.append(string2);
            }
            this.responder.sendResponse(this.sb.toString());
        }
    }

    public static void main(String[] stringArray) throws UnknownHostException {
        if (stringArray.length < 1) {
            System.out.println("Usage : DiscoveryConnector IPAddress [IPAddress  ...]");
            System.exit(1);
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            for (String string : stringArray) {
                InetAddress inetAddress = InetAddress.getByName(string);
                executorService.submit(new DiscoveryConnector(inetAddress));
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to start DiscoveryConnector with the following error.");
            exception.printStackTrace(System.err);
            executorService.shutdownNow();
        }
    }
}

