/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FieldCodec;
import com.zink.fly.FlyAccessException;
import com.zink.fly.Notifiable;
import com.zink.fly.NotifyHandler;
import com.zink.fly.NotifyHandlerReturningEntry;
import com.zink.fly.stub.NotifyMessageDispatcher;
import com.zink.fly.stub.Remoter;
import com.zink.fly.stub.TypeChain;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public class MethodCodec {
    public static final int FLY_HEADER = -88997888;
    private static final int PING = 0;
    private static final int READ = 1;
    private static final int TAKE = 2;
    private static final int WRITE = 3;
    private static final int NOTIFY = 4;
    private static final int SNAPSHOT = 5;
    private static final int READ_MANY = 6;
    private static final int TAKE_MANY = 7;
    private static final int WRITE_MANY = 8;
    private static final int STATS = 9;
    private static final int NOTIFY_WRITE = 20;
    private static final int NOTIFY_TAKE = 21;
    private static final int NOTIFY_WRITE_OBJECT = 22;
    private static final int NOTIFY_TAKE_OBJECT = 23;
    public static final int CLASS_STRCUTURE_PREAMBLE = 10;
    private TypeChain typeChain;
    private Remoter remoter;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(1048);
    private DataOutputStream dos = new DataOutputStream(this.bos);
    private DataInputStream dis = null;

    public MethodCodec(Remoter remoter, FieldCodec fieldCodec) {
        this.remoter = remoter;
        this.typeChain = new TypeChain(remoter, fieldCodec);
        NotifyMessageDispatcher notifyMessageDispatcher = new NotifyMessageDispatcher(this.typeChain);
        remoter.setNotifyMessageDispatcher(notifyMessageDispatcher);
        this.dis = remoter.getDataInputStream();
    }

    public synchronized Object read(Object object, long l) {
        Object object2 = null;
        try {
            this.bos.reset();
            this.dos.writeInt(-88997887);
            this.dos.writeInt(this.typeChain.getChannel(object));
            this.typeChain.writeObject(this.dos, object);
            this.dos.writeLong(l);
            long l2 = this.remoter.sendOperation(this.bos.toByteArray());
            if (l2 > 0L) {
                object2 = this.typeChain.readObject(this.dis, l2, object.getClass());
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return object2;
    }

    public synchronized Object take(Object object, long l) {
        Object object2 = null;
        try {
            this.bos.reset();
            this.dos.writeInt(-88997886);
            this.dos.writeInt(this.typeChain.getChannel(object));
            this.typeChain.writeObject(this.dos, object);
            this.dos.writeLong(l);
            byte[] byArray = this.bos.toByteArray();
            long l2 = this.remoter.sendOperation(byArray);
            if (l2 > 0L) {
                object2 = this.typeChain.readObject(this.dis, l2, object.getClass());
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return object2;
    }

    Object snapshot(Object object) {
        return object;
    }

    public synchronized long write(Object object, long l) {
        long l2 = 0L;
        try {
            this.bos.reset();
            this.dos.writeInt(-88997885);
            int n = this.typeChain.getChannel(object);
            this.dos.writeInt(n);
            this.typeChain.writeIDObject(this.dos, object, UUID.randomUUID());
            this.dos.writeLong(l);
            l2 = this.remoter.sendOperation(this.bos.toByteArray());
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return l2;
    }

    synchronized Collection readMany(Object object, long l) {
        ArrayList<Object> arrayList = new ArrayList<Object>((int)l);
        try {
            this.bos.reset();
            this.dos.writeInt(-88997882);
            int n = this.typeChain.getChannel(object);
            this.dos.writeInt(n);
            this.typeChain.writeObject(this.dos, object);
            this.dos.writeLong(l);
            long l2 = this.remoter.sendOperation(this.bos.toByteArray());
            int n2 = 0;
            while ((long)n2 < l2) {
                long l3 = this.dis.readLong();
                arrayList.add(this.typeChain.readObject(this.dis, l3, object.getClass()));
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return arrayList;
    }

    synchronized Collection takeMany(Object object, long l) {
        ArrayList<Object> arrayList = new ArrayList<Object>((int)l);
        try {
            this.bos.reset();
            this.dos.writeInt(-88997881);
            this.dos.writeInt(this.typeChain.getChannel(object));
            this.typeChain.writeObject(this.dos, object);
            this.dos.writeLong(l);
            long l2 = this.remoter.sendOperation(this.bos.toByteArray());
            int n = 0;
            while ((long)n < l2) {
                long l3 = this.dis.readLong();
                arrayList.add(this.typeChain.readObject(this.dis, l3, object.getClass()));
                ++n;
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return arrayList;
    }

    boolean notifyWrite(Object object, Notifiable notifiable, long l) {
        int n = 0;
        if (notifiable instanceof NotifyHandler) {
            n = -88997868;
        }
        if (notifiable instanceof NotifyHandlerReturningEntry) {
            n = -88997866;
        }
        this.checkNotifyOpcode(n);
        long l2 = this.notifyWrite(n, object, l);
        this.remoter.addNotifyDetails(l2, notifiable, object.getClass());
        this.remoter.setMessageComplete();
        return Boolean.TRUE;
    }

    private synchronized long notifyWrite(int n, Object object, long l) {
        long l2 = 0L;
        try {
            this.bos.reset();
            this.dos.writeInt(n);
            int n2 = this.typeChain.getChannel(object);
            this.dos.writeInt(n2);
            this.typeChain.writeObject(this.dos, object);
            this.dos.writeLong(l);
            l2 = this.remoter.sendOperation(this.bos.toByteArray());
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return l2;
    }

    boolean notifyTake(Object object, Notifiable notifiable, long l) {
        int n = 0;
        if (notifiable instanceof NotifyHandler) {
            n = -88997867;
        }
        if (notifiable instanceof NotifyHandlerReturningEntry) {
            n = -88997865;
        }
        this.checkNotifyOpcode(n);
        long l2 = this.notifyTake(n, object, l);
        this.remoter.addNotifyDetails(l2, notifiable, object.getClass());
        this.remoter.setMessageComplete();
        return Boolean.TRUE;
    }

    private synchronized long notifyTake(int n, Object object, long l) {
        long l2 = 0L;
        try {
            this.bos.reset();
            this.dos.writeInt(n);
            int n2 = this.typeChain.getChannel(object);
            this.dos.writeInt(n2);
            this.typeChain.writeObject(this.dos, object);
            this.dos.writeLong(l);
            l2 = this.remoter.sendOperation(this.bos.toByteArray());
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        this.remoter.setMessageComplete();
        return l2;
    }

    private void checkNotifyOpcode(int n) {
        if (n == 0) {
            String string = "Handler must implement NotifyHandler or NotifyHandlerReturningEntry";
            throw new IllegalArgumentException(string);
        }
    }
}

