/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.api.model;

import com.getyourguide.openapi.validation.api.log.LogLevel;
import com.getyourguide.openapi.validation.api.model.Direction;
import com.getyourguide.openapi.validation.api.model.RequestMetaData;
import java.util.Optional;

public class OpenApiViolation {
    private final LogLevel level;
    private final Direction direction;
    private final RequestMetaData requestMetaData;
    private final String body;
    private final String rule;
    private final Optional<String> operationId;
    private final Optional<String> normalizedPath;
    private final Optional<String> instance;
    private final Optional<Integer> responseStatus;
    private final String message;

    OpenApiViolation(LogLevel level, Direction direction, RequestMetaData requestMetaData, String body, String rule, Optional<String> operationId, Optional<String> normalizedPath, Optional<String> instance, Optional<Integer> responseStatus, String message) {
        this.level = level;
        this.direction = direction;
        this.requestMetaData = requestMetaData;
        this.body = body;
        this.rule = rule;
        this.operationId = operationId;
        this.normalizedPath = normalizedPath;
        this.instance = instance;
        this.responseStatus = responseStatus;
        this.message = message;
    }

    public static OpenApiViolationBuilder builder() {
        return new OpenApiViolationBuilder();
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    public String getBody() {
        return this.body;
    }

    public String getRule() {
        return this.rule;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public Optional<String> getNormalizedPath() {
        return this.normalizedPath;
    }

    public Optional<String> getInstance() {
        return this.instance;
    }

    public Optional<Integer> getResponseStatus() {
        return this.responseStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public static class OpenApiViolationBuilder {
        private LogLevel level;
        private Direction direction;
        private RequestMetaData requestMetaData;
        private String body;
        private String rule;
        private Optional<String> operationId;
        private Optional<String> normalizedPath;
        private Optional<String> instance;
        private Optional<Integer> responseStatus;
        private String message;

        OpenApiViolationBuilder() {
        }

        public OpenApiViolationBuilder level(LogLevel level) {
            this.level = level;
            return this;
        }

        public OpenApiViolationBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        public OpenApiViolationBuilder requestMetaData(RequestMetaData requestMetaData) {
            this.requestMetaData = requestMetaData;
            return this;
        }

        public OpenApiViolationBuilder body(String body) {
            this.body = body;
            return this;
        }

        public OpenApiViolationBuilder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public OpenApiViolationBuilder operationId(Optional<String> operationId) {
            this.operationId = operationId;
            return this;
        }

        public OpenApiViolationBuilder normalizedPath(Optional<String> normalizedPath) {
            this.normalizedPath = normalizedPath;
            return this;
        }

        public OpenApiViolationBuilder instance(Optional<String> instance) {
            this.instance = instance;
            return this;
        }

        public OpenApiViolationBuilder responseStatus(Optional<Integer> responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public OpenApiViolationBuilder message(String message) {
            this.message = message;
            return this;
        }

        public OpenApiViolation build() {
            return new OpenApiViolation(this.level, this.direction, this.requestMetaData, this.body, this.rule, this.operationId, this.normalizedPath, this.instance, this.responseStatus, this.message);
        }

        public String toString() {
            return "OpenApiViolation.OpenApiViolationBuilder(level=" + this.level + ", direction=" + this.direction + ", requestMetaData=" + this.requestMetaData + ", body=" + this.body + ", rule=" + this.rule + ", operationId=" + this.operationId + ", normalizedPath=" + this.normalizedPath + ", instance=" + this.instance + ", responseStatus=" + this.responseStatus + ", message=" + this.message + ")";
        }
    }
}

