/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.api.selector;

import com.getyourguide.openapi.validation.api.model.RequestMetaData;
import com.getyourguide.openapi.validation.api.model.ResponseMetaData;
import com.getyourguide.openapi.validation.api.selector.TrafficSelector;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultTrafficSelector
implements TrafficSelector {
    private static final double SAMPLE_RATE_DEFAULT = 0.001;
    private final double sampleRate;
    private final Set<String> excludedPaths;

    public DefaultTrafficSelector(Double sampleRate, Set<String> excludedPaths) {
        this.sampleRate = sampleRate != null ? sampleRate : 0.001;
        this.excludedPaths = excludedPaths != null ? excludedPaths : Set.of();
    }

    @Override
    public boolean shouldRequestBeValidated(RequestMetaData request) {
        return this.isRandomlySelectedBySampleRate() && !this.isExcludedRequest(request);
    }

    private boolean isRandomlySelectedBySampleRate() {
        return this.sampleRate > 0.0 && (this.sampleRate >= 1.0 || ThreadLocalRandom.current().nextInt((int)(1.0 / this.sampleRate)) == 0);
    }

    @Override
    public boolean canRequestBeValidated(RequestMetaData request) {
        return !DefaultTrafficSelector.methodEquals(request.getMethod(), "OPTIONS") && this.isContentTypeSupported(request.getContentType());
    }

    @Override
    public boolean canResponseBeValidated(RequestMetaData request, ResponseMetaData response) {
        return !DefaultTrafficSelector.methodEquals(request.getMethod(), "OPTIONS") && this.isContentTypeSupported(response.getContentType());
    }

    private boolean isExcludedRequest(RequestMetaData request) {
        return this.excludedPaths.contains(request.getUri().getPath());
    }

    private static boolean methodEquals(String method, String expectedMethod) {
        return method.equalsIgnoreCase(expectedMethod);
    }

    private boolean isContentTypeSupported(String contentType) {
        if (contentType == null) {
            return true;
        }
        String contentTypeLowerCase = contentType.toLowerCase();
        return contentTypeLowerCase.contains("application/json") || contentTypeLowerCase.contains("application/xml") || contentTypeLowerCase.contains("application/xhtml+xml") || contentTypeLowerCase.contains("text/html") || contentTypeLowerCase.contains("text/xml");
    }
}

