/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.api.metrics;

import com.getyourguide.openapi.validation.api.metrics.MetricTag;
import com.getyourguide.openapi.validation.api.metrics.MetricsReporter;
import com.getyourguide.openapi.validation.api.metrics.client.MetricsClient;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import java.util.ArrayList;
import java.util.List;

public class DefaultMetricsReporter
implements MetricsReporter {
    private final MetricsClient metricsClient;
    private final Configuration configuration;

    @Override
    public void reportViolation(OpenApiViolation violation) {
        this.metricsClient.increment(this.buildMetricName(".error"), this.createTagsForViolation(violation));
    }

    @Override
    public void reportStartup(boolean isValidationEnabled) {
        this.metricsClient.increment(this.buildMetricName(".startup"), this.createTagsForStartup(isValidationEnabled));
    }

    @Override
    public void reportValidationHeartbeat() {
        this.metricsClient.increment(this.buildMetricName(".validation_heartbeat"), this.createTagsForValidation());
    }

    private String buildMetricName(String suffix) {
        return this.configuration.getMetricName() + suffix;
    }

    private MetricTag[] createTagsForViolation(OpenApiViolation violation) {
        ArrayList<MetricTag> tags = new ArrayList<MetricTag>();
        tags.add(new MetricTag("type", violation.getDirection().toString().toLowerCase()));
        tags.add(new MetricTag("method", violation.getRequestMetaData().getMethod().toLowerCase()));
        violation.getNormalizedPath().ifPresent(path -> tags.add(new MetricTag("path", (String)path)));
        violation.getResponseStatus().ifPresent(responseStatus -> tags.add(new MetricTag("status", responseStatus.toString())));
        this.addAdditionalTags(tags);
        return (MetricTag[])tags.toArray(MetricTag[]::new);
    }

    private MetricTag[] createTagsForStartup(boolean isValidationEnabled) {
        ArrayList<MetricTag> tags = new ArrayList<MetricTag>();
        tags.add(new MetricTag("validation_enabled", String.valueOf(isValidationEnabled)));
        this.addAdditionalTags(tags);
        return (MetricTag[])tags.toArray(MetricTag[]::new);
    }

    private MetricTag[] createTagsForValidation() {
        ArrayList<MetricTag> tags = new ArrayList<MetricTag>();
        this.addAdditionalTags(tags);
        return (MetricTag[])tags.toArray(MetricTag[]::new);
    }

    private void addAdditionalTags(ArrayList<MetricTag> tags) {
        if (this.configuration.getMetricAdditionalTags() != null) {
            tags.addAll(this.configuration.getMetricAdditionalTags());
        }
    }

    public DefaultMetricsReporter(MetricsClient metricsClient, Configuration configuration) {
        this.metricsClient = metricsClient;
        this.configuration = configuration;
    }

    public static class Configuration {
        private final String metricName;
        private final List<MetricTag> metricAdditionalTags;

        Configuration(String metricName, List<MetricTag> metricAdditionalTags) {
            this.metricName = metricName;
            this.metricAdditionalTags = metricAdditionalTags;
        }

        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        public String getMetricName() {
            return this.metricName;
        }

        public List<MetricTag> getMetricAdditionalTags() {
            return this.metricAdditionalTags;
        }

        public static class ConfigurationBuilder {
            private String metricName;
            private List<MetricTag> metricAdditionalTags;

            ConfigurationBuilder() {
            }

            public ConfigurationBuilder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public ConfigurationBuilder metricAdditionalTags(List<MetricTag> metricAdditionalTags) {
                this.metricAdditionalTags = metricAdditionalTags;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.metricName, this.metricAdditionalTags);
            }

            public String toString() {
                return "DefaultMetricsReporter.Configuration.ConfigurationBuilder(metricName=" + this.metricName + ", metricAdditionalTags=" + this.metricAdditionalTags + ")";
            }
        }
    }
}

