/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.api.model;

import com.getyourguide.openapi.validation.api.log.LogLevel;
import com.getyourguide.openapi.validation.api.model.ValidatorConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ValidatorConfigurationBuilder {
    private LogLevel levelResolverDefaultLevel;
    private Map<String, LogLevel> levelResolverLevels;
    private List<ValidatorConfiguration.PathPatternSpec> specificationPaths;

    public ValidatorConfigurationBuilder levelResolverDefaultLevel(LogLevel levelResolverDefaultLevel) {
        this.levelResolverDefaultLevel = levelResolverDefaultLevel;
        return this;
    }

    public ValidatorConfigurationBuilder levelResolverLevel(String messageKey, LogLevel level) {
        if (this.levelResolverLevels == null) {
            this.levelResolverLevels = new HashMap<String, LogLevel>();
        }
        this.levelResolverLevels.put(messageKey, level);
        return this;
    }

    public ValidatorConfigurationBuilder specificationPath(Pattern pathPattern, String specPath) {
        if (this.specificationPaths == null) {
            this.specificationPaths = new ArrayList<ValidatorConfiguration.PathPatternSpec>();
        }
        this.specificationPaths.add(new ValidatorConfiguration.PathPatternSpec(pathPattern, specPath));
        return this;
    }

    public ValidatorConfiguration build() {
        return new ValidatorConfiguration(this.levelResolverDefaultLevel, this.levelResolverLevels, this.specificationPaths);
    }

    public String toString() {
        return "ValidatorConfigurationBuilder(levelResolverDefaultLevel=" + this.levelResolverDefaultLevel + ", levelResolverLevels=" + this.levelResolverLevels + ")";
    }
}

