/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core;

import com.getyourguide.openapi.validation.api.log.LoggerExtension;
import com.getyourguide.openapi.validation.api.log.ViolationLogger;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultViolationLogger
implements ViolationLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultViolationLogger.class);
    private final LoggerExtension loggerExtension;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void log(OpenApiViolation violation) {
        try (Closeable ignored = this.loggerExtension.addToLoggingContext(this.buildLoggingContext(violation));){
            switch (violation.getLevel()) {
                case INFO: {
                    log.info(violation.getLogMessage());
                    return;
                }
                case WARN: {
                    log.warn(violation.getLogMessage());
                    return;
                }
                case ERROR: {
                    log.error(violation.getLogMessage());
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            log.error("[OpenAPI Validation] Could not add to LoggingContext", (Throwable)e);
        }
    }

    private Map<String, String> buildLoggingContext(OpenApiViolation violation) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("validation.rule", violation.getRule());
        violation.getNormalizedPath().ifPresent(normalizedPath -> context.put("validation.api.path", (String)normalizedPath));
        violation.getOperationId().ifPresent(operationId -> context.put("validation.api.operation_id", (String)operationId));
        violation.getInstance().ifPresent(instance -> context.put("validation.instance", (String)instance));
        violation.getParameter().ifPresent(instance -> context.put("validation.parameter", (String)instance));
        return context;
    }

    @Generated
    public DefaultViolationLogger(LoggerExtension loggerExtension) {
        this.loggerExtension = loggerExtension;
    }
}

