/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.getyourguide.openapi.validation.api.log.LogLevel;
import com.getyourguide.openapi.validation.api.model.ValidatorConfiguration;
import com.getyourguide.openapi.validation.core.validator.MultipleSpecOpenApiInteractionValidatorWrapper;
import com.getyourguide.openapi.validation.core.validator.OpenApiInteractionValidatorWrapper;
import com.getyourguide.openapi.validation.core.validator.SingleSpecOpenApiInteractionValidatorWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiInteractionValidatorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiInteractionValidatorFactory.class);

    @Nullable
    public OpenApiInteractionValidatorWrapper build(String specificationFilePath, ValidatorConfiguration configuration) {
        if (configuration.getSpecificationPaths() != null && !configuration.getSpecificationPaths().isEmpty()) {
            return this.buildMultipleSpecOpenApiInteractionValidatorWrapper(configuration);
        }
        Optional<String> specOptional = this.loadOpenAPISpec(specificationFilePath);
        if (specOptional.isEmpty()) {
            log.info("OpenAPI spec file `{}` could not be found [validation disabled]", (Object)specificationFilePath);
            return null;
        }
        return this.buildSingleSpecOpenApiInteractionValidatorWrapper(specOptional.get(), configuration.getLevelResolverLevels(), configuration.getLevelResolverDefaultLevel());
    }

    private MultipleSpecOpenApiInteractionValidatorWrapper buildMultipleSpecOpenApiInteractionValidatorWrapper(ValidatorConfiguration configuration) {
        List<Pair<Pattern, OpenApiInteractionValidatorWrapper>> validators = configuration.getSpecificationPaths().stream().map(entry -> {
            String path = entry.specificationFilePath();
            Optional<String> specOptional = this.loadSpecFromPath(path).or(() -> this.loadSpecFromResources(path));
            if (specOptional.isEmpty()) {
                log.error("[OpenAPI Validation] Spec file {} could not be found", (Object)path);
                return null;
            }
            SingleSpecOpenApiInteractionValidatorWrapper validator = this.buildSingleSpecOpenApiInteractionValidatorWrapper(specOptional.get(), configuration.getLevelResolverLevels(), configuration.getLevelResolverDefaultLevel());
            return Pair.of((Object)entry.pathPattern(), (Object)validator);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (validators.isEmpty()) {
            log.info("OpenAPI spec file(s) could not be found [validation disabled]");
            return null;
        }
        return new MultipleSpecOpenApiInteractionValidatorWrapper(validators);
    }

    @Nullable
    private SingleSpecOpenApiInteractionValidatorWrapper buildSingleSpecOpenApiInteractionValidatorWrapper(String spec, Map<String, LogLevel> levelResolverLevels, LogLevel levelResolverDefaultLevel) {
        try {
            OpenApiInteractionValidator validator = OpenApiInteractionValidator.createForInlineApiSpecification((String)spec).withResolveRefs(true).withResolveCombinators(true).withLevelResolver(this.buildLevelResolver(levelResolverLevels, levelResolverDefaultLevel)).withStrictOperationPathMatching().build();
            return new SingleSpecOpenApiInteractionValidatorWrapper(validator);
        }
        catch (Throwable e) {
            log.error("[OpenAPI Validation] Could not initialize OpenApiInteractionValidator [validation disabled]", e);
            return null;
        }
    }

    @NonNull
    private Optional<String> loadOpenAPISpec(String specificationFilePath) {
        return this.loadSpecFromPath(specificationFilePath).or(() -> this.loadSpecFromResources(specificationFilePath)).or(() -> this.loadSpecFromResources("openapi.yaml")).or(() -> this.loadSpecFromResources("openapi.json")).or(() -> this.loadSpecFromResources("spec.yaml")).or(() -> this.loadSpecFromResources("spec.json"));
    }

    private Optional<String> loadSpecFromPath(String path) {
        if (path == null) {
            return Optional.empty();
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return Optional.empty();
            }
            return Optional.of(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            log.warn("Error while loading spec from " + path, (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<String> loadSpecFromResources(String resourceFileLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LevelResolver buildLevelResolver(Map<String, LogLevel> levelResolverLevels, LogLevel levelResolverDefaultLevel) {
        LevelResolver.Builder builder = LevelResolver.create().withLevel("validation.schema.additionalProperties", ValidationReport.Level.IGNORE);
        if (levelResolverLevels != null && !levelResolverLevels.isEmpty()) {
            builder.withLevels(levelResolverLevels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mapLevel((LogLevel)entry.getValue()).orElse(ValidationReport.Level.INFO))));
        }
        this.mapLevel(levelResolverDefaultLevel).ifPresent(arg_0 -> ((LevelResolver.Builder)builder).withDefaultLevel(arg_0));
        return builder.build();
    }

    private Optional<ValidationReport.Level> mapLevel(LogLevel level) {
        if (level == null) {
            return Optional.empty();
        }
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case LogLevel.ERROR -> Optional.of(ValidationReport.Level.ERROR);
            case LogLevel.WARN -> Optional.of(ValidationReport.Level.WARN);
            case LogLevel.INFO -> Optional.of(ValidationReport.Level.INFO);
            case LogLevel.IGNORE -> Optional.of(ValidationReport.Level.IGNORE);
        };
    }
}

