/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.getyourguide.openapi.validation.api.log.OpenApiViolationHandler;
import com.getyourguide.openapi.validation.api.metrics.MetricsReporter;
import com.getyourguide.openapi.validation.api.model.Direction;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import com.getyourguide.openapi.validation.api.model.RequestMetaData;
import com.getyourguide.openapi.validation.api.model.ResponseMetaData;
import com.getyourguide.openapi.validation.core.OpenApiRequestValidationConfiguration;
import com.getyourguide.openapi.validation.core.mapper.ValidationReportToOpenApiViolationsMapper;
import com.getyourguide.openapi.validation.core.validator.OpenApiInteractionValidatorWrapper;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiRequestValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiRequestValidator.class);
    private final ThreadPoolExecutor threadPoolExecutor;
    private final OpenApiInteractionValidatorWrapper validator;
    private final ValidationReportToOpenApiViolationsMapper mapper;

    public OpenApiRequestValidator(ThreadPoolExecutor threadPoolExecutor, MetricsReporter metricsReporter, OpenApiInteractionValidatorWrapper validator, ValidationReportToOpenApiViolationsMapper mapper, OpenApiRequestValidationConfiguration configuration) {
        this.threadPoolExecutor = threadPoolExecutor;
        this.validator = validator;
        this.mapper = mapper;
        metricsReporter.reportStartup(validator != null, configuration.getSampleRate(), configuration.getValidationReportThrottleWaitSeconds());
    }

    public boolean isReady() {
        return this.validator != null;
    }

    public void validateRequestObjectAsync(RequestMetaData request, @Nullable ResponseMetaData response, String requestBody, OpenApiViolationHandler listener) {
        this.executeAsync(() -> {
            List<OpenApiViolation> violations = this.validateRequestObject(request, response, requestBody);
            violations.forEach(arg_0 -> ((OpenApiViolationHandler)listener).onOpenApiViolation(arg_0));
        });
    }

    public void validateResponseObjectAsync(RequestMetaData request, ResponseMetaData response, String responseBody, OpenApiViolationHandler listener) {
        this.executeAsync(() -> {
            List<OpenApiViolation> violations = this.validateResponseObject(request, response, responseBody);
            violations.forEach(arg_0 -> ((OpenApiViolationHandler)listener).onOpenApiViolation(arg_0));
        });
    }

    private void executeAsync(Runnable command) {
        try {
            this.threadPoolExecutor.execute(command);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public List<OpenApiViolation> validateRequestObject(RequestMetaData request, String requestBody) {
        return this.validateRequestObject(request, null, requestBody);
    }

    public List<OpenApiViolation> validateRequestObject(RequestMetaData request, @Nullable ResponseMetaData response, String requestBody) {
        try {
            SimpleRequest simpleRequest = OpenApiRequestValidator.buildSimpleRequest(request, requestBody);
            ValidationReport result = this.validator.validateRequest(simpleRequest);
            return this.mapper.map(result, request, response, Direction.REQUEST, requestBody);
        }
        catch (Exception e) {
            log.error("[OpenAPI Validation] Could not validate request", (Throwable)e);
            return List.of();
        }
    }

    private static SimpleRequest buildSimpleRequest(RequestMetaData request, String requestBody) {
        SimpleRequest.Builder requestBuilder = new SimpleRequest.Builder(request.getMethod(), request.getUri().getPath());
        URLEncodedUtils.parse((URI)request.getUri(), (Charset)StandardCharsets.UTF_8).forEach(p -> requestBuilder.withQueryParam(p.getName(), new String[]{OpenApiRequestValidator.nullSafeUrlDecode(p.getValue())}));
        if (requestBody != null) {
            requestBuilder.withBody(requestBody);
        }
        request.getHeaders().forEach((x$0, xva$1) -> requestBuilder.withHeader(x$0, new String[]{xva$1}));
        return requestBuilder.build();
    }

    private static String nullSafeUrlDecode(String value) {
        if (value == null) {
            return null;
        }
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public List<OpenApiViolation> validateResponseObject(RequestMetaData request, ResponseMetaData response, String responseBody) {
        try {
            SimpleResponse.Builder responseBuilder = new SimpleResponse.Builder(response.getStatusCode().intValue());
            response.getHeaders().forEach((x$0, xva$1) -> responseBuilder.withHeader(x$0, new String[]{xva$1}));
            if (responseBody != null) {
                responseBuilder.withContentType(response.getContentType());
                responseBuilder.withBody(responseBody);
            }
            ValidationReport result = this.validator.validateResponse(request.getUri().getPath(), Request.Method.valueOf((String)request.getMethod().toUpperCase()), responseBuilder.build());
            return this.mapper.map(result, request, response, Direction.RESPONSE, responseBody);
        }
        catch (Exception e) {
            log.error("[OpenAPI Validation] Could not validate response", (Throwable)e);
            return List.of();
        }
    }
}

